/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.manipulator.mutable.entity;

import com.google.common.base.Preconditions;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableStuckArrowsData;
import org.spongepowered.api.data.manipulator.mutable.entity.StuckArrowsData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.immutable.entity.ImmutableSpongeStuckArrowsData;
import org.spongepowered.common.data.manipulator.mutable.common.AbstractIntData;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class SpongeStuckArrowsData
extends AbstractIntData<StuckArrowsData, ImmutableStuckArrowsData>
implements StuckArrowsData {
    public SpongeStuckArrowsData() {
        this(0);
    }

    public SpongeStuckArrowsData(int arrows) {
        super(StuckArrowsData.class, arrows, Keys.STUCK_ARROWS);
    }

    @Override
    protected Value<?> getValueGetter() {
        return this.stuckArrows();
    }

    @Override
    public MutableBoundedValue<Integer> stuckArrows() {
        return SpongeValueFactory.boundedBuilder(Keys.STUCK_ARROWS).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(0).actualValue((Integer)this.getValue()).build();
    }

    @Override
    public StuckArrowsData setValue(Integer value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"Stuck arrows must be greater than or equal to zero");
        return (StuckArrowsData)super.setValue(value);
    }

    @Override
    public StuckArrowsData copy() {
        return new SpongeStuckArrowsData((Integer)this.getValue());
    }

    @Override
    public ImmutableStuckArrowsData asImmutable() {
        return new ImmutableSpongeStuckArrowsData((Integer)this.getValue());
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Keys.STUCK_ARROWS, this.getValue());
    }
}

