/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.TileEntityArchetype;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.api.world.schematic.BlockPaletteTypes;
import org.spongepowered.api.world.schematic.Schematic;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.block.SpongeTileEntityArchetypeBuilder;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.registry.type.block.TileEntityTypeRegistryModule;
import org.spongepowered.common.util.gen.ArrayMutableBlockBuffer;
import org.spongepowered.common.world.schematic.BimapPalette;
import org.spongepowered.common.world.schematic.GlobalPalette;
import org.spongepowered.common.world.schematic.SpongeSchematic;

public class SchematicTranslator
implements DataTranslator<Schematic> {
    private static final SchematicTranslator INSTANCE = new SchematicTranslator();
    private static final TypeToken<Schematic> TYPE_TOKEN = TypeToken.of(Schematic.class);
    private static final int VERSION = 1;
    private static final int MAX_SIZE = 65535;

    public static SchematicTranslator get() {
        return INSTANCE;
    }

    private SchematicTranslator() {
    }

    @Override
    public String getId() {
        return "sponge:schematic";
    }

    @Override
    public String getName() {
        return "Sponge Schematic Translator";
    }

    @Override
    public TypeToken<Schematic> getToken() {
        return TYPE_TOKEN;
    }

    @Override
    public Schematic translate(DataView view) throws InvalidDataException {
        BlockPalette palette;
        int version = view.getInt(DataQueries.Schematic.VERSION).get();
        if (version != 1) {
            throw new InvalidDataException(String.format("Unknown schematic version %d (current version is %d)", version, 1));
        }
        DataView metadata = view.getView(DataQueries.Schematic.METADATA).orElse(null);
        short width = view.getShort(DataQueries.Schematic.WIDTH).get();
        short height = view.getShort(DataQueries.Schematic.HEIGHT).get();
        short length = view.getShort(DataQueries.Schematic.LENGTH).get();
        if (width > 65535 || height > 65535 || length > 65535) {
            throw new InvalidDataException(String.format("Schematic is larger than maximum allowable size (found: (%d, %d, %d) max: (%d, %<d, %<d)", width, (int)height, (int)length, 65535));
        }
        int[] offset = view.get(DataQueries.Schematic.OFFSET).orElse(null);
        if (offset == null) {
            offset = new int[3];
        }
        if (offset.length != 3) {
            throw new InvalidDataException("Schematic offset was not of length 3");
        }
        Optional<DataView> paletteData = view.getView(DataQueries.Schematic.PALETTE);
        int palette_max = view.getInt(DataQueries.Schematic.PALETTE_MAX).orElse(65535);
        if (paletteData.isPresent()) {
            palette = new BimapPalette(palette_max != 65535 ? palette_max : 64);
            DataView paletteMap = paletteData.get();
            Set<DataQuery> paletteKeys = paletteMap.getKeys(false);
            for (DataQuery key : paletteKeys) {
                BlockState state = Sponge.getRegistry().getType(BlockState.class, key.getParts().get(0)).get();
                ((BimapPalette)palette).assign(state, paletteMap.getInt(key).get());
            }
        } else {
            palette = GlobalPalette.instance;
        }
        ArrayMutableBlockBuffer buffer = new ArrayMutableBlockBuffer(palette, new Vector3i(-offset[0], -offset[1], -offset[2]), new Vector3i(width, height, length));
        byte[] blockdata = (byte[])view.get(DataQueries.Schematic.BLOCK_DATA).get();
        int index = 0;
        int i = 0;
        int value = 0;
        int varint_length = 0;
        while (i < blockdata.length) {
            value = 0;
            varint_length = 0;
            while (true) {
                value |= (blockdata[i] & 0x7F) << varint_length++ * 7;
                if (varint_length > 5) {
                    throw new RuntimeException("VarInt too big (probably corrupted data)");
                }
                if ((blockdata[i] & 0x80) != 128) {
                    ++i;
                    break;
                }
                ++i;
            }
            int y = index / (width * length);
            int z = index % (width * length) / width;
            int x = index % (width * length) % width;
            BlockState state = palette.get(value).get();
            buffer.setBlock(x - offset[0], y - offset[1], z - offset[2], state, SpongeImpl.getImplementationCause());
            ++index;
        }
        HashMap tiles = Maps.newHashMap();
        List tiledata = view.getViewList(DataQueries.Schematic.TILEENTITY_DATA).orElse(null);
        if (tiledata != null) {
            for (DataView tile : tiledata) {
                int[] pos = (int[])tile.get(DataQueries.Schematic.TILEENTITY_POS).get();
                if (offset.length != 3) {
                    throw new InvalidDataException("Schematic tileentity pos was not of length 3");
                }
                CatalogType type = TileEntityTypeRegistryModule.getInstance().getForClass((Class)TileEntity.field_190562_f.func_82594_a((Object)new ResourceLocation(tile.getString(DataQuery.of("id")).get())));
                TileEntityArchetype archetype = new SpongeTileEntityArchetypeBuilder().state(buffer.getBlock(pos[0] - offset[0], pos[1] - offset[1], pos[2] - offset[2])).tileData(tile).tile((TileEntityType)type).build();
                tiles.put(new Vector3i(pos[0] - offset[0], pos[1] - offset[1], pos[2] - offset[2]), archetype);
            }
        }
        SpongeSchematic schematic = new SpongeSchematic(buffer, tiles, metadata);
        return schematic;
    }

    @Override
    public DataContainer translate(Schematic schematic) throws InvalidDataException {
        DataContainer data = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);
        this.addTo(schematic, (DataView)data);
        return data;
    }

    @Override
    public DataView addTo(Schematic schematic, DataView data) {
        int xMin = schematic.getBlockMin().getX();
        int yMin = schematic.getBlockMin().getY();
        int zMin = schematic.getBlockMin().getZ();
        int width = schematic.getBlockSize().getX();
        int height = schematic.getBlockSize().getY();
        int length = schematic.getBlockSize().getZ();
        if (width > 65535 || height > 65535 || length > 65535) {
            throw new IllegalArgumentException(String.format("Schematic is larger than maximum allowable size (found: (%d, %d, %d) max: (%d, %<d, %<d)", width, height, length, 65535));
        }
        data.set(DataQueries.Schematic.WIDTH, (Object)width);
        data.set(DataQueries.Schematic.HEIGHT, (Object)height);
        data.set(DataQueries.Schematic.LENGTH, (Object)length);
        data.set(DataQueries.Schematic.VERSION, (Object)1);
        for (DataQuery metaKey : schematic.getMetadata().getKeys(false)) {
            data.set(DataQueries.Schematic.METADATA.then(metaKey), schematic.getMetadata().get(metaKey).get());
        }
        int[] offset = new int[]{-xMin, -yMin, -zMin};
        data.set(DataQueries.Schematic.OFFSET, offset);
        BlockPalette palette = schematic.getPalette();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(width * height * length);
        for (int y = 0; y < height; ++y) {
            int y0 = yMin + y;
            for (int z = 0; z < length; ++z) {
                int z0 = zMin + z;
                for (int x = 0; x < width; ++x) {
                    int x0 = xMin + x;
                    BlockState state = schematic.getBlock(x0, y0, z0);
                    int id = palette.getOrAssign(state);
                    while ((id & 0xFFFFFF80) != 0) {
                        buffer.write(id & 0x7F | 0x80);
                        id >>>= 7;
                    }
                    buffer.write(id);
                }
            }
        }
        data.set(DataQueries.Schematic.BLOCK_DATA, buffer.toByteArray());
        if (palette.getType() == BlockPaletteTypes.LOCAL) {
            DataQuery paletteQuery = DataQueries.Schematic.PALETTE;
            for (BlockState state : palette.getEntries()) {
                data.set(paletteQuery.then(state.getId()), (Object)palette.getOrAssign(state));
            }
            data.set(DataQueries.Schematic.PALETTE_MAX, (Object)palette.getHighestId());
        }
        ArrayList tileEntities = Lists.newArrayList();
        for (Map.Entry<Vector3i, TileEntityArchetype> entry : schematic.getTileEntityArchetypes().entrySet()) {
            Vector3i pos = entry.getKey();
            DataContainer tiledata = entry.getValue().getTileData();
            int[] apos = new int[]{pos.getX() - xMin, pos.getY() - yMin, pos.getZ() - zMin};
            tiledata.set(DataQueries.Schematic.TILEENTITY_POS, (Object)apos);
            if (!tiledata.contains(DataQueries.CONTENT_VERSION)) {
                tiledata.set(DataQueries.CONTENT_VERSION, (Object)1);
            }
            tileEntities.add(tiledata);
        }
        data.set(DataQueries.Schematic.TILEENTITY_DATA, tileEntities);
        return data;
    }
}

