/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.common;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.MobSpawnerData;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.util.weighted.WeightedSerializableObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.entity.EntityUtil;

public class SpawnerUtils {
    public static WeightedSerializableObject<EntityArchetype> getNextEntity(MobSpawnerBaseLogic logic) {
        int weight = logic.field_98282_f.field_76292_a;
        EntityType type = EntityUtil.fromNameToType(logic.field_98282_f.func_185277_b().func_74779_i("id")).orElse(EntityTypes.PIG);
        NBTTagCompound data = logic.field_98282_f.func_185277_b();
        EntityArchetype archetype = EntityArchetype.builder().type(type).entityData(NbtTranslator.getInstance().translateFrom(data)).build();
        return new WeightedSerializableObject<EntityArchetype>(archetype, weight);
    }

    public static void setNextEntity(MobSpawnerBaseLogic logic, WeightedSerializableObject<EntityArchetype> value) {
        NBTTagCompound compound = NbtTranslator.getInstance().translateData(((EntityArchetype)value.get()).getEntityData());
        if (!compound.func_74764_b("id")) {
            ResourceLocation resource = (ResourceLocation)EntityList.field_191308_b.func_177774_c(((EntityArchetype)value.get()).getType().getEntityClass());
            compound.func_74778_a("id", resource == null ? "" : resource.toString());
        }
        logic.func_184993_a(new WeightedSpawnerEntity((int)value.getWeight(), compound));
    }

    public static WeightedTable<EntityArchetype> getEntities(MobSpawnerBaseLogic logic) {
        WeightedTable<EntityArchetype> possibleEntities = new WeightedTable<EntityArchetype>();
        for (WeightedSpawnerEntity weightedEntity : logic.field_98285_e) {
            NBTTagCompound nbt = weightedEntity.func_185277_b();
            EntityType type = EntityUtil.fromNameToType(nbt.func_74779_i("id")).orElse(EntityTypes.PIG);
            EntityArchetype archetype = EntityArchetype.builder().type(type).entityData(NbtTranslator.getInstance().translateFrom(nbt)).build();
            possibleEntities.add((TableEntry<EntityArchetype>)new WeightedSerializableObject<EntityArchetype>(archetype, weightedEntity.field_76292_a));
        }
        return possibleEntities;
    }

    public static void setEntities(MobSpawnerBaseLogic logic, WeightedTable<EntityArchetype> table) {
        logic.field_98285_e.clear();
        for (TableEntry<EntityArchetype> tableEntry : table) {
            if (!(tableEntry instanceof WeightedObject)) continue;
            WeightedObject object = (WeightedObject)tableEntry;
            NBTTagCompound compound = NbtTranslator.getInstance().translateData(((EntityArchetype)object.get()).getEntityData());
            if (!compound.func_74764_b("id")) {
                compound.func_74778_a("id", ((ResourceLocation)EntityList.field_191308_b.func_177774_c(((EntityArchetype)object.get()).getType().getEntityClass())).toString());
            }
            logic.field_98285_e.add(new WeightedSpawnerEntity((int)tableEntry.getWeight(), compound));
        }
    }

    public static void applyData(MobSpawnerBaseLogic logic, Map<Key<?>, Object> values) {
        logic.field_98286_b = ((Short)values.get(Keys.SPAWNER_REMAINING_DELAY)).shortValue();
        logic.field_98283_g = ((Short)values.get(Keys.SPAWNER_MINIMUM_DELAY)).shortValue();
        logic.field_98293_h = ((Short)values.get(Keys.SPAWNER_MAXIMUM_DELAY)).shortValue();
        logic.field_98294_i = ((Short)values.get(Keys.SPAWNER_SPAWN_COUNT)).shortValue();
        logic.field_98292_k = ((Short)values.get(Keys.SPAWNER_MAXIMUM_NEARBY_ENTITIES)).shortValue();
        logic.field_98289_l = ((Short)values.get(Keys.SPAWNER_REQUIRED_PLAYER_RANGE)).shortValue();
        logic.field_98290_m = ((Short)values.get(Keys.SPAWNER_SPAWN_RANGE)).shortValue();
        SpawnerUtils.setNextEntity(logic, (WeightedSerializableObject)values.get(Keys.SPAWNER_NEXT_ENTITY_TO_SPAWN));
        SpawnerUtils.setEntities(logic, (WeightedTable)values.get(Keys.SPAWNER_ENTITIES));
    }

    public static void applyData(MobSpawnerBaseLogic logic, MobSpawnerData data) {
        IdentityHashMap map = new IdentityHashMap();
        Set<ImmutableValue<?>> newValues = data.getValues();
        for (ImmutableValue<?> value : newValues) {
            map.put(value.getKey(), value.get());
        }
        SpawnerUtils.applyData(logic, map);
    }
}

