/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.TupleIntJsonSerializable;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableAchievementData;
import org.spongepowered.api.data.manipulator.mutable.entity.AchievementData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.SetValue;
import org.spongepowered.api.statistic.achievement.Achievement;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeAchievementData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeSetValue;
import org.spongepowered.common.data.value.mutable.SpongeSetValue;
import org.spongepowered.common.interfaces.statistic.IMixinStatisticsManager;

public class AchievementDataProcessor
extends AbstractEntitySingleDataProcessor<EntityPlayerMP, Set<Achievement>, SetValue<Achievement>, AchievementData, ImmutableAchievementData> {
    public AchievementDataProcessor() {
        super(EntityPlayerMP.class, Keys.ACHIEVEMENTS);
    }

    @Override
    protected AchievementData createManipulator() {
        return new SpongeAchievementData();
    }

    @Override
    protected boolean set(EntityPlayerMP player, Set<Achievement> achievements) {
        Preconditions.checkNotNull((Object)player, (Object)"null player");
        Preconditions.checkNotNull(achievements, (Object)"null achievements");
        StatisticsManagerServer statFile = player.func_147099_x();
        for (net.minecraft.stats.Achievement achievement : AchievementList.field_187981_e) {
            if (achievements.contains(achievement)) {
                if (statFile.func_77443_a(achievement) || !statFile.func_77442_b(achievement)) continue;
                statFile.func_150873_a((EntityPlayer)player, (StatBase)achievement, 1);
                continue;
            }
            if (!statFile.func_77443_a(achievement)) continue;
            statFile.func_150871_b((EntityPlayer)player, (StatBase)achievement, -statFile.func_77444_a((StatBase)achievement));
        }
        return false;
    }

    @Override
    protected Optional<Set<Achievement>> getVal(EntityPlayerMP player) {
        Preconditions.checkNotNull((Object)player, (Object)"null player");
        StatisticsManagerServer statFile = player.func_147099_x();
        Map<StatBase, TupleIntJsonSerializable> statData = ((IMixinStatisticsManager)statFile).getStatsData();
        HashSet achievements = Sets.newHashSet();
        for (Map.Entry<StatBase, TupleIntJsonSerializable> entry : statData.entrySet()) {
            StatBase stat = entry.getKey();
            if (!stat.func_75967_d() || entry.getValue().func_151189_a() <= 0) continue;
            achievements.add((Achievement)stat);
        }
        return Optional.of(ImmutableSet.copyOf((Collection)achievements));
    }

    @Override
    protected ImmutableValue<Set<Achievement>> constructImmutableValue(Set<Achievement> value) {
        return new ImmutableSpongeSetValue<Achievement>(Keys.ACHIEVEMENTS, (Set)Preconditions.checkNotNull(value, (Object)"null value"));
    }

    @Override
    protected SetValue<Achievement> constructValue(Set<Achievement> actualValue) {
        return new SpongeSetValue<Achievement>(Keys.ACHIEVEMENTS, (Set)Preconditions.checkNotNull(actualValue, (Object)"null value"));
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

