/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableSkeletonData;
import org.spongepowered.api.data.manipulator.mutable.entity.SkeletonData;
import org.spongepowered.api.data.type.SkeletonType;
import org.spongepowered.api.data.type.SkeletonTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeSkeletonData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class SkeletonDataProcessor
extends AbstractEntitySingleDataProcessor<AbstractSkeleton, SkeletonType, Value<SkeletonType>, SkeletonData, ImmutableSkeletonData> {
    public SkeletonDataProcessor() {
        super(AbstractSkeleton.class, Keys.SKELETON_TYPE);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> entity) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected boolean set(AbstractSkeleton entity, SkeletonType value) {
        throw new UnsupportedOperationException("SkeletonData is deprecated - skeleton types are now separate entities!");
    }

    @Override
    protected Optional<SkeletonType> getVal(AbstractSkeleton entity) {
        if (entity instanceof EntitySkeleton) {
            return Optional.of(SkeletonTypes.NORMAL);
        }
        if (entity instanceof EntityStray) {
            return Optional.of(SkeletonTypes.STRAY);
        }
        if (entity instanceof EntityWitherSkeleton) {
            return Optional.of(SkeletonTypes.WITHER);
        }
        return Optional.empty();
    }

    @Override
    protected Value<SkeletonType> constructValue(SkeletonType actualValue) {
        return new SpongeValue<SkeletonType>(Keys.SKELETON_TYPE, DataConstants.Catalog.DEFAULT_SKELETON, actualValue);
    }

    @Override
    protected ImmutableValue<SkeletonType> constructImmutableValue(SkeletonType value) {
        return ImmutableSpongeValue.cachedOf(Keys.SKELETON_TYPE, DataConstants.Catalog.DEFAULT_SKELETON, value);
    }

    @Override
    protected SkeletonData createManipulator() {
        return new SpongeSkeletonData();
    }
}

