/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.TupleIntJsonSerializable;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableStatisticData;
import org.spongepowered.api.data.manipulator.mutable.entity.StatisticData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MapValue;
import org.spongepowered.api.statistic.Statistic;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeStatisticData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeMapValue;
import org.spongepowered.common.data.value.mutable.SpongeMapValue;
import org.spongepowered.common.interfaces.statistic.IMixinStatisticsManager;

public class StatisticDataProcessor
extends AbstractEntitySingleDataProcessor<EntityPlayerMP, Map<Statistic, Long>, MapValue<Statistic, Long>, StatisticData, ImmutableStatisticData> {
    public StatisticDataProcessor() {
        super(EntityPlayerMP.class, Keys.STATISTICS);
    }

    @Override
    protected StatisticData createManipulator() {
        return new SpongeStatisticData();
    }

    @Override
    protected boolean set(EntityPlayerMP player, Map<Statistic, Long> statMap) {
        Preconditions.checkNotNull((Object)player, (Object)"null player");
        Preconditions.checkNotNull(statMap, (Object)"null stat map");
        StatisticsManagerServer stats = player.func_147099_x();
        for (Map.Entry<Statistic, Long> statEntry : statMap.entrySet()) {
            Long value = statEntry.getValue();
            StatBase stat = (StatBase)statEntry.getKey();
            int currentValue = stats.func_77444_a(stat);
            if (value == null || stat.func_75967_d()) continue;
            stats.func_150871_b((EntityPlayer)player, (StatBase)statEntry.getKey(), (int)(value - (long)currentValue));
        }
        return true;
    }

    @Override
    protected Optional<Map<Statistic, Long>> getVal(EntityPlayerMP player) {
        Preconditions.checkNotNull((Object)player, (Object)"null player");
        StatisticsManagerServer stats = player.func_147099_x();
        Map<StatBase, TupleIntJsonSerializable> data = ((IMixinStatisticsManager)stats).getStatsData();
        HashMap statMap = Maps.newHashMap();
        for (Map.Entry<StatBase, TupleIntJsonSerializable> statEntry : data.entrySet()) {
            StatBase stat = statEntry.getKey();
            if (stat.func_75967_d()) continue;
            statMap.put((Statistic)statEntry.getKey(), Long.valueOf(statEntry.getValue().func_151189_a()));
        }
        return Optional.of(statMap);
    }

    @Override
    protected ImmutableValue<Map<Statistic, Long>> constructImmutableValue(Map<Statistic, Long> value) {
        return new ImmutableSpongeMapValue<Statistic, Long>(Keys.STATISTICS, (Map)Preconditions.checkNotNull(value, (Object)"null value"));
    }

    @Override
    protected MapValue<Statistic, Long> constructValue(Map<Statistic, Long> actualValue) {
        return new SpongeMapValue<Statistic, Long>(Keys.STATISTICS, (Map)Preconditions.checkNotNull(actualValue, (Object)"null value"));
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

