/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableInvisibilityData;
import org.spongepowered.api.data.manipulator.mutable.entity.InvisibilityData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeInvisibilityData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.interfaces.entity.IMixinEntity;

public class InvisibilityDataProcessor
extends AbstractEntityDataProcessor<Entity, InvisibilityData, ImmutableInvisibilityData> {
    public InvisibilityDataProcessor() {
        super(Entity.class);
    }

    @Override
    protected InvisibilityData createManipulator() {
        return new SpongeInvisibilityData();
    }

    @Override
    protected boolean doesDataExist(Entity dataHolder) {
        return true;
    }

    @Override
    protected boolean set(Entity dataHolder, Map<Key<?>, Object> keyValues) {
        if (!dataHolder.field_70170_p.field_72995_K) {
            boolean invis = (Boolean)keyValues.get(Keys.INVISIBLE);
            boolean collision = (Boolean)keyValues.get(Keys.VANISH_IGNORES_COLLISION);
            boolean untargetable = (Boolean)keyValues.get(Keys.VANISH_PREVENTS_TARGETING);
            boolean vanish = (Boolean)keyValues.get(Keys.VANISH);
            dataHolder.func_82142_c(invis);
            if (vanish) {
                IMixinEntity mixinEntity = EntityUtil.toMixin(dataHolder);
                mixinEntity.setVanished(true);
                mixinEntity.setIgnoresCollision(collision);
                mixinEntity.setUntargetable(untargetable);
            } else {
                EntityUtil.toMixin(dataHolder).setVanished(false);
            }
            return true;
        }
        return false;
    }

    @Override
    protected Map<Key<?>, ?> getValues(Entity dataHolder) {
        return ImmutableMap.of(Keys.INVISIBLE, (Object)dataHolder.func_82150_aj(), Keys.VANISH, (Object)((IMixinEntity)dataHolder).isVanished(), Keys.VANISH_IGNORES_COLLISION, (Object)((IMixinEntity)dataHolder).ignoresCollision(), Keys.VANISH_PREVENTS_TARGETING, (Object)((IMixinEntity)dataHolder).isUntargetable());
    }

    @Override
    public Optional<InvisibilityData> fill(DataContainer container, InvisibilityData invisibilityData) {
        boolean vanished = container.getBoolean(Keys.VANISH.getQuery()).orElse(false);
        boolean invisible = container.getBoolean(Keys.INVISIBLE.getQuery()).orElse(false);
        boolean collision = container.getBoolean(Keys.VANISH_IGNORES_COLLISION.getQuery()).orElse(false);
        boolean targeting = container.getBoolean(Keys.VANISH_PREVENTS_TARGETING.getQuery()).orElse(false);
        return Optional.of(((InvisibilityData)((InvisibilityData)((InvisibilityData)invisibilityData.set(Keys.VANISH, vanished)).set(Keys.INVISIBLE, invisible)).set(Keys.VANISH_IGNORES_COLLISION, collision)).set(Keys.VANISH_PREVENTS_TARGETING, targeting));
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

