/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableMinecartBlockData;
import org.spongepowered.api.data.manipulator.mutable.entity.MinecartBlockData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeMinecartBlockData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class MinecartBlockDataProcessor
extends AbstractEntityDataProcessor<EntityMinecart, MinecartBlockData, ImmutableMinecartBlockData> {
    public MinecartBlockDataProcessor() {
        super(EntityMinecart.class);
    }

    @Override
    protected boolean doesDataExist(EntityMinecart entity) {
        return entity.func_94100_s();
    }

    @Override
    protected boolean set(EntityMinecart entity, Map<Key<?>, Object> keyValues) {
        BlockState type = (BlockState)keyValues.get(Keys.REPRESENTED_BLOCK);
        int offset = (Integer)keyValues.get(Keys.OFFSET);
        entity.func_94086_l(offset);
        entity.func_174899_a((IBlockState)type);
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityMinecart entity) {
        BlockState state = (BlockState)entity.func_174897_t();
        int offset = entity.func_94099_q();
        return ImmutableMap.of(Keys.REPRESENTED_BLOCK, (Object)state, Keys.OFFSET, (Object)offset);
    }

    @Override
    protected MinecartBlockData createManipulator() {
        return new SpongeMinecartBlockData();
    }

    @Override
    public Optional<MinecartBlockData> fill(DataContainer container, MinecartBlockData data) {
        if (!container.contains(Keys.REPRESENTED_BLOCK.getQuery()) || !container.contains(Keys.OFFSET.getQuery())) {
            return Optional.empty();
        }
        BlockState block = container.getSerializable(Keys.REPRESENTED_BLOCK.getQuery(), BlockState.class).get();
        int offset = container.getInt(Keys.OFFSET.getQuery()).get();
        data.set(Keys.REPRESENTED_BLOCK, block);
        data.set(Keys.OFFSET, offset);
        return Optional.of(data);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        if (dataHolder instanceof EntityMinecart) {
            EntityMinecart cart = (EntityMinecart)dataHolder;
            DataTransactionResult.Builder builder = DataTransactionResult.builder().result(DataTransactionResult.Type.SUCCESS);
            if (cart.func_94100_s()) {
                ImmutableSpongeValue<BlockState> block = new ImmutableSpongeValue<BlockState>(Keys.REPRESENTED_BLOCK, (BlockState)cart.func_174897_t());
                ImmutableSpongeValue<Integer> offset = new ImmutableSpongeValue<Integer>(Keys.OFFSET, cart.func_94099_q());
                cart.func_94096_e(false);
                builder.replace(block).replace(offset);
            }
            return builder.build();
        }
        return DataTransactionResult.failNoData();
    }
}

