/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.item;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.BannerPattern;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.tileentity.ImmutableBannerData;
import org.spongepowered.api.data.manipulator.mutable.tileentity.BannerData;
import org.spongepowered.api.data.meta.PatternLayer;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.value.mutable.PatternListValue;
import org.spongepowered.common.data.manipulator.mutable.tileentity.SpongeBannerData;
import org.spongepowered.common.data.processor.common.AbstractItemDataProcessor;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public class ShieldBannerDataProcessor
extends AbstractItemDataProcessor<BannerData, ImmutableBannerData> {
    public ShieldBannerDataProcessor() {
        super((ItemStack input) -> input.func_77973_b() == Items.field_185159_cQ);
    }

    @Override
    public boolean doesDataExist(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean set(ItemStack itemStack, Map<Key<?>, Object> keyValues) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagCompound = ItemStackUtil.getTagCompound(itemStack);
        NBTTagCompound blockEntity = new NBTTagCompound();
        DyeColor baseColor = (DyeColor)keyValues.get(Keys.BANNER_BASE_COLOR);
        PatternListValue patternLayers = (PatternListValue)keyValues.get(Keys.BANNER_PATTERNS);
        if (!patternLayers.isEmpty()) {
            NBTTagList patterns = new NBTTagList();
            for (PatternLayer layer : patternLayers) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74778_a("Pattern", ((BannerPattern)layer.getShape()).func_190993_b());
                compound.func_74768_a("Color", ((EnumDyeColor)layer.getColor()).func_176767_b());
                patterns.func_74742_a((NBTBase)compound);
            }
            blockEntity.func_74782_a("Patterns", (NBTBase)patterns);
        }
        blockEntity.func_74768_a("Base", ((EnumDyeColor)baseColor).func_176767_b());
        tagCompound.func_74782_a("BlockEntityTag", (NBTBase)blockEntity);
        return true;
    }

    @Override
    public Map<Key<?>, ?> getValues(ItemStack itemStack) {
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("Unbreakable")) {
            return ImmutableMap.of(Keys.ITEM_DURABILITY, (Object)(itemStack.func_77958_k() - itemStack.func_77952_i()), Keys.UNBREAKABLE, (Object)itemStack.func_77978_p().func_74767_n("Unbreakable"));
        }
        return ImmutableMap.of(Keys.ITEM_DURABILITY, (Object)(itemStack.func_77958_k() - itemStack.func_77952_i()), Keys.UNBREAKABLE, (Object)false);
    }

    @Override
    public BannerData createManipulator() {
        return new SpongeBannerData();
    }

    @Override
    public Optional<BannerData> fill(DataContainer container, BannerData durabilityData) {
        Optional<Integer> durability = container.getInt(Keys.ITEM_DURABILITY.getQuery());
        Optional<Boolean> unbreakable = container.getBoolean(Keys.UNBREAKABLE.getQuery());
        if (durability.isPresent() && unbreakable.isPresent()) {
            durabilityData.set(Keys.ITEM_DURABILITY, durability.get());
            durabilityData.set(Keys.UNBREAKABLE, unbreakable.get());
            return Optional.of(durabilityData);
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

