/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.passive.EntityZombieHorse;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HorseVariant;
import org.spongepowered.api.data.type.HorseVariants;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class HorseVariantValueProcessor
extends AbstractSpongeValueProcessor<AbstractHorse, HorseVariant, Value<HorseVariant>> {
    public HorseVariantValueProcessor() {
        super(AbstractHorse.class, Keys.HORSE_VARIANT);
    }

    @Override
    protected Value<HorseVariant> constructValue(HorseVariant defaultValue) {
        return new SpongeValue<HorseVariant>(Keys.HORSE_VARIANT, defaultValue);
    }

    @Override
    protected boolean set(AbstractHorse container, HorseVariant value) {
        throw new UnsupportedOperationException("HorseData is deprecated - horse types are now separate entities!");
    }

    @Override
    protected Optional<HorseVariant> getVal(AbstractHorse container) {
        if (container instanceof EntityHorse) {
            return Optional.of(HorseVariants.HORSE);
        }
        if (container instanceof EntityDonkey) {
            return Optional.of(HorseVariants.DONKEY);
        }
        if (container instanceof EntityMule) {
            return Optional.of(HorseVariants.MULE);
        }
        if (container instanceof EntityZombieHorse) {
            return Optional.of(HorseVariants.UNDEAD_HORSE);
        }
        if (container instanceof EntitySkeletonHorse) {
            return Optional.of(HorseVariants.SKELETON_HORSE);
        }
        return Optional.empty();
    }

    @Override
    protected ImmutableValue<HorseVariant> constructImmutableValue(HorseVariant value) {
        return ImmutableSpongeValue.cachedOf(Keys.HORSE_VARIANT, HorseVariants.HORSE, value);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

