/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.tileentity;

import java.util.Optional;
import net.minecraft.tileentity.TileEntityFurnace;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class MaxBurnTimeValueProcessor
extends AbstractSpongeValueProcessor<TileEntityFurnace, Integer, MutableBoundedValue<Integer>> {
    private Cause cause;

    public MaxBurnTimeValueProcessor() {
        super(TileEntityFurnace.class, Keys.MAX_BURN_TIME);
    }

    @Override
    protected MutableBoundedValue<Integer> constructValue(Integer defaultValue) {
        return SpongeValueFactory.boundedBuilder(Keys.MAX_BURN_TIME).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(defaultValue).build();
    }

    @Override
    protected boolean set(TileEntityFurnace container, Integer value) {
        if (!container.func_145950_i() && value > 0 || container.func_145950_i() && value == 0) {
            if (this.cause == null) {
                this.cause = SpongeImpl.getImplementationCause();
            }
            World world = (World)container.func_145831_w();
            world.setBlockType(container.func_174877_v().func_177958_n(), container.func_174877_v().func_177956_o(), container.func_174877_v().func_177952_p(), value > 0 ? BlockTypes.LIT_FURNACE : BlockTypes.FURNACE, this.cause);
            container = (TileEntityFurnace)container.func_145831_w().func_175625_s(container.func_174877_v());
        }
        container.func_174885_b(1, value.intValue());
        return true;
    }

    @Override
    protected Optional<Integer> getVal(TileEntityFurnace container) {
        return Optional.of(container.func_174887_a_(1));
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return SpongeValueFactory.boundedBuilder(Keys.MAX_BURN_TIME).minimum(0).maximum(Integer.MAX_VALUE).defaultValue(1000).actualValue(value).build().asImmutable();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

