/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.property.store.block;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.spongepowered.api.data.property.block.FlammableProperty;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.Location;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.data.property.store.common.AbstractSpongePropertyStore;
import org.spongepowered.common.interfaces.world.IMixinLocation;

public class FlammablePropertyStore
extends AbstractSpongePropertyStore<FlammableProperty> {
    private static final FlammableProperty TRUE = new FlammableProperty(true);
    private static final FlammableProperty FALSE = new FlammableProperty(false);

    @Override
    public Optional<FlammableProperty> getFor(Location<org.spongepowered.api.world.World> location) {
        World world = (World)location.getExtent();
        BlockPos pos = ((IMixinLocation)((Object)location)).getBlockPos();
        Block block = world.func_180495_p(pos).func_177230_c();
        for (EnumFacing facing : EnumFacing.values()) {
            if (!SpongeImplHooks.isBlockFlammable(block, (IBlockAccess)world, pos, facing)) continue;
            return Optional.of(TRUE);
        }
        return Optional.of(FALSE);
    }

    @Override
    public Optional<FlammableProperty> getFor(Location<org.spongepowered.api.world.World> location, Direction direction) {
        World world = (World)location.getExtent();
        EnumFacing facing = FlammablePropertyStore.toEnumFacing(direction);
        BlockPos pos = ((IMixinLocation)((Object)location)).getBlockPos();
        boolean flammable = SpongeImplHooks.isBlockFlammable(world.func_180495_p(pos).func_177230_c(), (IBlockAccess)world, pos, facing);
        return Optional.of(flammable ? TRUE : FALSE);
    }
}

