/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import org.spongepowered.api.data.meta.ItemEnchantment;
import org.spongepowered.api.item.Enchantment;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Color;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.util.ColorUtil;

public final class NbtDataUtil {
    public static final String DATA_VERSION = "DataVersion";
    public static final String BANNER_PATTERN_ID = "Pattern";
    public static final String BANNER_PATTERN_COLOR = "Color";
    public static final String ENTITY_ROTATION = "Rotation";
    public static final String CUSTOM_DATA_CLASS = "DataClass";
    public static final String CUSTOM_DATA = "ManipulatorData";
    public static final String BANNER_BASE = "Base";
    public static final String BANNER_PATTERNS = "Patterns";
    public static final String FAILED_CUSTOM_DATA = "FailedData";
    public static final String BLOCK_ENTITY_TAG = "BlockEntityTag";
    public static final String BLOCK_ENTITY_ID = "id";
    public static final String SIGN = "Sign";
    public static final String TILE_ENTITY_POSITION_X = "x";
    public static final String TILE_ENTITY_POSITION_Y = "y";
    public static final String TILE_ENTITY_POSITION_Z = "z";
    public static final String ITEM_ENCHANTMENT_LIST = "ench";
    public static final String ITEM_STORED_ENCHANTMENTS_LIST = "StoredEnchantments";
    public static final String ITEM_ENCHANTMENT_ID = "id";
    public static final String ITEM_ENCHANTMENT_LEVEL = "lvl";
    public static final String ITEM_DISPLAY = "display";
    public static final String ITEM_DISPLAY_NAME = "Name";
    public static final String ITEM_LORE = "Lore";
    public static final String ITEM_COLOR = "color";
    public static final String ITEM_BOOK_PAGES = "pages";
    public static final String ITEM_BOOK_TITLE = "title";
    public static final String ITEM_BOOK_AUTHOR = "author";
    public static final String ITEM_BOOK_RESOLVED = "resolved";
    public static final String ITEM_BOOK_GENERATION = "generation";
    public static final String ITEM_BREAKABLE_BLOCKS = "CanDestroy";
    public static final String ITEM_PLACEABLE_BLOCKS = "CanPlaceOn";
    public static final String ITEM_SKULL_OWNER = "SkullOwner";
    public static final String ITEM_UNBREAKABLE = "Unbreakable";
    public static final String ITEM_HIDE_FLAGS = "HideFlags";
    public static final String CUSTOM_POTION_EFFECTS = "CustomPotionEffects";
    public static final String USER_SPAWN_X = "SpawnX";
    public static final String USER_SPAWN_Y = "SpawnY";
    public static final String USER_SPAWN_Z = "SpawnZ";
    public static final String USER_SPAWN_FORCED = "SpawnForced";
    public static final String USER_SPAWN_LIST = "Spawns";
    public static final String UUID = "UUID";
    public static final String CHUNK_DATA_LEVEL = "Level";
    public static final String CHUNK_DATA_SECTIONS = "Sections";
    public static final String SPAWNABLE_ENTITY_TAG = "EntityTag";
    public static final byte TAG_END = 0;
    public static final byte TAG_BYTE = 1;
    public static final byte TAG_SHORT = 2;
    public static final byte TAG_INT = 3;
    public static final byte TAG_LONG = 4;
    public static final byte TAG_FLOAT = 5;
    public static final byte TAG_DOUBLE = 6;
    public static final byte TAG_BYTE_ARRAY = 7;
    public static final byte TAG_STRING = 8;
    public static final byte TAG_LIST = 9;
    public static final byte TAG_COMPOUND = 10;
    public static final byte TAG_INT_ARRAY = 11;
    public static final byte TAG_ANY_NUMERIC = 99;
    public static final String SPONGE_DATA = "SpongeData";
    public static final String SPONGE_ENTITY_CREATOR = "Creator";
    public static final String SPONGE_ENTITY_NOTIFIER = "Notifier";
    public static final String SPONGE_BLOCK_POS_TABLE = "BlockPosTable";
    public static final String SPONGE_PLAYER_UUID_TABLE = "PlayerIdTable";
    public static final String CUSTOM_MANIPULATOR_TAG_LIST = "CustomManipulators";
    public static final String PROJECTILE_DAMAGE_AMOUNT = "damageAmount";
    public static final String BOAT_MAX_SPEED = "maxSpeed";
    public static final String BOAT_MOVE_ON_LAND = "moveOnLand";
    public static final String BOAT_OCCUPIED_DECELERATION_SPEED = "occupiedDecelerationSpeed";
    public static final String BOAT_UNOCCUPIED_DECELERATION_SPEED = "unoccupiedDecelerationSpeed";
    public static final String CAN_GRIEF = "CanGrief";
    public static final String GENERATE_BONUS_CHEST = "GenerateBonusChest";
    public static final String PORTAL_AGENT_TYPE = "portalAgentType";
    public static final String WORLD_SERIALIZATION_BEHAVIOR = "serializationBehavior";
    public static final String HEALTH_SCALE = "HealthScale";
    public static final String FORGE_DATA = "ForgeData";
    public static final String DIMENSION_TYPE = "dimensionType";
    public static final String DIMENSION_ID = "dimensionId";
    public static final String UUID_MOST = "UUIDMost";
    public static final String UUID_LEAST = "UUIDLeast";
    public static final String INVALID_TITLE = "invalid";
    public static final String IS_MOD = "isMod";
    public static final String FORGE_ENTITY_TYPE = "entity_name";
    public static final String BUKKIT = "bukkit";
    public static final String BUKKIT_FIRST_PLAYED = "firstPlayed";
    public static final String BUKKIT_LAST_PLAYED = "lastPlayed";
    public static final String ENTITY_TYPE_ID = "id";
    public static final String MINECART_TYPE = "Type";
    public static final String ENTITY_POSITION = "Pos";
    public static final String INFINITE_PICKUP_DELAY = "InfinitePickupDelay";
    public static final String INFINITE_DESPAWN_DELAY = "InfiniteDespawnDelay";
    public static final String PREVIOUS_PICKUP_DELAY = "PreviousPickupDelay";
    public static final String PREVIOUS_DESPAWN_DELAY = "PreviousDespawnDelay";

    private NbtDataUtil() {
    }

    public static Optional<NBTTagCompound> getItemCompound(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return Optional.of(itemStack.func_77978_p());
        }
        return Optional.empty();
    }

    public static NBTTagCompound getOrCreateCompound(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p();
    }

    public static NBTTagCompound getOrCreateSubCompound(NBTTagCompound mainCompound, String key) {
        if (!mainCompound.func_150297_b(key, 10)) {
            mainCompound.func_74782_a(key, (NBTBase)new NBTTagCompound());
        }
        return mainCompound.func_74775_l(key);
    }

    public static NBTTagCompound filterSpongeCustomData(NBTTagCompound rootCompound) {
        if (rootCompound.func_150297_b(FORGE_DATA, 10)) {
            NBTTagCompound forgeCompound = rootCompound.func_74775_l(FORGE_DATA);
            if (forgeCompound.func_150297_b(SPONGE_DATA, 10)) {
                NbtDataUtil.cleanseInnerCompound(forgeCompound, SPONGE_DATA);
            }
        } else if (rootCompound.func_150297_b(SPONGE_DATA, 10)) {
            NbtDataUtil.cleanseInnerCompound(rootCompound, SPONGE_DATA);
        }
        return rootCompound;
    }

    private static void cleanseInnerCompound(NBTTagCompound compound, String innerCompound) {
        NBTTagCompound inner = compound.func_74775_l(innerCompound);
        if (inner.func_82582_d()) {
            compound.func_82580_o(innerCompound);
        }
    }

    public static List<Text> getLoreFromNBT(NBTTagCompound subCompound) {
        NBTTagList list = subCompound.func_150295_c(ITEM_LORE, 8);
        return SpongeTexts.fromNbtLegacy(list);
    }

    public static void removeLoreFromNBT(ItemStack stack) {
        if (stack.func_179543_a(ITEM_DISPLAY) == null) {
            return;
        }
        stack.func_179543_a(ITEM_DISPLAY).func_82580_o(ITEM_LORE);
    }

    public static void setLoreToNBT(ItemStack stack, List<Text> lore) {
        NBTTagList list = SpongeTexts.asLegacy(lore);
        stack.func_190925_c(ITEM_DISPLAY).func_74782_a(ITEM_LORE, (NBTBase)list);
    }

    public static boolean hasColorFromNBT(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(ITEM_DISPLAY) && stack.func_77978_p().func_74775_l(ITEM_DISPLAY).func_74764_b(ITEM_COLOR);
    }

    public static Optional<Color> getColorFromNBT(NBTTagCompound subCompound) {
        if (!subCompound.func_74764_b(ITEM_COLOR)) {
            return Optional.empty();
        }
        return Optional.of(Color.ofRgb(subCompound.func_74762_e(ITEM_COLOR)));
    }

    public static void removeColorFromNBT(ItemStack stack) {
        if (stack.func_179543_a(ITEM_DISPLAY) == null) {
            return;
        }
        stack.func_179543_a(ITEM_DISPLAY).func_82580_o(ITEM_COLOR);
    }

    public static void setColorToNbt(ItemStack stack, Color color) {
        int mojangColor = ColorUtil.javaColorToMojangColor(color);
        stack.func_190925_c(ITEM_DISPLAY).func_74768_a(ITEM_COLOR, mojangColor);
    }

    public static List<Text> getPagesFromNBT(NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c(ITEM_BOOK_PAGES, 8);
        if (list.func_82582_d()) {
            return new ArrayList<Text>();
        }
        return SpongeTexts.fromNbtLegacy(list);
    }

    public static void removePagesFromNBT(ItemStack stack) {
        NBTTagList list = new NBTTagList();
        if (!stack.func_77942_o()) {
            return;
        }
        stack.func_77978_p().func_74782_a(ITEM_BOOK_PAGES, (NBTBase)list);
    }

    public static void setPagesToNBT(ItemStack stack, List<Text> pages) {
        NBTTagList list = SpongeTexts.asJsonNBT(pages);
        NBTTagCompound compound = NbtDataUtil.getOrCreateCompound(stack);
        compound.func_74782_a(ITEM_BOOK_PAGES, (NBTBase)list);
        if (!compound.func_74764_b(ITEM_BOOK_TITLE)) {
            compound.func_74778_a(ITEM_BOOK_TITLE, INVALID_TITLE);
        }
        if (!compound.func_74764_b(ITEM_BOOK_AUTHOR)) {
            compound.func_74778_a(ITEM_BOOK_AUTHOR, INVALID_TITLE);
        }
        compound.func_74757_a(ITEM_BOOK_RESOLVED, true);
    }

    public static List<ItemEnchantment> getItemEnchantments(ItemStack itemStack) {
        if (!itemStack.func_77948_v()) {
            return Collections.emptyList();
        }
        ArrayList enchantments = Lists.newArrayList();
        NBTTagList list = itemStack.func_77986_q();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            short enchantmentId = compound.func_74765_d("id");
            short level = compound.func_74765_d(ITEM_ENCHANTMENT_LEVEL);
            Enchantment enchantment = (Enchantment)net.minecraft.enchantment.Enchantment.func_185262_c((int)enchantmentId);
            if (enchantment == null) continue;
            enchantments.add(new ItemEnchantment(enchantment, level));
        }
        return enchantments;
    }

    public static void setItemEnchantments(ItemStack itemStack, List<ItemEnchantment> value) {
        NBTTagCompound compound;
        if (itemStack.func_77978_p() == null) {
            compound = new NBTTagCompound();
            itemStack.func_77982_d(compound);
        } else {
            compound = itemStack.func_77978_p();
        }
        if (value.isEmpty()) {
            compound.func_82580_o(ITEM_ENCHANTMENT_LIST);
            return;
        }
        LinkedHashMap valueMap = Maps.newLinkedHashMap();
        for (ItemEnchantment enchantment : value) {
            valueMap.put(enchantment.getEnchantment(), enchantment.getLevel());
        }
        NBTTagList newList = new NBTTagList();
        for (Map.Entry entry : valueMap.entrySet()) {
            NBTTagCompound enchantmentCompound = new NBTTagCompound();
            enchantmentCompound.func_74777_a("id", (short)net.minecraft.enchantment.Enchantment.func_185258_b((net.minecraft.enchantment.Enchantment)((net.minecraft.enchantment.Enchantment)entry.getKey())));
            enchantmentCompound.func_74777_a(ITEM_ENCHANTMENT_LEVEL, ((Integer)entry.getValue()).shortValue());
            newList.func_74742_a((NBTBase)enchantmentCompound);
        }
        compound.func_74782_a(ITEM_ENCHANTMENT_LIST, (NBTBase)newList);
    }

    public static NBTTagList newDoubleNBTList(double ... numbers) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] adouble = numbers;
        int i = numbers.length;
        for (int j = 0; j < i; ++j) {
            double d1 = adouble[j];
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(d1));
        }
        return nbttaglist;
    }

    public static final class Deprecated {
        private Deprecated() {
        }

        public static final class World {
            public static final String WORLD_UUID_LEAST_1_8 = "uuid_least";
            public static final String WORLD_UUID_MOST_1_8 = "uuid_most";

            private World() {
            }
        }

        public static final class Entity {
            public static final String UUID_LEAST_1_8 = "uuid_least";
            public static final String UUID_MOST_1_8 = "uuid_most";

            private Entity() {
            }
        }
    }

    public static final class Minecraft {
        public static final String PASSENGERS = "Passengers";
        public static final String IS_FLYING = "flying";
    }
}

