/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity;

import com.google.common.base.Objects;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.SpongeCatalogType;
import org.spongepowered.common.text.translation.SpongeTranslation;

public class SpongeEntityType
extends SpongeCatalogType.Translatable
implements EntityType {
    public static final EntityType UNKNOWN = new EntityType(){
        private final Translation translation = new SpongeTranslation("entity.generic.name");

        @Override
        public Translation getTranslation() {
            return this.translation;
        }

        @Override
        public String getName() {
            return "Unknown";
        }

        @Override
        public String getId() {
            return "unknown:unknown";
        }

        @Override
        public Class<? extends org.spongepowered.api.entity.Entity> getEntityClass() {
            throw new UnsupportedOperationException("Unknown entity type has no entity class");
        }
    };
    public final int entityTypeId;
    public final String entityName;
    public final String modId;
    public final Class<? extends Entity> entityClass;
    private EnumCreatureType creatureType;
    private final Translation translation;
    private boolean activationRangeInitialized = false;
    public int trackingRange;
    public int updateFrequency;
    public boolean sendsVelocityUpdates;

    public SpongeEntityType(int id, String name, Class<? extends Entity> clazz, Translation translation) {
        this(id, name.toLowerCase(Locale.ENGLISH), "minecraft", clazz, translation);
    }

    public SpongeEntityType(int id, String name, String modId, Class<? extends Entity> clazz, Translation translation) {
        super(modId.toLowerCase(Locale.ENGLISH) + ":" + name.toLowerCase(Locale.ENGLISH), SpongeEntityType.check(translation));
        this.entityTypeId = id;
        this.entityName = name.toLowerCase(Locale.ENGLISH);
        this.entityClass = clazz;
        this.modId = modId.toLowerCase(Locale.ENGLISH);
        ResourceLocation loc = EntityList.func_191306_a(clazz);
        String translationName = loc == null ? "generic" : loc.func_110623_a();
        this.translation = new SpongeTranslation("entity." + translationName + ".name");
    }

    private static Translation check(@Nullable Translation translation) {
        if (translation == null) {
            return UNKNOWN.getTranslation();
        }
        return translation;
    }

    @Override
    public String getName() {
        return this.entityName;
    }

    public String getModId() {
        return this.modId;
    }

    public EnumCreatureType getEnumCreatureType() {
        return this.creatureType;
    }

    public void setEnumCreatureType(EnumCreatureType type) {
        this.creatureType = type;
    }

    public boolean isActivationRangeInitialized() {
        return this.activationRangeInitialized;
    }

    public void setActivationRangeInitialized(boolean flag) {
        this.activationRangeInitialized = flag;
    }

    @Override
    public Class<? extends org.spongepowered.api.entity.Entity> getEntityClass() {
        return this.entityClass;
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("modid", (Object)this.modId).add("class", (Object)this.entityClass.getName());
    }
}

