/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player.tab;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketPlayerListHeaderFooter;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.entity.living.player.tab.TabListEntry;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.entity.player.tab.SpongeTabListEntry;
import org.spongepowered.common.interfaces.network.play.server.IMixinSPacketPlayerListItem;
import org.spongepowered.common.text.SpongeTexts;

public final class SpongeTabList
implements TabList {
    private static final ITextComponent EMPTY_COMPONENT = new TextComponentString("");
    private final EntityPlayerMP player;
    @Nullable
    private Text header;
    @Nullable
    private Text footer;
    private final Map<UUID, TabListEntry> entries = Maps.newHashMap();

    public SpongeTabList(EntityPlayerMP player) {
        this.player = player;
    }

    @Override
    public Player getPlayer() {
        return (Player)this.player;
    }

    @Override
    public Optional<Text> getHeader() {
        return Optional.ofNullable(this.header);
    }

    @Override
    public TabList setHeader(@Nullable Text header) {
        this.header = header;
        this.refreshClientHeaderFooter();
        return this;
    }

    @Override
    public Optional<Text> getFooter() {
        return Optional.ofNullable(this.footer);
    }

    @Override
    public TabList setFooter(@Nullable Text footer) {
        this.footer = footer;
        this.refreshClientHeaderFooter();
        return this;
    }

    @Override
    public TabList setHeaderAndFooter(@Nullable Text header, @Nullable Text footer) {
        this.header = header;
        this.footer = footer;
        this.refreshClientHeaderFooter();
        return this;
    }

    private void refreshClientHeaderFooter() {
        SPacketPlayerListHeaderFooter packet = new SPacketPlayerListHeaderFooter();
        packet.field_179703_a = this.header == null ? EMPTY_COMPONENT : SpongeTexts.toComponent(this.header);
        packet.field_179702_b = this.footer == null ? EMPTY_COMPONENT : SpongeTexts.toComponent(this.footer);
        this.player.field_71135_a.func_147359_a((Packet)packet);
    }

    @Override
    public Collection<TabListEntry> getEntries() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    @Override
    public Optional<TabListEntry> getEntry(UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId, (Object)"unique id");
        return Optional.ofNullable(this.entries.get(uniqueId));
    }

    @Override
    public TabList addEntry(TabListEntry entry) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)entry, (Object)"builder");
        Preconditions.checkState((boolean)entry.getList().equals(this), (Object)"the provided tab list entry was not created for this tab list");
        this.addEntry(entry, true);
        return this;
    }

    private void addEntry(SPacketPlayerListItem.AddPlayerData entry) {
        if (!this.entries.containsKey(entry.func_179962_a().getId())) {
            this.addEntry(new SpongeTabListEntry(this, (GameProfile)entry.func_179962_a(), entry.func_179961_d() == null ? null : SpongeTexts.toText(entry.func_179961_d()), entry.func_179963_b(), (GameMode)entry.func_179960_c()), false);
        }
    }

    private void addEntry(TabListEntry entry, boolean exceptionOnDuplicate) {
        UUID uniqueId = entry.getProfile().getUniqueId();
        if (exceptionOnDuplicate) {
            Preconditions.checkArgument((!this.entries.containsKey(uniqueId) ? 1 : 0) != 0, (Object)"cannot add duplicate entry");
        }
        if (!this.entries.containsKey(uniqueId)) {
            this.entries.put(uniqueId, entry);
            this.sendUpdate(entry, SPacketPlayerListItem.Action.ADD_PLAYER);
            entry.getDisplayName().ifPresent(text -> this.sendUpdate(entry, SPacketPlayerListItem.Action.UPDATE_DISPLAY_NAME));
            this.sendUpdate(entry, SPacketPlayerListItem.Action.UPDATE_LATENCY);
            this.sendUpdate(entry, SPacketPlayerListItem.Action.UPDATE_GAME_MODE);
        }
    }

    @Override
    public Optional<TabListEntry> removeEntry(UUID uniqueId) {
        Preconditions.checkNotNull((Object)uniqueId, (Object)"unique id");
        if (this.entries.containsKey(uniqueId)) {
            TabListEntry entry = this.entries.remove(uniqueId);
            this.sendUpdate(entry, SPacketPlayerListItem.Action.REMOVE_PLAYER);
            return Optional.of(entry);
        }
        return Optional.empty();
    }

    protected void sendUpdate(TabListEntry entry, SPacketPlayerListItem.Action action) {
        SPacketPlayerListItem packet = new SPacketPlayerListItem();
        packet.field_179770_a = action;
        ((IMixinSPacketPlayerListItem)packet).addEntry(entry);
        this.player.field_71135_a.func_147359_a((Packet)packet);
    }

    public void updateEntriesOnSend(SPacketPlayerListItem packet) {
        for (SPacketPlayerListItem.AddPlayerData data : packet.field_179769_b) {
            if (packet.field_179770_a == SPacketPlayerListItem.Action.ADD_PLAYER) {
                this.addEntry(data);
                continue;
            }
            if (packet.field_179770_a == SPacketPlayerListItem.Action.REMOVE_PLAYER) {
                this.removeEntry(data.func_179962_a().getId());
                continue;
            }
            this.getEntry(data.func_179962_a().getId()).ifPresent(entry -> {
                if (packet.field_179770_a == SPacketPlayerListItem.Action.UPDATE_DISPLAY_NAME) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setDisplayName(data.func_179961_d() == null ? null : SpongeTexts.toText(data.func_179961_d()));
                } else if (packet.field_179770_a == SPacketPlayerListItem.Action.UPDATE_LATENCY) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setLatency(data.func_179963_b());
                } else if (packet.field_179770_a == SPacketPlayerListItem.Action.UPDATE_GAME_MODE) {
                    ((SpongeTabListEntry)entry).updateWithoutSend();
                    entry.setGameMode((GameMode)data.func_179960_c());
                } else {
                    throw new IllegalArgumentException("unknown packet action: " + packet.field_179770_a);
                }
            });
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("player", (Object)this.player).add("header", (Object)this.header).add("footer", (Object)this.footer).add("entries", this.entries).toString();
    }
}

