/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.projectile;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityDragonFireball;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityLargeFireball;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.spongepowered.api.block.tileentity.carrier.Dispenser;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.projectile.Egg;
import org.spongepowered.api.entity.projectile.EnderPearl;
import org.spongepowered.api.entity.projectile.EyeOfEnder;
import org.spongepowered.api.entity.projectile.Firework;
import org.spongepowered.api.entity.projectile.FishHook;
import org.spongepowered.api.entity.projectile.LlamaSpit;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.entity.projectile.Snowball;
import org.spongepowered.api.entity.projectile.ThrownExpBottle;
import org.spongepowered.api.entity.projectile.ThrownPotion;
import org.spongepowered.api.entity.projectile.arrow.TippedArrow;
import org.spongepowered.api.entity.projectile.explosive.DragonFireball;
import org.spongepowered.api.entity.projectile.explosive.WitherSkull;
import org.spongepowered.api.entity.projectile.explosive.fireball.LargeFireball;
import org.spongepowered.api.entity.projectile.explosive.fireball.SmallFireball;
import org.spongepowered.api.entity.projectile.source.ProjectileSource;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.entity.spawn.SpawnCause;
import org.spongepowered.api.event.entity.projectile.LaunchProjectileEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.projectile.DispenserSourceLogic;
import org.spongepowered.common.entity.projectile.ProjectileLogic;
import org.spongepowered.common.entity.projectile.ProjectileSourceLogic;
import org.spongepowered.common.entity.projectile.SimpleDispenserLaunchLogic;
import org.spongepowered.common.entity.projectile.SimpleEntityLaunchLogic;
import org.spongepowered.common.entity.projectile.SimpleItemLaunchLogic;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.registry.type.entity.EntityTypeRegistryModule;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

public class ProjectileLauncher {
    private static final Map<Class<? extends Projectile>, ProjectileLogic<?>> projectileLogic = Maps.newHashMap();
    private static final Map<Class<? extends ProjectileSource>, ProjectileSourceLogic<?>> projectileSourceLogic = Maps.newHashMap();

    public static <T extends Projectile> Optional<T> launch(Class<T> projectileClass, ProjectileSource source, Vector3d vel) {
        ProjectileLogic<T> logic = ProjectileLauncher.getLogic(projectileClass);
        if (logic == null) {
            return Optional.empty();
        }
        Optional<Projectile> projectile = logic.launch(source);
        projectile.ifPresent(t -> {
            if (vel != null) {
                t.offer(Keys.VELOCITY, vel);
            }
            t.setShooter(source);
        });
        if (projectile.isPresent()) {
            if (vel != null) {
                ((Projectile)projectile.get()).offer(Keys.VELOCITY, vel);
            }
            ((Projectile)projectile.get()).setShooter(source);
        }
        return projectile;
    }

    private static void configureThrowable(EntityThrowable entity) {
        entity.field_70165_t -= (double)(MathHelper.func_76134_b((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        entity.field_70163_u -= 0.1;
        entity.field_70161_v -= (double)(MathHelper.func_76126_a((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        entity.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        float f = 0.4f;
        entity.field_70159_w = -MathHelper.func_76126_a((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI)) * f;
        entity.field_70179_y = MathHelper.func_76134_b((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI)) * f;
        entity.field_70181_x = -MathHelper.func_76126_a((float)(entity.field_70125_A / 180.0f * (float)Math.PI)) * f;
    }

    public static <T extends Projectile> void registerProjectileLogic(Class<T> projectileClass, ProjectileLogic<T> logic) {
        projectileLogic.put(projectileClass, logic);
    }

    public static <T extends ProjectileSource> void registerProjectileSourceLogic(Class<T> projectileSourceClass, ProjectileSourceLogic<T> logic) {
        projectileSourceLogic.put(projectileSourceClass, logic);
    }

    static <T extends ProjectileSource> ProjectileSourceLogic<T> getSourceLogic(Class<T> sourceClass) {
        return projectileSourceLogic.get(sourceClass);
    }

    private static <T extends Projectile> ProjectileLogic<T> getLogic(Class<T> sourceClass) {
        if (!sourceClass.isInterface() && net.minecraft.entity.Entity.class.isAssignableFrom(sourceClass)) {
            for (Class<?> iface : sourceClass.getInterfaces()) {
                if (!Projectile.class.isAssignableFrom(iface)) continue;
                sourceClass = iface;
                break;
            }
        }
        return projectileLogic.get(sourceClass);
    }

    static <P extends Projectile> Optional<P> defaultLaunch(ProjectileSource source, Class<P> projectileClass, Location<?> loc) {
        Optional<EntityType> opType = EntityTypeRegistryModule.getInstance().getEntity(projectileClass);
        if (!opType.isPresent()) {
            return Optional.empty();
        }
        Entity projectile = loc.getExtent().createEntity(opType.get(), loc.getPosition());
        if (projectile instanceof EntityThrowable) {
            ProjectileLauncher.configureThrowable((EntityThrowable)projectile);
        }
        return ProjectileLauncher.doLaunch(loc.getExtent(), (Projectile)projectile, ProjectileLauncher.createCause(source));
    }

    private static Cause createCause(Object source) {
        return Cause.source(((SpawnCause.Builder)SpawnCause.builder().type(InternalSpawnTypes.PROJECTILE)).build()).named("ProjectileSource", source).build();
    }

    private static <P extends Projectile> Optional<P> doLaunch(Extent extent, P projectile, Cause cause) {
        SpongeCommonEventFactory.checkSpawnEvent(projectile, cause);
        LaunchProjectileEvent event = SpongeEventFactory.createLaunchProjectileEvent(cause, projectile);
        SpongeImpl.getGame().getEventManager().post(event);
        if (!event.isCancelled() && extent.spawnEntity(projectile, cause)) {
            return Optional.of(projectile);
        }
        return Optional.empty();
    }

    static {
        ProjectileLauncher.registerProjectileSourceLogic(Dispenser.class, new DispenserSourceLogic());
        ProjectileLauncher.registerProjectileLogic(TippedArrow.class, new SimpleItemLaunchLogic<TippedArrow>(TippedArrow.class, Items.field_151032_g){

            @Override
            protected Optional<TippedArrow> createProjectile(EntityLivingBase source, Location<?> loc) {
                TippedArrow arrow = (TippedArrow)new EntityTippedArrow(source.field_70170_p, source);
                ((EntityTippedArrow)arrow).func_184547_a((net.minecraft.entity.Entity)source, source.field_70125_A, source.field_70177_z, 0.0f, 3.0f, 0.0f);
                return ProjectileLauncher.doLaunch(loc.getExtent(), arrow, ProjectileLauncher.createCause(source));
            }
        });
        ProjectileLauncher.registerProjectileLogic(Egg.class, new SimpleItemLaunchLogic<Egg>(Egg.class, Items.field_151110_aK){

            @Override
            protected Optional<Egg> createProjectile(EntityLivingBase source, Location<?> loc) {
                Egg egg = (Egg)new EntityEgg(source.field_70170_p, source);
                ((EntityThrowable)egg).func_184538_a((net.minecraft.entity.Entity)source, source.field_70125_A, source.field_70177_z, 0.0f, 1.5f, 0.0f);
                return ProjectileLauncher.doLaunch(loc.getExtent(), egg, ProjectileLauncher.createCause(source));
            }
        });
        ProjectileLauncher.registerProjectileLogic(SmallFireball.class, new SimpleItemLaunchLogic<SmallFireball>(SmallFireball.class, Items.field_151059_bz){

            @Override
            protected Optional<SmallFireball> createProjectile(EntityLivingBase source, Location<?> loc) {
                Vec3d lookVec = source.func_70676_i(1.0f);
                SmallFireball fireball = (SmallFireball)new EntitySmallFireball(source.field_70170_p, source, lookVec.field_72450_a * 4.0, lookVec.field_72448_b * 4.0, lookVec.field_72449_c * 4.0);
                ((EntitySmallFireball)fireball).field_70163_u += (double)source.func_70047_e();
                return ProjectileLauncher.doLaunch(loc.getExtent(), fireball, ProjectileLauncher.createCause(source));
            }
        });
        ProjectileLauncher.registerProjectileLogic(Firework.class, new SimpleItemLaunchLogic<Firework>(Firework.class, Items.field_151152_bP){

            @Override
            protected Optional<Firework> createProjectile(EntityLivingBase source, Location<?> loc) {
                Firework firework = (Firework)new EntityFireworkRocket(source.field_70170_p, loc.getX(), loc.getY(), loc.getZ(), ItemStack.field_190927_a);
                return ProjectileLauncher.doLaunch(loc.getExtent(), firework, ProjectileLauncher.createCause(source));
            }
        });
        ProjectileLauncher.registerProjectileLogic(Snowball.class, new SimpleItemLaunchLogic<Snowball>(Snowball.class, Items.field_151126_ay){

            @Override
            protected Optional<Snowball> createProjectile(EntityLivingBase source, Location<?> loc) {
                Snowball snowball = (Snowball)new EntitySnowball(source.field_70170_p, source);
                ((EntityThrowable)snowball).func_184538_a((net.minecraft.entity.Entity)source, source.field_70125_A, source.field_70177_z, 0.0f, 1.5f, 0.0f);
                return ProjectileLauncher.doLaunch(loc.getExtent(), snowball, ProjectileLauncher.createCause(source));
            }
        });
        ProjectileLauncher.registerProjectileLogic(ThrownExpBottle.class, new SimpleItemLaunchLogic<ThrownExpBottle>(ThrownExpBottle.class, Items.field_151062_by){

            @Override
            protected Optional<ThrownExpBottle> createProjectile(EntityLivingBase source, Location<?> loc) {
                ThrownExpBottle expBottle = (ThrownExpBottle)new EntityExpBottle(source.field_70170_p, source);
                ((EntityThrowable)expBottle).func_184538_a((net.minecraft.entity.Entity)source, source.field_70125_A, source.field_70177_z, -20.0f, 0.7f, 0.0f);
                return ProjectileLauncher.doLaunch(loc.getExtent(), expBottle, ProjectileLauncher.createCause(source));
            }
        });
        ProjectileLauncher.registerProjectileLogic(EnderPearl.class, new SimpleDispenserLaunchLogic<EnderPearl>(EnderPearl.class){

            @Override
            protected Optional<EnderPearl> createProjectile(EntityLivingBase source, Location<?> loc) {
                EnderPearl pearl = (EnderPearl)new EntityEnderPearl(source.field_70170_p, source);
                ((EntityThrowable)pearl).func_184538_a((net.minecraft.entity.Entity)source, source.field_70125_A, source.field_70177_z, 0.0f, 1.5f, 0.0f);
                return ProjectileLauncher.doLaunch(loc.getExtent(), pearl, ProjectileLauncher.createCause(source));
            }
        });
        ProjectileLauncher.registerProjectileLogic(LargeFireball.class, new SimpleDispenserLaunchLogic<LargeFireball>(LargeFireball.class){

            @Override
            protected Optional<LargeFireball> createProjectile(EntityLivingBase source, Location<?> loc) {
                Vec3d lookVec = source.func_70676_i(1.0f);
                LargeFireball fireball = (LargeFireball)new EntityLargeFireball(source.field_70170_p, source, lookVec.field_72450_a * 4.0, lookVec.field_72448_b * 4.0, lookVec.field_72449_c * 4.0);
                ((EntityLargeFireball)fireball).field_70163_u += (double)source.func_70047_e();
                return ProjectileLauncher.doLaunch(loc.getExtent(), fireball, ProjectileLauncher.createCause(source));
            }

            @Override
            public Optional<LargeFireball> createProjectile(ProjectileSource source, Class<LargeFireball> projectileClass, Location<?> loc) {
                if (!(source instanceof TileEntityDispenser)) {
                    return super.createProjectile(source, projectileClass, loc);
                }
                TileEntityDispenser dispenser = (TileEntityDispenser)source;
                EnumFacing enumfacing = DispenserSourceLogic.getFacing(dispenser);
                Random random = dispenser.func_145831_w().field_73012_v;
                double d3 = random.nextGaussian() * 0.05 + (double)enumfacing.func_82601_c();
                double d4 = random.nextGaussian() * 0.05 + (double)enumfacing.func_96559_d();
                double d5 = random.nextGaussian() * 0.05 + (double)enumfacing.func_82599_e();
                EntityArmorStand thrower = new EntityArmorStand(dispenser.func_145831_w(), loc.getX() + (double)enumfacing.func_82601_c(), loc.getY() + (double)enumfacing.func_96559_d(), loc.getZ() + (double)enumfacing.func_82599_e());
                LargeFireball fireball = (LargeFireball)new EntityLargeFireball(dispenser.func_145831_w(), (EntityLivingBase)thrower, d3, d4, d5);
                return ProjectileLauncher.doLaunch(loc.getExtent(), fireball, ProjectileLauncher.createCause(source));
            }
        });
        ProjectileLauncher.registerProjectileLogic(WitherSkull.class, new SimpleDispenserLaunchLogic<WitherSkull>(WitherSkull.class){

            @Override
            protected Optional<WitherSkull> createProjectile(EntityLivingBase source, Location<?> loc) {
                Vec3d lookVec = source.func_70676_i(1.0f);
                WitherSkull skull = (WitherSkull)new EntityWitherSkull(source.field_70170_p, source, lookVec.field_72450_a * 4.0, lookVec.field_72448_b * 4.0, lookVec.field_72449_c * 4.0);
                ((EntityWitherSkull)skull).field_70163_u += (double)source.func_70047_e();
                return ProjectileLauncher.doLaunch(loc.getExtent(), skull, ProjectileLauncher.createCause(source));
            }
        });
        ProjectileLauncher.registerProjectileLogic(EyeOfEnder.class, new SimpleDispenserLaunchLogic<EyeOfEnder>(EyeOfEnder.class));
        ProjectileLauncher.registerProjectileLogic(FishHook.class, new SimpleDispenserLaunchLogic<FishHook>(FishHook.class){

            @Override
            protected Optional<FishHook> createProjectile(EntityLivingBase source, Location<?> loc) {
                if (source instanceof EntityPlayer) {
                    FishHook hook = (FishHook)new EntityFishHook(source.field_70170_p, (EntityPlayer)source);
                    return ProjectileLauncher.doLaunch(loc.getExtent(), hook, ProjectileLauncher.createCause(source));
                }
                return super.createProjectile(source, loc);
            }
        });
        ProjectileLauncher.registerProjectileLogic(ThrownPotion.class, new SimpleDispenserLaunchLogic<ThrownPotion>(ThrownPotion.class){

            @Override
            protected Optional<ThrownPotion> createProjectile(EntityLivingBase source, Location<?> loc) {
                ThrownPotion potion = (ThrownPotion)new EntityPotion(source.field_70170_p, source, new ItemStack((Item)Items.field_185155_bH, 1));
                ((EntityThrowable)potion).func_184538_a((net.minecraft.entity.Entity)source, source.field_70125_A, source.field_70177_z, -20.0f, 0.5f, 0.0f);
                return ProjectileLauncher.doLaunch(loc.getExtent(), potion, ProjectileLauncher.createCause(source));
            }
        });
        ProjectileLauncher.registerProjectileLogic(LlamaSpit.class, new SimpleEntityLaunchLogic<LlamaSpit>(LlamaSpit.class){

            @Override
            public Optional<LlamaSpit> launch(ProjectileSource source) {
                if (!(source instanceof EntityLlama)) {
                    return Optional.empty();
                }
                return super.launch(source);
            }

            @Override
            public Optional<LlamaSpit> createProjectile(ProjectileSource source, Class<LlamaSpit> projectileClass, Location<?> loc) {
                EntityLlama llama = (EntityLlama)source;
                LlamaSpit llamaSpit = (LlamaSpit)new EntityLlamaSpit(llama.field_70170_p, (EntityLlama)source);
                Vec3d lookVec = llama.func_70676_i(1.0f);
                ((EntityLlamaSpit)llamaSpit).func_70186_c(lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c, 1.5f, 0.0f);
                return ProjectileLauncher.doLaunch(loc.getExtent(), llamaSpit, ProjectileLauncher.createCause(source));
            }
        });
        ProjectileLauncher.registerProjectileLogic(DragonFireball.class, new SimpleDispenserLaunchLogic<DragonFireball>(DragonFireball.class){

            @Override
            protected Optional<DragonFireball> createProjectile(EntityLivingBase source, Location<?> loc) {
                Vec3d lookVec = source.func_70676_i(1.0f);
                DragonFireball fireball = (DragonFireball)new EntityDragonFireball(source.field_70170_p, source, lookVec.field_72450_a * 4.0, lookVec.field_72448_b * 4.0, lookVec.field_72449_c * 4.0);
                ((EntityDragonFireball)fireball).field_70163_u += (double)source.func_70047_e();
                return ProjectileLauncher.doLaunch(loc.getExtent(), fireball, ProjectileLauncher.createCause(source));
            }
        });
    }
}

