/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockPistonStructureHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import net.minecraft.network.play.server.SPacketOpenWindow;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.projectile.source.ProjectileSource;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.CollideBlockEvent;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.block.NotifyNeighborBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.spawn.SpawnCause;
import org.spongepowered.api.event.entity.CollideEntityEvent;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.event.item.inventory.InteractItemEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.BlockUtil;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayerMP;
import org.spongepowered.common.interfaces.entity.player.IMixinInventoryPlayer;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.SpongeItemStackSnapshot;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.custom.CustomInventory;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.registry.provider.DirectionFacingProvider;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.util.VecHelper;

public class SpongeCommonEventFactory {
    public static boolean convertingMapFormat = false;
    public static boolean playerInteractItemChanged = false;
    public static boolean interactBlockEventCancelled = false;
    public static ChangeBlockEvent.Pre DUMMY_BLOCK_PRE_EVENT = null;
    public static int lastAnimationPacketTick = 0;
    public static int lastSecondaryPacketTick = 0;
    public static int lastPrimaryPacketTick = 0;
    public static WeakReference<EntityPlayerMP> lastAnimationPlayer;

    public static boolean callPlayerChangeInventoryPickupEvent(EntityPlayer player, EntityItem itemToPickup, int pickupDelay, UUID creator) {
        ItemStack itemStack = itemToPickup.func_92059_d();
        int slotId = ((IMixinInventoryPlayer)player.field_71071_by).getFirstAvailableSlot(itemStack);
        Slot slot = null;
        if (slotId != -1) {
            slot = slotId < InventoryPlayer.func_70451_h() ? player.field_71069_bz.func_75139_a(slotId + player.field_71071_by.field_70462_a.size()) : player.field_71069_bz.func_75139_a(slotId);
        }
        if (pickupDelay <= 0 && slot != null) {
            ItemStackSnapshot sourceSnapshot = slot.func_75211_c().func_190926_b() ? ItemStackSnapshot.NONE : ((org.spongepowered.api.item.inventory.ItemStack)slot.func_75211_c()).createSnapshot();
            ItemStackSnapshot targetSnapshot = sourceSnapshot != ItemStackSnapshot.NONE ? org.spongepowered.api.item.inventory.ItemStack.builder().from((org.spongepowered.api.item.inventory.ItemStack)itemStack).quantity(itemStack.func_190916_E() + slot.func_75211_c().func_190916_E()).build().createSnapshot() : ((org.spongepowered.api.item.inventory.ItemStack)itemStack).createSnapshot();
            ((SpongeItemStackSnapshot)targetSnapshot).setCreator(creator);
            SlotTransaction slotTransaction = new SlotTransaction(new SlotAdapter(slot), sourceSnapshot, targetSnapshot);
            ImmutableList transactions = new ImmutableList.Builder().add((Object)slotTransaction).build();
            ChangeInventoryEvent.Pickup event = SpongeEventFactory.createChangeInventoryEventPickup(Cause.of(NamedCause.source(player)), (Item)itemToPickup, (Inventory)player.field_71069_bz, (List)transactions);
            if (SpongeImpl.postEvent(event)) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static CollideEntityEvent callCollideEntityEvent(net.minecraft.world.World world, @Nullable net.minecraft.entity.Entity sourceEntity, List<net.minecraft.entity.Entity> entities) {
        CauseTracker causeTracker = CauseTracker.getInstance();
        Cause.Builder builder = null;
        if (sourceEntity != null) {
            builder = Cause.source(sourceEntity);
        } else {
            PhaseContext context = causeTracker.getCurrentContext();
            Optional<LocatableBlock> currentTickingBlock = context.getSource(LocatableBlock.class);
            Optional<TileEntity> currentTickingTileEntity = context.getSource(TileEntity.class);
            Optional<Entity> currentTickingEntity = context.getSource(Entity.class);
            if (currentTickingBlock.isPresent()) {
                builder = Cause.source(currentTickingBlock.get());
            } else if (currentTickingTileEntity.isPresent()) {
                builder = Cause.source(currentTickingTileEntity.get());
            } else if (currentTickingEntity.isPresent()) {
                builder = Cause.source(currentTickingEntity.get());
            }
            if (builder == null) {
                return null;
            }
        }
        Optional<User> owner = causeTracker.getCurrentPhaseData().context.firstNamed("Owner", User.class);
        if (owner.isPresent()) {
            builder.named("Owner", owner.get());
        }
        List<net.minecraft.entity.Entity> spEntities = entities;
        CollideEntityEvent event = SpongeEventFactory.createCollideEntityEvent(builder.build(), spEntities);
        SpongeImpl.postEvent(event);
        return event;
    }

    public static ChangeBlockEvent.Pre callChangeBlockEventPre(IMixinWorldServer worldIn, BlockPos pos, NamedCause namedWorldCause) {
        return SpongeCommonEventFactory.callChangeBlockEventPre(worldIn, (ImmutableList<Location<World>>)ImmutableList.of(new Location<World>((World)((Object)worldIn), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())), namedWorldCause, null);
    }

    public static ChangeBlockEvent.Pre callChangeBlockEventPre(IMixinWorldServer worldIn, BlockPos pos, NamedCause namedWorldCause, Object source) {
        return SpongeCommonEventFactory.callChangeBlockEventPre(worldIn, (ImmutableList<Location<World>>)ImmutableList.of(new Location<World>((World)((Object)worldIn), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())), namedWorldCause, source);
    }

    public static ChangeBlockEvent.Pre callChangeBlockEventPre(IMixinWorldServer worldIn, ImmutableList<Location<World>> locations, NamedCause namedWorldCause, Object source) {
        CauseTracker causeTracker = CauseTracker.getInstance();
        PhaseData data = causeTracker.getCurrentPhaseData();
        IPhaseState phaseState = data.state;
        if (source == null && (source = data.context.getSource(LocatableBlock.class).orElse(null)) == null) {
            if (DUMMY_BLOCK_PRE_EVENT == null) {
                DUMMY_BLOCK_PRE_EVENT = SpongeEventFactory.createChangeBlockEventPre(Cause.source(worldIn).build(), (List)ImmutableList.of());
            }
            return DUMMY_BLOCK_PRE_EVENT;
        }
        EntityPlayer player = null;
        Cause.Builder builder = null;
        User owner = data.context.getOwner().orElse(null);
        User notifier = data.context.getNotifier().orElse(null);
        if (source instanceof EntityPlayer && SpongeImplHooks.isFakePlayer((net.minecraft.entity.Entity)(player = (EntityPlayer)source))) {
            if (owner != null) {
                builder = Cause.source(owner);
                builder.named("FakePlayer", player);
            } else if (notifier != null) {
                builder = Cause.source(notifier);
                builder.named("FakePlayer", player);
            } else {
                builder = Cause.builder().named("FakePlayer", player);
            }
        }
        if (builder == null) {
            builder = Cause.source(source);
        }
        if (owner != null) {
            builder.owner(owner);
        }
        if (notifier != null && !phaseState.getPhase().appendPreBlockProtectedCheck(builder, phaseState, data.context, causeTracker)) {
            builder.notifier(notifier);
        }
        builder.named(namedWorldCause);
        ChangeBlockEvent.Pre event = SpongeEventFactory.createChangeBlockEventPre(builder.build(), locations);
        SpongeImpl.postEvent(event);
        return event;
    }

    public static ChangeBlockEvent.Modify callChangeBlockEventModifyLiquidMix(net.minecraft.world.World worldIn, BlockPos pos, IBlockState state, @Nullable Object source) {
        CauseTracker causeTracker = CauseTracker.getInstance();
        PhaseData data = causeTracker.getCurrentPhaseData();
        BlockState fromState = BlockUtil.fromNative(worldIn.func_180495_p(pos));
        BlockState toState = BlockUtil.fromNative(state);
        User owner = data.context.getOwner().orElse(null);
        User notifier = data.context.getNotifier().orElse(null);
        if (source == null) {
            source = LocatableBlock.builder().state(fromState).world((World)worldIn).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).build();
        }
        Cause.Builder builder = Cause.source(source);
        builder.named(NamedCause.of("LiquidMix", worldIn));
        if (owner != null) {
            builder.owner(owner);
        }
        if (notifier != null) {
            builder.notifier(notifier);
        }
        WorldProperties world = ((World)worldIn).getProperties();
        Vector3i position = new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        Transaction transaction = new Transaction(BlockSnapshot.builder().blockState(fromState).world(world).position(position).build(), BlockSnapshot.builder().blockState(toState).world(world).position(position).build());
        ChangeBlockEvent.Modify event = SpongeEventFactory.createChangeBlockEventModify(builder.build(), Collections.singletonList(transaction));
        SpongeImpl.postEvent(event);
        return event;
    }

    public static ChangeBlockEvent.Break callChangeBlockEventModifyLiquidBreak(net.minecraft.world.World worldIn, BlockPos pos, IBlockState state, int flags) {
        CauseTracker causeTracker = CauseTracker.getInstance();
        PhaseData data = causeTracker.getCurrentPhaseData();
        BlockState fromState = BlockUtil.fromNative(worldIn.func_180495_p(pos));
        BlockState toState = BlockUtil.fromNative(state);
        User owner = data.context.getOwner().orElse(null);
        User notifier = data.context.getNotifier().orElse(null);
        net.minecraft.world.World source = data.context.getSource(LocatableBlock.class).orElse(null);
        if (source == null) {
            source = worldIn;
        }
        Cause.Builder builder = Cause.source(source);
        builder.named(NamedCause.of("LiquidFlow", worldIn));
        if (owner != null) {
            builder.owner(owner);
        }
        if (notifier != null) {
            builder.notifier(notifier);
        }
        WorldProperties world = ((World)worldIn).getProperties();
        Vector3i position = new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        Transaction transaction = new Transaction(BlockSnapshot.builder().blockState(fromState).world(world).position(position).build(), BlockSnapshot.builder().blockState(toState).world(world).position(position).build());
        ChangeBlockEvent.Break event = SpongeEventFactory.createChangeBlockEventBreak(builder.build(), Collections.singletonList(transaction));
        SpongeImpl.postEvent(event);
        return event;
    }

    public static boolean handlePistonEvent(IMixinWorldServer world, WorldServer.ServerBlockEventList list, Object obj, BlockPos pos, Block blockIn, int eventId, int eventParam) {
        boolean extending = eventId == 0;
        IBlockState blockstate = ((net.minecraft.world.World)world).func_180495_p(pos);
        EnumFacing direction = (EnumFacing)blockstate.func_177229_b((IProperty)BlockDirectional.field_176387_N);
        LocatableBlock locatable = LocatableBlock.builder().location(new Location<World>((World)((Object)world), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).state((BlockState)blockstate).build();
        HashSet<Location<World>> locations = new HashSet<Location<World>>();
        locations.add(new Location<World>((World)((Object)world), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        BlockPistonStructureHelper movedBlocks = new BlockPistonStructureHelper((net.minecraft.world.World)((WorldServer)world), pos, direction, extending);
        movedBlocks.func_177253_a();
        Stream.concat(movedBlocks.func_177254_c().stream(), movedBlocks.func_177252_d().stream()).map(block -> new Location<World>((World)((Object)world), block.func_177958_n(), block.func_177956_o(), block.func_177952_p())).collect(Collectors.toCollection(() -> locations));
        if (extending && movedBlocks.func_177252_d().isEmpty()) {
            List movedPositions = movedBlocks.func_177254_c();
            BlockPos offsetPos = movedPositions.isEmpty() ? pos.func_177972_a(direction) : ((BlockPos)movedPositions.get(movedPositions.size() - 1)).func_177972_a(direction);
            locations.add(new Location<World>((World)((Object)world), offsetPos.func_177958_n(), offsetPos.func_177956_o(), offsetPos.func_177952_p()));
        }
        String namedCause = extending ? "PistonExtend" : "PistonRetract";
        return SpongeCommonEventFactory.callChangeBlockEventPre(world, (ImmutableList<Location<World>>)ImmutableList.copyOf(locations), NamedCause.of(namedCause, world), (Object)locatable).isCancelled();
    }

    public static NotifyNeighborBlockEvent callNotifyNeighborEvent(World world, BlockPos sourcePos, EnumSet notifiedSides) {
        CauseTracker causeTracker = CauseTracker.getInstance();
        PhaseData peek = causeTracker.getCurrentPhaseData();
        PhaseContext context = peek.context;
        if (peek.state.getPhase().isWorldGeneration(peek.state) || peek.state == BlockPhase.State.RESTORING_BLOCKS) {
            return null;
        }
        User user = context.first(User.class).orElse(null);
        Object rootCause = context.first(Object.class).orElse(null);
        if (rootCause instanceof PhaseContext) {
            PhaseContext phaseContext = rootCause;
            rootCause = phaseContext.first(Object.class).orElse(null);
        }
        BlockState blockstate = (BlockState)((net.minecraft.world.World)world).func_180495_p(sourcePos);
        LocatableBlock locatable = LocatableBlock.builder().location(new Location<World>(world, sourcePos.func_177958_n(), sourcePos.func_177956_o(), sourcePos.func_177952_p())).state(blockstate).build();
        Cause.Builder builder = Cause.source(locatable);
        if (rootCause instanceof User) {
            builder.named(NamedCause.notifier(rootCause));
        } else if (user != null) {
            builder.named(NamedCause.notifier(user));
        } else {
            IMixinChunk mixinChunk = (IMixinChunk)((WorldServer)world).func_175726_f(sourcePos);
            peek.state.getPhase().populateCauseForNotifyNeighborEvent(peek.state, context, builder, causeTracker, mixinChunk, sourcePos);
        }
        HashMap<Direction, BlockState> neighbors = new HashMap<Direction, BlockState>();
        for (Object obj : notifiedSides) {
            EnumFacing notifiedSide = (EnumFacing)obj;
            BlockPos offset = sourcePos.func_177972_a(notifiedSide);
            Direction direction = DirectionFacingProvider.getInstance().getKey(notifiedSide).get();
            Location<World> location = new Location<World>(world, VecHelper.toVector3i(offset));
            if (location.getBlockY() < 0 || location.getBlockY() > 255) continue;
            neighbors.put(direction, location.getBlock());
        }
        NotifyNeighborBlockEvent event = SpongeEventFactory.createNotifyNeighborBlockEvent(builder.build(), neighbors, neighbors);
        SpongeImpl.postEvent(event);
        return event;
    }

    public static InteractEntityEvent.Primary callInteractEntityEventPrimary(EntityPlayerMP player, net.minecraft.entity.Entity entity, EnumHand hand, Vec3d hitVec) {
        Optional hitVector = hitVec == null ? Optional.empty() : Optional.of(VecHelper.toVector3d(hitVec));
        InteractEntityEvent.Primary event = hand == EnumHand.MAIN_HAND ? SpongeEventFactory.createInteractEntityEventPrimaryMainHand(Cause.of(NamedCause.source(player)), HandTypes.MAIN_HAND, hitVector, EntityUtil.fromNative(entity)) : SpongeEventFactory.createInteractEntityEventPrimaryOffHand(Cause.of(NamedCause.source(player)), HandTypes.OFF_HAND, hitVector, EntityUtil.fromNative(entity));
        SpongeImpl.postEvent(event);
        return event;
    }

    public static InteractEntityEvent.Secondary callInteractEntityEventSecondary(EntityPlayerMP player, net.minecraft.entity.Entity entity, EnumHand hand, Optional<Vector3d> interactionPoint) {
        InteractEntityEvent.Secondary event = hand == EnumHand.MAIN_HAND ? SpongeEventFactory.createInteractEntityEventSecondaryMainHand(Cause.of(NamedCause.source(player)), HandTypes.MAIN_HAND, interactionPoint, EntityUtil.fromNative(entity)) : SpongeEventFactory.createInteractEntityEventSecondaryOffHand(Cause.of(NamedCause.source(player)), HandTypes.OFF_HAND, interactionPoint, EntityUtil.fromNative(entity));
        SpongeImpl.postEvent(event);
        return event;
    }

    public static InteractItemEvent callInteractItemEventPrimary(EntityPlayer player, ItemStack stack, EnumHand hand, Optional<Vector3d> interactionPoint, Object hitTarget) {
        InteractItemEvent.Primary event = hand == EnumHand.MAIN_HAND ? SpongeEventFactory.createInteractItemEventPrimaryMainHand(Cause.of(NamedCause.source(player), NamedCause.hitTarget(hitTarget)), HandTypes.MAIN_HAND, interactionPoint, ItemStackUtil.snapshotOf(stack)) : SpongeEventFactory.createInteractItemEventPrimaryOffHand(Cause.of(NamedCause.source(player), NamedCause.hitTarget(hitTarget)), HandTypes.OFF_HAND, interactionPoint, ItemStackUtil.snapshotOf(stack));
        SpongeImpl.postEvent(event);
        return event;
    }

    public static InteractItemEvent callInteractItemEventSecondary(EntityPlayer player, ItemStack stack, EnumHand hand, Optional<Vector3d> interactionPoint, Object hitTarget) {
        InteractItemEvent.Secondary event = hand == EnumHand.MAIN_HAND ? SpongeEventFactory.createInteractItemEventSecondaryMainHand(Cause.of(NamedCause.source(player), NamedCause.hitTarget(hitTarget)), HandTypes.MAIN_HAND, interactionPoint, ItemStackUtil.snapshotOf(stack)) : SpongeEventFactory.createInteractItemEventSecondaryOffHand(Cause.of(NamedCause.source(player), NamedCause.hitTarget(hitTarget)), HandTypes.OFF_HAND, interactionPoint, ItemStackUtil.snapshotOf(stack));
        SpongeImpl.postEvent(event);
        return event;
    }

    public static InteractBlockEvent.Primary callInteractBlockEventPrimary(EntityPlayer player, EnumHand hand) {
        InteractBlockEvent.Primary event = hand == EnumHand.MAIN_HAND ? SpongeEventFactory.createInteractBlockEventPrimaryMainHand(Cause.of(NamedCause.source(player)), HandTypes.MAIN_HAND, Optional.empty(), BlockSnapshot.NONE, Direction.NONE) : SpongeEventFactory.createInteractBlockEventPrimaryOffHand(Cause.of(NamedCause.source(player)), HandTypes.OFF_HAND, Optional.empty(), BlockSnapshot.NONE, Direction.NONE);
        SpongeImpl.postEvent(event);
        return event;
    }

    public static InteractBlockEvent.Primary callInteractBlockEventPrimary(EntityPlayer player, BlockSnapshot blockSnapshot, EnumHand hand, EnumFacing side) {
        Direction direction = DirectionFacingProvider.getInstance().getKey(side).get();
        InteractBlockEvent.Primary event = hand == EnumHand.MAIN_HAND ? SpongeEventFactory.createInteractBlockEventPrimaryMainHand(Cause.of(NamedCause.source(player)), HandTypes.MAIN_HAND, Optional.empty(), blockSnapshot, direction) : SpongeEventFactory.createInteractBlockEventPrimaryOffHand(Cause.of(NamedCause.source(player)), HandTypes.OFF_HAND, Optional.empty(), blockSnapshot, direction);
        SpongeImpl.postEvent(event);
        return event;
    }

    public static InteractBlockEvent.Secondary callInteractBlockEventSecondary(Cause cause, Optional<Vector3d> interactionPoint, BlockSnapshot targetBlock, Direction targetSide, EnumHand hand) {
        return SpongeCommonEventFactory.callInteractBlockEventSecondary(cause, Tristate.UNDEFINED, Tristate.UNDEFINED, Tristate.UNDEFINED, Tristate.UNDEFINED, interactionPoint, targetBlock, targetSide, hand);
    }

    public static InteractBlockEvent.Secondary callInteractBlockEventSecondary(Cause cause, Tristate originalUseBlockResult, Tristate useBlockResult, Tristate originalUseItemResult, Tristate useItemResult, Optional<Vector3d> interactionPoint, BlockSnapshot targetBlock, Direction targetSide, EnumHand hand) {
        InteractBlockEvent.Secondary event = hand == EnumHand.MAIN_HAND ? SpongeEventFactory.createInteractBlockEventSecondaryMainHand(cause, originalUseBlockResult, useBlockResult, originalUseItemResult, useItemResult, HandTypes.MAIN_HAND, interactionPoint, targetBlock, targetSide) : SpongeEventFactory.createInteractBlockEventSecondaryOffHand(cause, originalUseBlockResult, useBlockResult, originalUseItemResult, useItemResult, HandTypes.OFF_HAND, interactionPoint, targetBlock, targetSide);
        SpongeImpl.postEvent(event);
        return event;
    }

    public static boolean callDestructEntityEventDeath(EntityLivingBase entity, DamageSource source) {
        EntityDamageSource damageSource;
        IMixinEntity spongeEntity;
        MessageChannel originalChannel;
        MessageChannel channel;
        MessageEvent.MessageFormatter formatter = new MessageEvent.MessageFormatter();
        Optional<Object> sourceCreator = Optional.empty();
        boolean messageCancelled = false;
        if (entity instanceof EntityPlayerMP) {
            originalChannel = channel = ((IMixinEntityPlayerMP)entity).getDeathMessageChannel();
        } else {
            originalChannel = MessageChannel.TO_NONE;
            channel = MessageChannel.TO_NONE;
        }
        if (source instanceof EntityDamageSource && (spongeEntity = (IMixinEntity)(damageSource = (EntityDamageSource)source).func_76364_f()) != null) {
            sourceCreator = spongeEntity.getCreatorUser();
        }
        Text originalMessage = SpongeTexts.toText(entity.func_110142_aN().func_151521_b());
        formatter.getBody().add(new MessageEvent.DefaultBodyApplier(originalMessage));
        ArrayList<NamedCause> causes = new ArrayList<NamedCause>();
        causes.add(NamedCause.of("Attacker", source));
        if (sourceCreator.isPresent()) {
            causes.add(NamedCause.owner(sourceCreator.get()));
        }
        Cause cause = Cause.of(causes);
        DestructEntityEvent.Death event = SpongeEventFactory.createDestructEntityEventDeath(cause, originalChannel, Optional.of(channel), formatter, (Living)entity, messageCancelled);
        SpongeImpl.postEvent(event);
        Text message = event.getMessage();
        if (!event.isMessageCancelled() && !message.isEmpty()) {
            event.getChannel().ifPresent(eventChannel -> eventChannel.send(entity, event.getMessage()));
        }
        return true;
    }

    public static boolean handleCollideBlockEvent(Block block, net.minecraft.world.World world, BlockPos pos, IBlockState state, net.minecraft.entity.Entity entity, Direction direction) {
        IMixinEntity spongeEntity;
        CollideBlockEvent event;
        boolean cancelled;
        IMixinEntity spongeEntity2;
        Optional<User> user;
        if (pos.func_177956_o() <= 0) {
            return false;
        }
        CauseTracker causeTracker = CauseTracker.getInstance();
        Cause.Builder builder = Cause.source(entity);
        builder.named(NamedCause.of("Physical", entity));
        if (!(entity instanceof EntityPlayer) && (user = (spongeEntity2 = (IMixinEntity)entity).getCreatorUser()).isPresent()) {
            builder.named(NamedCause.owner(user.get()));
        }
        if (!(cancelled = SpongeImpl.postEvent(event = SpongeEventFactory.createCollideBlockEvent(builder.build(), (BlockState)state, new Location<World>((World)world, VecHelper.toVector3d(pos)), direction))) && !pos.equals((Object)(spongeEntity = (IMixinEntity)entity).getLastCollidedBlockPos())) {
            PhaseData peek = causeTracker.getCurrentPhaseData();
            Optional<User> notifier = peek.context.firstNamed("Notifier", User.class);
            if (notifier.isPresent()) {
                IMixinChunk spongeChunk = (IMixinChunk)world.func_175726_f(pos);
                spongeChunk.addTrackedBlockPosition(block, pos, notifier.get(), PlayerTracker.Type.NOTIFIER);
            }
        }
        return cancelled;
    }

    public static boolean handleCollideImpactEvent(net.minecraft.entity.Entity projectile, @Nullable ProjectileSource projectileSource, RayTraceResult movingObjectPosition) {
        CauseTracker causeTracker = CauseTracker.getInstance();
        RayTraceResult.Type movingObjectType = movingObjectPosition.field_72313_a;
        Cause.Builder builder = Cause.source(projectile).named("ProjectileSource", projectileSource == null ? ProjectileSource.UNKNOWN : projectileSource);
        Optional<User> owner = causeTracker.getCurrentPhaseData().context.firstNamed("Owner", User.class);
        owner.ifPresent(user -> builder.named("Owner", user));
        Location<World> impactPoint = new Location<World>((World)projectile.field_70170_p, VecHelper.toVector3d(movingObjectPosition.field_72307_f));
        boolean cancelled = false;
        if (movingObjectType == RayTraceResult.Type.BLOCK) {
            CollideBlockEvent.Impact event;
            BlockPos blockPos = movingObjectPosition.func_178782_a();
            if (blockPos.func_177956_o() <= 0) {
                return false;
            }
            BlockSnapshot targetBlock = ((World)projectile.field_70170_p).createSnapshot(VecHelper.toVector3i(movingObjectPosition.func_178782_a()));
            Direction side = Direction.NONE;
            if (movingObjectPosition.field_178784_b != null) {
                side = DirectionFacingProvider.getInstance().getKey(movingObjectPosition.field_178784_b).get();
            }
            if (!(cancelled = SpongeImpl.postEvent(event = SpongeEventFactory.createCollideBlockEventImpact(builder.build(), impactPoint, targetBlock.getState(), targetBlock.getLocation().get(), side))) && owner.isPresent()) {
                BlockPos targetPos = VecHelper.toBlockPos(impactPoint.getBlockPosition());
                IMixinChunk spongeChunk = (IMixinChunk)projectile.field_70170_p.func_175726_f(targetPos);
                spongeChunk.addTrackedBlockPosition((Block)targetBlock.getState().getType(), targetPos, owner.get(), PlayerTracker.Type.NOTIFIER);
            }
        } else if (movingObjectPosition.field_72308_g != null) {
            ArrayList<Entity> entityList = new ArrayList<Entity>();
            entityList.add((Entity)movingObjectPosition.field_72308_g);
            CollideEntityEvent.Impact event = SpongeEventFactory.createCollideEntityEventImpact(builder.build(), entityList, impactPoint);
            cancelled = SpongeImpl.postEvent(event);
        }
        if (cancelled) {
            projectile.func_70106_y();
        }
        return cancelled;
    }

    public static void checkSpawnEvent(Entity entity, Cause cause) {
        Preconditions.checkArgument((boolean)(cause.root() instanceof SpawnCause), (String)"The cause does not have a SpawnCause! It has instead: {}", (Object[])new Object[]{cause.root().toString()});
        Preconditions.checkArgument((boolean)cause.containsNamed("Source"), (Object)"The cause does not have a \"Source\" named object!");
        Preconditions.checkArgument((boolean)cause.get("Source", SpawnCause.class).isPresent(), (Object)"The SpawnCause is not the \"Source\" of the cause!");
    }

    public static ClickInventoryEvent.Creative callCreativeClickInventoryEvent(EntityPlayerMP player, CPacketCreativeInventoryAction packetIn) {
        Slot slot;
        Cause cause = Cause.of(NamedCause.owner(player));
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.NONE, ItemStackSnapshot.NONE);
        if (((IMixinContainer)player.field_71070_bA).getCapturedTransactions().size() == 0 && packetIn.func_149627_c() >= 0 && packetIn.func_149627_c() < player.field_71070_bA.field_75151_b.size() && (slot = player.field_71070_bA.func_75139_a(packetIn.func_149627_c())) != null) {
            ItemStackSnapshot clickedItem = slot.func_75211_c() == null ? ItemStackSnapshot.NONE : ((org.spongepowered.api.item.inventory.ItemStack)slot.func_75211_c()).createSnapshot();
            SlotTransaction slotTransaction = new SlotTransaction(new SlotAdapter(slot), clickedItem, ItemStackSnapshot.NONE);
            ((IMixinContainer)player.field_71070_bA).getCapturedTransactions().add(slotTransaction);
        }
        ClickInventoryEvent.Creative event = SpongeEventFactory.createClickInventoryEventCreative(cause, cursorTransaction, (Container)player.field_71070_bA, ((IMixinContainer)player.field_71070_bA).getCapturedTransactions());
        SpongeImpl.postEvent(event);
        return event;
    }

    public static boolean callInteractInventoryOpenEvent(Cause cause, EntityPlayerMP player) {
        ItemStackSnapshot newCursor = player.field_71071_by.func_70445_o().func_190926_b() ? ItemStackSnapshot.NONE : ((org.spongepowered.api.item.inventory.ItemStack)player.field_71071_by.func_70445_o()).createSnapshot();
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(ItemStackSnapshot.NONE, newCursor);
        InteractInventoryEvent.Open event = SpongeEventFactory.createInteractInventoryEventOpen(cause, cursorTransaction, (Container)player.field_71070_bA);
        SpongeImpl.postEvent(event);
        if (event.isCancelled()) {
            player.func_71053_j();
            return false;
        }
        if (!event.getCursorTransaction().isValid()) {
            PacketPhaseUtil.handleCustomCursor(player, event.getCursorTransaction().getOriginal());
        } else if (event.getCursorTransaction().getCustom().isPresent()) {
            PacketPhaseUtil.handleCustomCursor(player, event.getCursorTransaction().getFinal());
        }
        return true;
    }

    public static InteractInventoryEvent.Close callInteractInventoryCloseEvent(Cause cause, net.minecraft.inventory.Container container, EntityPlayerMP player, ItemStackSnapshot lastCursor, ItemStackSnapshot newCursor, boolean clientSource) {
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(lastCursor, newCursor);
        InteractInventoryEvent.Close event = SpongeEventFactory.createInteractInventoryEventClose(cause, cursorTransaction, ContainerUtil.fromNative(container));
        SpongeImpl.postEvent(event);
        if (event.isCancelled()) {
            if (clientSource && container.func_75139_a(0) != null && !(container instanceof ContainerPlayer)) {
                player.field_71070_bA = container;
                Slot slot = container.func_75139_a(0);
                IInventory slotInventory = slot.field_75224_c;
                String guiId = slotInventory instanceof IInteractionObject ? ((IInteractionObject)slotInventory).func_174875_k() : "minecraft:container";
                slotInventory.func_174889_b((EntityPlayer)player);
                player.field_71135_a.func_147359_a((Packet)new SPacketOpenWindow(container.field_75152_c, guiId, slotInventory.func_145748_c_(), slotInventory.func_70302_i_()));
                player.func_71120_a(container);
            }
            if (!event.getCursorTransaction().isValid()) {
                PacketPhaseUtil.handleCustomCursor(player, event.getCursorTransaction().getOriginal());
            }
        } else {
            IMixinContainer mixinContainer = (IMixinContainer)player.field_71070_bA;
            mixinContainer.getCapturedTransactions().clear();
            mixinContainer.setCaptureInventory(false);
            if (!event.getCursorTransaction().isValid()) {
                PacketPhaseUtil.handleCustomCursor(player, event.getCursorTransaction().getOriginal());
            } else if (event.getCursorTransaction().getCustom().isPresent()) {
                PacketPhaseUtil.handleCustomCursor(player, event.getCursorTransaction().getFinal());
            }
            if (!clientSource) {
                player.func_71053_j();
            }
        }
        return event;
    }

    @Nullable
    public static net.minecraft.inventory.Container displayContainer(Cause cause, EntityPlayerMP player, Inventory inventory) {
        net.minecraft.inventory.Container container;
        net.minecraft.inventory.Container previousContainer;
        block20: {
            block19: {
                String guiId;
                previousContainer = player.field_71070_bA;
                container = null;
                if (inventory instanceof CustomInventory && !SpongeCommonEventFactory.checkValidVanillaCustomInventory((CustomInventory)((Object)inventory))) {
                    return null;
                }
                if (!(inventory instanceof IInteractionObject)) break block19;
                switch (guiId = ((IInteractionObject)inventory).func_174875_k()) {
                    case "EntityHorse": {
                        if (inventory instanceof CarriedInventory && ((CarriedInventory)inventory).getCarrier().isPresent() && ((CarriedInventory)inventory).getCarrier().get() instanceof EntityHorse) {
                            player.func_184826_a((AbstractHorse)((EntityHorse)((CarriedInventory)inventory).getCarrier().get()), (IInventory)inventory);
                            container = player.field_71070_bA;
                            break;
                        }
                        break block20;
                    }
                    case "minecraft:chest": {
                        player.func_71007_a((IInventory)inventory);
                        container = player.field_71070_bA;
                        break;
                    }
                    case "minecraft:crafting_table": 
                    case "minecraft:anvil": 
                    case "minecraft:enchanting_table": {
                        player.func_180468_a((IInteractionObject)inventory);
                        container = player.field_71070_bA;
                        break;
                    }
                    default: {
                        player.func_71007_a((IInventory)inventory);
                        container = player.field_71070_bA;
                        break;
                    }
                }
                break block20;
            }
            if (inventory instanceof IInventory) {
                player.func_71007_a((IInventory)inventory);
                container = player.field_71070_bA;
            } else {
                return null;
            }
        }
        if (previousContainer == container) {
            return null;
        }
        if (!SpongeCommonEventFactory.callInteractInventoryOpenEvent(cause, player)) {
            return null;
        }
        if (container instanceof IMixinContainer) {
            ((IMixinContainer)container).setCanInteractWith(p -> !p.field_70128_L);
        }
        return container;
    }

    private static boolean checkValidVanillaCustomInventory(CustomInventory inventory) {
        InventoryArchetype archetype = inventory.getArchetype();
        if (InventoryArchetypes.CHEST.equals(archetype) || InventoryArchetypes.DOUBLE_CHEST.equals(archetype)) {
            int size = inventory.func_70302_i_();
            return size % 9 == 0 && size / 9 <= 6 && size != 0;
        }
        if (InventoryArchetypes.HOPPER.equals(archetype)) {
            return inventory.func_70302_i_() == 5;
        }
        if (InventoryArchetypes.DISPENSER.equals(archetype)) {
            return inventory.func_70302_i_() == 9;
        }
        if (InventoryArchetypes.WORKBENCH.equals(archetype)) {
            return inventory.func_70302_i_() == 10;
        }
        if (InventoryArchetypes.FURNACE.equals(archetype)) {
            return inventory.func_70302_i_() == 3;
        }
        if (InventoryArchetypes.ENCHANTING_TABLE.equals(archetype)) {
            return inventory.func_70302_i_() == 2;
        }
        if (InventoryArchetypes.ANVIL.equals(archetype)) {
            return inventory.func_70302_i_() == 3;
        }
        if (InventoryArchetypes.BREWING_STAND.equals(archetype)) {
            return inventory.func_70302_i_() == 5;
        }
        if (InventoryArchetypes.BEACON.equals(archetype)) {
            return inventory.func_70302_i_() == 1;
        }
        if (InventoryArchetypes.HORSE.equals(archetype)) {
            return inventory.func_70302_i_() == 2;
        }
        if (InventoryArchetypes.HORSE_WITH_CHEST.equals(archetype)) {
            return inventory.func_70302_i_() == 17;
        }
        if (InventoryArchetypes.VILLAGER.equals(archetype)) {
            return inventory.func_70302_i_() == 3;
        }
        return true;
    }
}

