/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.impl.AbstractEvent;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.common.event.AnnotatedEventListener;
import org.spongepowered.common.event.ClassEventListenerFactory;
import org.spongepowered.common.event.ListenerChecker;
import org.spongepowered.common.event.RegisteredListener;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.filter.FilterFactory;
import org.spongepowered.common.event.gen.DefineableClassLoader;
import org.spongepowered.common.event.tracking.CauseTracker;

@Singleton
public class SpongeEventManager
implements EventManager {
    private final Object lock = new Object();
    protected final Logger logger;
    private final PluginManager pluginManager;
    private final DefineableClassLoader classLoader = new DefineableClassLoader(this.getClass().getClassLoader());
    private final AnnotatedEventListener.Factory handlerFactory = new ClassEventListenerFactory("org.spongepowered.common.event.listener", new FilterFactory("org.spongepowered.common.event.filters", this.classLoader), this.classLoader);
    private final Multimap<Class<?>, RegisteredListener<?>> handlersByEvent = HashMultimap.create();
    private final Set<Object> registeredListeners = Sets.newHashSet();
    public final ListenerChecker checker = new ListenerChecker(ShouldFire.class);
    private final LoadingCache<Class<? extends Event>, RegisteredListener.Cache> handlersCache = Caffeine.newBuilder().initialCapacity(150).build(eventClass -> this.bakeHandlers((Class)eventClass));

    @Inject
    public SpongeEventManager(Logger logger, PluginManager pluginManager) {
        this.logger = logger;
        this.pluginManager = (PluginManager)Preconditions.checkNotNull((Object)pluginManager, (Object)"pluginManager");
        try {
            Field innerCache = this.handlersCache.getClass().getSuperclass().getDeclaredField("cache");
            innerCache.setAccessible(true);
            Object innerCacheValue = innerCache.get(this.handlersCache);
            Class<?> innerCacheClass = innerCacheValue.getClass();
            Field cacheData = innerCacheClass.getDeclaredField("data");
            cacheData.setAccessible(true);
            ConcurrentHashMap newBackingData = new ConcurrentHashMap(150, 0.75f, 1);
            cacheData.set(innerCacheValue, newBackingData);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            this.logger.warn("Failed to set event cache backing array, type was " + this.handlersCache.getClass().getName());
            this.logger.warn("  Caused by: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends Event> RegisteredListener.Cache bakeHandlers(Class<T> rootEvent) {
        ArrayList handlers = Lists.newArrayList();
        Set types = TypeToken.of(rootEvent).getTypes().rawTypes();
        Object object = this.lock;
        synchronized (object) {
            for (Class type : types) {
                if (!Event.class.isAssignableFrom(type)) continue;
                handlers.addAll(this.handlersByEvent.get((Object)type));
            }
        }
        Collections.sort(handlers);
        return new RegisteredListener.Cache(handlers);
    }

    @Nullable
    private static String getHandlerErrorOrNull(Method method) {
        Class<?>[] parameters;
        int modifiers = method.getModifiers();
        ArrayList<String> errors = new ArrayList<String>();
        if (Modifier.isStatic(modifiers)) {
            errors.add("method must not be static");
        }
        if (!Modifier.isPublic(modifiers)) {
            errors.add("method must be public");
        }
        if (Modifier.isAbstract(modifiers)) {
            errors.add("method must not be abstract");
        }
        if (method.getDeclaringClass().isInterface()) {
            errors.add("interfaces cannot declare listeners");
        }
        if (method.getReturnType() != Void.TYPE) {
            errors.add("method must return void");
        }
        if ((parameters = method.getParameterTypes()).length == 0 || !Event.class.isAssignableFrom(parameters[0])) {
            errors.add("method must have an Event as its first parameter");
        }
        if (errors.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)", ", errors);
    }

    private void register(RegisteredListener<? extends Event> handler) {
        this.register(Collections.singletonList(handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(List<RegisteredListener<? extends Event>> handlers) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            for (RegisteredListener<? extends Event> handler : handlers) {
                if (!this.handlersByEvent.put(handler.getEventClass(), handler)) continue;
                changed = true;
                this.checker.registerListenerFor(handler.getEventClass());
            }
        }
        if (changed) {
            this.handlersCache.invalidateAll();
        }
    }

    protected boolean hasAnyListeners(Class<? extends Event> clazz) {
        return !this.handlersCache.get(clazz).getListeners().isEmpty();
    }

    public void registerListener(PluginContainer plugin, Object listenerObject) {
        String error;
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin");
        Preconditions.checkNotNull((Object)listenerObject, (Object)"listener");
        if (this.registeredListeners.contains(listenerObject)) {
            this.logger.warn("Plugin {} attempted to register an already registered listener ({})", new Object[]{plugin.getId(), listenerObject.getClass().getName()});
            Thread.dumpStack();
            return;
        }
        ArrayList handlers = Lists.newArrayList();
        HashMap<Method, String> methodErrors = new HashMap<Method, String>();
        Class<?> handle = listenerObject.getClass();
        for (Method method : handle.getMethods()) {
            Listener listener = method.getAnnotation(Listener.class);
            if (listener == null) continue;
            error = SpongeEventManager.getHandlerErrorOrNull(method);
            if (error == null) {
                AnnotatedEventListener handler;
                Class<?> eventClass = method.getParameterTypes()[0];
                try {
                    handler = this.handlerFactory.create(listenerObject, method);
                }
                catch (Exception e) {
                    this.logger.error("Failed to create handler for {} on {}", new Object[]{method, handle, e});
                    continue;
                }
                handlers.add(SpongeEventManager.createRegistration(plugin, eventClass, listener, handler));
                continue;
            }
            methodErrors.put(method, error);
        }
        for (Class<?> handleParent = handle; handleParent != Object.class; handleParent = handleParent.getSuperclass()) {
            for (Method method : handleParent.getDeclaredMethods()) {
                if (method.getAnnotation(Listener.class) == null || methodErrors.containsKey(method) || (error = SpongeEventManager.getHandlerErrorOrNull(method)) == null) continue;
                methodErrors.put(method, error);
            }
        }
        for (Map.Entry entry : methodErrors.entrySet()) {
            this.logger.warn("Invalid listener method {} in {}: {}", new Object[]{entry.getKey(), ((Method)entry.getKey()).getDeclaringClass().getName(), entry.getValue()});
        }
        this.registeredListeners.add(listenerObject);
        this.register(handlers);
    }

    private static <T extends Event> RegisteredListener<T> createRegistration(PluginContainer plugin, Class<T> eventClass, Listener listener, EventListener<? super T> handler) {
        return SpongeEventManager.createRegistration(plugin, eventClass, listener.order(), listener.beforeModifications(), handler);
    }

    private static <T extends Event> RegisteredListener<T> createRegistration(PluginContainer plugin, Class<T> eventClass, Order order, boolean beforeModifications, EventListener<? super T> handler) {
        return new RegisteredListener<T>(plugin, eventClass, order, handler, beforeModifications);
    }

    private PluginContainer getPlugin(Object plugin) {
        Optional<PluginContainer> container = this.pluginManager.fromInstance(plugin);
        Preconditions.checkArgument((boolean)container.isPresent(), (String)"Unknown plugin: %s", (Object[])new Object[]{plugin});
        return container.get();
    }

    @Override
    public void registerListeners(Object plugin, Object listener) {
        this.registerListener(this.getPlugin(plugin), listener);
    }

    @Override
    public <T extends Event> void registerListener(Object plugin, Class<T> eventClass, EventListener<? super T> handler) {
        this.registerListener(plugin, eventClass, Order.DEFAULT, handler);
    }

    @Override
    public <T extends Event> void registerListener(Object plugin, Class<T> eventClass, Order order, EventListener<? super T> handler) {
        this.register(SpongeEventManager.createRegistration(this.getPlugin(plugin), eventClass, order, false, handler));
    }

    @Override
    public <T extends Event> void registerListener(Object plugin, Class<T> eventClass, Order order, boolean beforeModifications, EventListener<? super T> handler) {
        this.register(SpongeEventManager.createRegistration(this.getPlugin(plugin), eventClass, order, beforeModifications, handler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(Predicate<RegisteredListener<?>> unregister) {
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            Iterator itr = this.handlersByEvent.values().iterator();
            while (itr.hasNext()) {
                RegisteredListener handler = (RegisteredListener)itr.next();
                if (!unregister.test(handler)) continue;
                itr.remove();
                changed = true;
                this.checker.unregisterListenerFor(handler.getEventClass());
            }
        }
        if (changed) {
            this.handlersCache.invalidateAll();
        }
    }

    @Override
    public void unregisterListeners(Object listener) {
        Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.unregister(handler -> listener.equals(handler.getHandle()));
        this.registeredListeners.remove(listener);
    }

    @Override
    public void unregisterPluginListeners(Object pluginObj) {
        PluginContainer plugin = this.getPlugin(pluginObj);
        this.unregister(handler -> plugin.equals(handler.getPlugin()));
    }

    protected RegisteredListener.Cache getHandlerCache(Event event) {
        return this.handlersCache.get(((Event)Preconditions.checkNotNull((Object)event, (Object)"event")).getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean post(Event event, List<RegisteredListener<?>> handlers) {
        for (RegisteredListener<?> handler : handlers) {
            CauseTracker.getInstance().getCurrentContext().activeContainer(handler.getPlugin());
            try {
                handler.getTimingsHandler().startTimingIfSync();
                if (event instanceof AbstractEvent) {
                    ((AbstractEvent)event).currentOrder = handler.getOrder();
                }
                handler.handle(event);
            }
            catch (Throwable e) {
                this.logger.error("Could not pass {} to {}", new Object[]{event.getClass().getSimpleName(), handler.getPlugin(), e});
            }
            finally {
                handler.getTimingsHandler().stopTimingIfSync();
                CauseTracker.getInstance().getCurrentContext().activeContainer(null);
            }
        }
        if (event instanceof AbstractEvent) {
            ((AbstractEvent)event).currentOrder = null;
        }
        return event instanceof Cancellable && ((Cancellable)((Object)event)).isCancelled();
    }

    @Override
    public boolean post(Event event) {
        return this.post(event, this.getHandlerCache(event).getListeners());
    }

    public boolean post(Event event, boolean allowClientThread) {
        return this.post(event);
    }

    public boolean post(Event event, Order order) {
        return this.post(event, this.getHandlerCache(event).getListenersByOrder(order));
    }
}

