/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.entity.spawn.EntitySpawnCause;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

public class PlayerPhase
extends TrackingPhase {
    public static PlayerPhase getInstance() {
        return Holder.INSTANCE;
    }

    private PlayerPhase() {
    }

    @Override
    public void unwind(IPhaseState state, PhaseContext phaseContext) {
        Player player = phaseContext.firstNamed("Source", Player.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing a player leaving, but we're not!", phaseContext));
        phaseContext.getCapturedItemsSupplier().ifPresentAndNotEmpty(items -> {
            Cause cause = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(player)).type(InternalSpawnTypes.DISPENSE)).build()).build();
            ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
            for (EntityItem item : items) {
                entities.add(EntityUtil.fromNative((Entity)item));
            }
            DropItemEvent.Dispense dispense = SpongeEventFactory.createDropItemEventDispense(cause, entities);
            SpongeImpl.postEvent(dispense);
            if (!dispense.isCancelled()) {
                for (org.spongepowered.api.entity.Entity entity : dispense.getEntities()) {
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        });
        phaseContext.getCapturedItemStackSupplier().ifPresentAndNotEmpty(items -> {
            List drops = items.stream().map(drop -> drop.create(EntityUtil.getMinecraftWorld(player))).collect(Collectors.toList());
            Cause.Builder builder = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(player)).type(InternalSpawnTypes.DROPPED_ITEM)).build());
            Cause cause = builder.build();
            List entities = drops;
            if (!entities.isEmpty()) {
                DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(cause, entities);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity droppedItem : event.getEntities()) {
                        EntityUtil.getMixinWorld(droppedItem).forceSpawnEntity(droppedItem);
                    }
                }
            }
        });
        phaseContext.getCapturedBlockSupplier().ifPresentAndNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, state, phaseContext));
    }

    private static final class Holder {
        static final PlayerPhase INSTANCE = new PlayerPhase();

        private Holder() {
        }
    }

    static final class PlayerPhaseState
    implements IPhaseState {
        PlayerPhaseState() {
        }

        @Override
        public TrackingPhase getPhase() {
            return TrackingPhases.PLAYER;
        }
    }

    public static final class State {
        public static final IPhaseState PLAYER_LOGOUT = new PlayerPhaseState();
    }
}

