/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.teleport.TeleportCause;
import org.spongepowered.api.event.cause.entity.teleport.TeleportTypes;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.Identifiable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

public abstract class TrackingPhase {
    private final List<TrackingPhase> children = new ArrayList<TrackingPhase>();

    public abstract void unwind(IPhaseState var1, PhaseContext var2);

    public void postDispatch(IPhaseState unwindingState, PhaseContext unwindingContext, PhaseContext postContext) {
    }

    public void processPostItemSpawns(IPhaseState unwindingState, ArrayList<org.spongepowered.api.entity.Entity> items) {
        TrackingUtil.splitAndSpawnEntities(InternalSpawnTypes.UNKNOWN_CAUSE, items);
    }

    public void processPostEntitySpawns(IPhaseState unwindingState, PhaseContext phaseContext, ArrayList<org.spongepowered.api.entity.Entity> entities) {
        Optional<User> creator = Optional.ofNullable(phaseContext.getNotifier().orElseGet(() -> phaseContext.getOwner().orElse(null)));
        TrackingUtil.splitAndSpawnEntities(InternalSpawnTypes.UNKNOWN_CAUSE, entities, entity -> creator.map(Identifiable::getUniqueId).ifPresent(entity::setCreator));
    }

    public boolean requiresBlockCapturing(IPhaseState currentState) {
        return true;
    }

    public boolean ignoresBlockUpdateTick(PhaseData phaseData) {
        return false;
    }

    public boolean allowEntitySpawns(IPhaseState currentState) {
        return true;
    }

    public boolean ignoresBlockEvent(IPhaseState phaseState) {
        return false;
    }

    public boolean ignoresScheduledUpdates(IPhaseState phaseState) {
        return false;
    }

    public boolean alreadyCapturingBlockTicks(IPhaseState phaseState, PhaseContext context) {
        return false;
    }

    public boolean alreadyCapturingEntitySpawns(IPhaseState state) {
        return false;
    }

    public boolean alreadyCapturingEntityTicks(IPhaseState state) {
        return false;
    }

    public boolean alreadyCapturingTileTicks(IPhaseState state) {
        return false;
    }

    public boolean requiresPost(IPhaseState state) {
        return true;
    }

    public boolean alreadyCapturingItemSpawns(IPhaseState currentState) {
        return false;
    }

    public boolean ignoresItemPreMerging(IPhaseState currentState) {
        return false;
    }

    public boolean isWorldGeneration(IPhaseState state) {
        return false;
    }

    public boolean doesCaptureEntityDrops(IPhaseState currentState) {
        return false;
    }

    public void associateAdditionalCauses(IPhaseState state, PhaseContext context, Cause.Builder builder) {
    }

    public boolean isRestoring(IPhaseState state, PhaseContext context, int updateFlag) {
        return false;
    }

    public void capturePlayerUsingStackToBreakBlock(@Nullable ItemStack itemStack, EntityPlayerMP playerMP, IPhaseState state, PhaseContext context, CauseTracker causeTracker) {
    }

    public void appendNotifierPreBlockTick(IMixinWorldServer mixinWorld, BlockPos pos, IPhaseState currentState, PhaseContext context, PhaseContext newContext) {
        Chunk chunk = mixinWorld.asMinecraftWorld().func_175726_f(pos);
        IMixinChunk mixinChunk = (IMixinChunk)chunk;
        if (chunk != null && !chunk.func_76621_g()) {
            mixinChunk.getBlockOwner(pos).ifPresent(newContext::owner);
            mixinChunk.getBlockNotifier(pos).ifPresent(newContext::notifier);
        }
    }

    public boolean spawnEntityOrCapture(IPhaseState phaseState, PhaseContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        Entity minecraftEntity = (Entity)entity;
        WorldServer minecraftWorld = (WorldServer)minecraftEntity.field_70170_p;
        User user = context.getNotifier().orElseGet(() -> context.getOwner().orElse(null));
        if (user != null) {
            entity.setCreator(user.getUniqueId());
        }
        ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
        entities.add(entity);
        SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(InternalSpawnTypes.UNKNOWN_CAUSE, entities);
        SpongeImpl.postEvent(event);
        if (!event.isCancelled() && event.getEntities().size() > 0) {
            for (org.spongepowered.api.entity.Entity item : event.getEntities()) {
                ((IMixinWorldServer)((Object)item.getWorld())).forceSpawnEntity(item);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).toString();
    }

    public Optional<DamageSource> createDestructionDamageSource(IPhaseState state, PhaseContext context, Entity entity) {
        return Optional.empty();
    }

    public void addNotifierToBlockEvent(IPhaseState phaseState, PhaseContext context, IMixinWorldServer mixinWorld, BlockPos pos, IMixinBlockEventData blockEvent) {
    }

    public void associateNeighborStateNotifier(IPhaseState state, PhaseContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
    }

    public boolean populateCauseForNotifyNeighborEvent(IPhaseState state, PhaseContext context, Cause.Builder builder, CauseTracker causeTracker, IMixinChunk mixinChunk, BlockPos pos) {
        Optional<User> notifier = context.firstNamed("Notifier", User.class);
        if (notifier.isPresent()) {
            builder.named(NamedCause.notifier(notifier.get()));
            return true;
        }
        mixinChunk.getBlockNotifier(pos).ifPresent(user -> builder.named(NamedCause.notifier(user)));
        mixinChunk.getBlockOwner(pos).ifPresent(owner -> builder.named(NamedCause.owner(owner)));
        return true;
    }

    public Cause generateTeleportCause(IPhaseState state, PhaseContext context) {
        return Cause.of(NamedCause.source(((TeleportCause.Builder)TeleportCause.builder().type(TeleportTypes.UNKNOWN)).build()));
    }

    public boolean appendPreBlockProtectedCheck(Cause.Builder builder, IPhaseState phaseState, PhaseContext context, CauseTracker causeTracker) {
        if (context.getSource(Player.class).isPresent()) {
            builder.named(NamedCause.notifier(context.getSource(Player.class).get()));
            return true;
        }
        return false;
    }

    public boolean isTicking(IPhaseState state) {
        return false;
    }

    public boolean handlesOwnPhaseCompletion(IPhaseState state) {
        return false;
    }

    public boolean requiresDimensionTransferBetweenWorlds(IPhaseState state) {
        return false;
    }

    public void appendContextPreExplosion(PhaseContext phaseContext, PhaseData currentPhaseData) {
    }

    public void appendExplosionCause(PhaseData phaseData) {
    }
}

