/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.spawn.LocatableBlockSpawnCause;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

final class BlockDecayPhaseState
extends BlockPhaseState {
    BlockDecayPhaseState() {
    }

    @Override
    void unwind(PhaseContext context) {
        LocatableBlock locatable = context.getSource(LocatableBlock.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over at a location!", context));
        Location<World> worldLocation = locatable.getLocation();
        BlockPos blockPos = ((IMixinLocation)((Object)worldLocation)).getBlockPos();
        IMixinWorldServer mixinWorld = (IMixinWorldServer)((Object)worldLocation.getExtent());
        IMixinChunk mixinChunk = (IMixinChunk)mixinWorld.asMinecraftWorld().func_175726_f(blockPos);
        Optional<User> notifier = mixinChunk.getBlockNotifier(blockPos);
        Optional<User> creator = mixinChunk.getBlockOwner(blockPos);
        context.getCapturedItemsSupplier().ifPresentAndNotEmpty(items -> {});
        context.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
            Cause.Builder builder = Cause.source(((LocatableBlockSpawnCause.Builder)((LocatableBlockSpawnCause.Builder)LocatableBlockSpawnCause.builder().locatableBlock(locatable)).type(InternalSpawnTypes.BLOCK_SPAWNING)).build());
            context.getNotifier().ifPresent(builder::notifier);
            context.getOwner().ifPresent(builder::owner);
            Cause cause = builder.build();
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(cause, entities);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                for (Entity entity : event.getEntities()) {
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        });
        context.getCapturedBlockSupplier().ifPresentAndNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, this, context));
        context.getCapturedItemStackSupplier().ifPresentAndNotEmpty(drops -> {
            List items = drops.stream().map(drop -> drop.create(mixinWorld.asMinecraftWorld())).collect(Collectors.toList());
            Cause.Builder builder = Cause.source(((LocatableBlockSpawnCause.Builder)((LocatableBlockSpawnCause.Builder)LocatableBlockSpawnCause.builder().locatableBlock(locatable)).type(InternalSpawnTypes.BLOCK_SPAWNING)).build());
            notifier.ifPresent(user -> builder.named(NamedCause.notifier(user)));
            creator.ifPresent(user -> builder.named(NamedCause.owner(user)));
            Cause cause = builder.build();
            List entities = items;
            if (!entities.isEmpty()) {
                DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(cause, entities);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    for (Entity droppedItem : event.getEntities()) {
                        mixinWorld.forceSpawnEntity(droppedItem);
                    }
                }
            }
        });
    }
}

