/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.spawn.BlockSpawnCause;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.block.BlockPhaseState;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

final class BlockDropItemsPhaseState
extends BlockPhaseState {
    BlockDropItemsPhaseState() {
    }

    @Override
    void unwind(PhaseContext phaseContext) {
        BlockSnapshot blockSnapshot = phaseContext.getSource(BlockSnapshot.class).orElseThrow(TrackingUtil.throwWithContext("Could not find a block dropping items!", phaseContext));
        phaseContext.getCapturedItemsSupplier().ifPresentAndNotEmpty(items -> {
            Cause.Builder builder = Cause.source(((BlockSpawnCause.Builder)((BlockSpawnCause.Builder)BlockSpawnCause.builder().block(blockSnapshot)).type(InternalSpawnTypes.DROPPED_ITEM)).build());
            phaseContext.getNotifier().ifPresent(builder::notifier);
            phaseContext.getOwner().ifPresent(builder::owner);
            Cause cause = builder.build();
            ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>();
            for (EntityItem item : items) {
                entities.add(EntityUtil.fromNative((Entity)item));
            }
            DropItemEvent.Destruct event = SpongeEventFactory.createDropItemEventDestruct(cause, entities);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        });
        phaseContext.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
            Cause.Builder builder = Cause.source(((BlockSpawnCause.Builder)((BlockSpawnCause.Builder)BlockSpawnCause.builder().block(blockSnapshot)).type(InternalSpawnTypes.DROPPED_ITEM)).build());
            phaseContext.getNotifier().ifPresent(builder::notifier);
            phaseContext.getOwner().ifPresent(builder::owner);
            Cause cause = builder.build();
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(cause, entities);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                for (org.spongepowered.api.entity.Entity entity : event.getEntities()) {
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        });
        Location<World> worldLocation = blockSnapshot.getLocation().get();
        BlockPos blockPos = ((IMixinLocation)((Object)worldLocation)).getBlockPos();
        IMixinWorldServer mixinWorld = (IMixinWorldServer)((Object)worldLocation.getExtent());
        IMixinChunk mixinChunk = (IMixinChunk)mixinWorld.asMinecraftWorld().func_175726_f(blockPos);
        Optional<User> notifier = mixinChunk.getBlockNotifier(blockPos);
        Optional<User> creator = mixinChunk.getBlockOwner(blockPos);
        phaseContext.getCapturedBlockSupplier().ifPresentAndNotEmpty(blocks -> TrackingUtil.processBlockCaptures(blocks, this, phaseContext));
        phaseContext.getCapturedItemStackSupplier().ifPresentAndNotEmpty(drops -> {
            List items = drops.stream().map(drop -> drop.create(mixinWorld.asMinecraftWorld())).collect(Collectors.toList());
            Cause.Builder builder = Cause.source(((BlockSpawnCause.Builder)((BlockSpawnCause.Builder)BlockSpawnCause.builder().block(blockSnapshot)).type(InternalSpawnTypes.BLOCK_SPAWNING)).build());
            notifier.ifPresent(user -> builder.named(NamedCause.notifier(user)));
            creator.ifPresent(user -> builder.named(NamedCause.owner(user)));
            Cause cause = builder.build();
            List entities = items;
            if (!entities.isEmpty()) {
                DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(cause, entities);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    for (org.spongepowered.api.entity.Entity droppedItem : event.getEntities()) {
                        mixinWorld.forceSpawnEntity(droppedItem);
                    }
                }
            }
        });
    }
}

