/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.entity;

import net.minecraft.world.WorldServer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.entity.ChangingToDimensionState;
import org.spongepowered.common.event.tracking.phase.entity.DeathPhase;
import org.spongepowered.common.event.tracking.phase.entity.DeathUpdateState;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhaseState;
import org.spongepowered.common.event.tracking.phase.entity.LeavingDimensionState;
import org.spongepowered.common.event.tracking.phase.entity.PlayerWakeUpState;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;

public final class EntityPhase
extends TrackingPhase {
    @Override
    public void unwind(IPhaseState state, PhaseContext phaseContext) {
        if (state instanceof EntityPhaseState) {
            ((EntityPhaseState)state).unwind(phaseContext);
        }
    }

    @Override
    public boolean spawnEntityOrCapture(IPhaseState phaseState, PhaseContext context, Entity entity, int chunkX, int chunkZ) {
        if (phaseState == State.CHANGING_DIMENSION) {
            WorldServer worldServer = context.firstNamed("TargetWorld", WorldServer.class).orElseThrow(TrackingUtil.throwWithContext("Expected to capture the target World for a teleport!", context));
            ((IMixinWorldServer)worldServer).forceSpawnEntity(entity);
            return true;
        }
        return super.spawnEntityOrCapture(phaseState, context, entity, chunkX, chunkZ);
    }

    @Override
    public boolean doesCaptureEntityDrops(IPhaseState currentState) {
        return true;
    }

    public static EntityPhase getInstance() {
        return Holder.INSTANCE;
    }

    private EntityPhase() {
    }

    private static final class Holder {
        static final EntityPhase INSTANCE = new EntityPhase();

        private Holder() {
        }
    }

    public static final class State {
        public static final IPhaseState DEATH = new DeathPhase();
        public static final IPhaseState DEATH_UPDATE = new DeathUpdateState();
        public static final IPhaseState CHANGING_DIMENSION = new ChangingToDimensionState();
        public static final IPhaseState LEAVING_DIMENSION = new LeavingDimensionState();
        public static final IPhaseState PLAYER_WAKE_UP = new PlayerWakeUpState();

        private State() {
        }
    }
}

