/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.general;

import org.spongepowered.api.entity.Entity;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.general.GeneralState;

final class PostState
extends GeneralState {
    PostState() {
    }

    @Override
    public boolean canSwitchTo(IPhaseState state) {
        return state.getPhase() == TrackingPhases.GENERATION || state == BlockPhase.State.RESTORING_BLOCKS;
    }

    @Override
    public boolean requiresPost() {
        return false;
    }

    @Override
    public boolean tracksBlockRestores() {
        return false;
    }

    @Override
    void unwind(PhaseContext context) {
        IPhaseState unwindingState = context.firstNamed("UnwindingState", IPhaseState.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be unwinding a phase, but no phase found!", context));
        PhaseContext unwindingContext = context.firstNamed("UnwindingContext", PhaseContext.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be unwinding a phase, but no context found!", context));
        this.getPhase().postDispatch(unwindingState, unwindingContext, context);
    }

    public void appendContextPreExplosion(PhaseContext phaseContext, PhaseData currentPhaseData) {
        PhaseContext unwinding = currentPhaseData.context.first(PhaseContext.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be unwinding with a PhaseContext, but couldn't!", currentPhaseData.context));
        IPhaseState phaseState = currentPhaseData.context.first(IPhaseState.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be unwinding with an IPhaseState, but couldn't!", currentPhaseData.context));
        PhaseData phaseData = new PhaseData(unwinding, phaseState);
        phaseState.getPhase().appendContextPreExplosion(phaseContext, phaseData);
    }

    @Override
    public boolean spawnEntityOrCapture(PhaseContext context, Entity entity, int chunkX, int chunkZ) {
        return context.getCapturedEntities().add(entity);
    }
}

