/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.spawn.EntitySpawnCause;
import org.spongepowered.api.event.item.inventory.ClickInventoryEvent;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

final class DropItemOutsideWindowState
extends BasicInventoryPacketState {
    DropItemOutsideWindowState() {
        super(PacketPhase.MODE_CLICK | 1 | 2 | 0x20000);
    }

    @Override
    public boolean doesCaptureEntityDrops() {
        return true;
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, PhaseContext context) {
        super.populateContext(playerMP, packet, context);
    }

    @Override
    public ClickInventoryEvent createInventoryEvent(EntityPlayerMP playerMP, Container openContainer, Transaction<ItemStackSnapshot> transaction, List<SlotTransaction> slotTransactions, List<org.spongepowered.api.entity.Entity> capturedEntities, Cause cause, int usedButton) {
        Cause spawnCause = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(EntityUtil.fromNative((Entity)playerMP))).type(InternalSpawnTypes.DROPPED_ITEM)).build()).named(NamedCause.of("Container", openContainer)).build();
        for (org.spongepowered.api.entity.Entity currentEntity : capturedEntities) {
            currentEntity.setCreator(playerMP.func_110124_au());
        }
        return usedButton == 0 ? SpongeEventFactory.createClickInventoryEventDropOutsidePrimary(spawnCause, transaction, capturedEntities, openContainer, slotTransactions) : SpongeEventFactory.createClickInventoryEventDropOutsideSecondary(spawnCause, transaction, capturedEntities, openContainer, slotTransactions);
    }

    @Override
    public boolean ignoresItemPreMerges() {
        return true;
    }
}

