/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.spawn.EntitySpawnCause;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

public interface IPacketState
extends IPhaseState {
    public boolean matches(int var1);

    default public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, PhaseContext context) {
    }

    default public boolean isPacketIgnored(Packet<?> packetIn, EntityPlayerMP packetPlayer) {
        return false;
    }

    default public boolean ignoresItemPreMerges() {
        return false;
    }

    default public boolean doesCaptureEntityDrops() {
        return false;
    }

    default public boolean doBlockCapturing() {
        return true;
    }

    default public void postSpawnEntities(PhaseContext phaseContext, ArrayList<org.spongepowered.api.entity.Entity> entities) {
        Player player = phaseContext.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be capturing a player packet, but didn't get anything", phaseContext));
        EntitySpawnCause cause = (EntitySpawnCause)((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(player)).type(InternalSpawnTypes.PLACEMENT)).build();
        TrackingUtil.splitAndSpawnEntities(Cause.source(cause).build(), entities, entity -> entity.setCreator(player.getUniqueId()));
    }

    default public boolean shouldCaptureEntity() {
        return false;
    }

    default public boolean spawnEntity(PhaseContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        Entity minecraftEntity = (Entity)entity;
        WorldServer minecraftWorld = (WorldServer)minecraftEntity.field_70170_p;
        Player player = context.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be capturing a player", context));
        ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
        entities.add(entity);
        Cause.Builder builder = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(player)).type(InternalSpawnTypes.PLACEMENT)).build());
        builder.notifier(player);
        builder.owner(player);
        SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(builder.build(), entities);
        SpongeImpl.postEvent(event);
        if (!event.isCancelled()) {
            for (org.spongepowered.api.entity.Entity newEntity : event.getEntities()) {
                EntityUtil.toMixin(newEntity).setCreator(player.getUniqueId());
                ((IMixinWorldServer)minecraftWorld).forceSpawnEntity(newEntity);
            }
            return true;
        }
        return false;
    }

    default public void appendContextPreExplosion(PhaseContext phaseContext, PhaseData currentPhaseData) {
        currentPhaseData.context.first(Player.class).ifPresent(player -> phaseContext.add(NamedCause.source(player)));
    }
}

