/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketAnimation;
import net.minecraft.network.play.client.CPacketChatMessage;
import net.minecraft.network.play.client.CPacketClickWindow;
import net.minecraft.network.play.client.CPacketClientStatus;
import net.minecraft.network.play.client.CPacketCloseWindow;
import net.minecraft.network.play.client.CPacketConfirmTransaction;
import net.minecraft.network.play.client.CPacketCreativeInventoryAction;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.client.CPacketEnchantItem;
import net.minecraft.network.play.client.CPacketEntityAction;
import net.minecraft.network.play.client.CPacketHeldItemChange;
import net.minecraft.network.play.client.CPacketInput;
import net.minecraft.network.play.client.CPacketKeepAlive;
import net.minecraft.network.play.client.CPacketPlayer;
import net.minecraft.network.play.client.CPacketPlayerAbilities;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.client.CPacketPlayerTryUseItem;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.network.play.client.CPacketResourcePackStatus;
import net.minecraft.network.play.client.CPacketSpectate;
import net.minecraft.network.play.client.CPacketTabComplete;
import net.minecraft.network.play.client.CPacketUpdateSign;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.packet.AttackEntityPacketState;
import org.spongepowered.common.event.tracking.phase.packet.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.event.tracking.phase.packet.ChatPacketState;
import org.spongepowered.common.event.tracking.phase.packet.CloseWindowState;
import org.spongepowered.common.event.tracking.phase.packet.CreativeInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.DoubleClickInventoryState;
import org.spongepowered.common.event.tracking.phase.packet.DropItemOutsideWindowState;
import org.spongepowered.common.event.tracking.phase.packet.DropItemWithHotkeyState;
import org.spongepowered.common.event.tracking.phase.packet.IPacketState;
import org.spongepowered.common.event.tracking.phase.packet.IgnoredPacketState;
import org.spongepowered.common.event.tracking.phase.packet.InteractAtEntityPacketState;
import org.spongepowered.common.event.tracking.phase.packet.InteractEntityPacketState;
import org.spongepowered.common.event.tracking.phase.packet.InteractionPacketState;
import org.spongepowered.common.event.tracking.phase.packet.InvalidPacketState;
import org.spongepowered.common.event.tracking.phase.packet.MiddleInventoryClickState;
import org.spongepowered.common.event.tracking.phase.packet.MovementPacketState;
import org.spongepowered.common.event.tracking.phase.packet.NoCaptureUseItemPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketFunction;
import org.spongepowered.common.event.tracking.phase.packet.PlaceBlockPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PrimaryInventoryClickState;
import org.spongepowered.common.event.tracking.phase.packet.PrimaryInventoryShiftClick;
import org.spongepowered.common.event.tracking.phase.packet.SecondaryInventoryClickState;
import org.spongepowered.common.event.tracking.phase.packet.SecondaryInventoryShiftClickState;
import org.spongepowered.common.event.tracking.phase.packet.StopSleepingPacketState;
import org.spongepowered.common.event.tracking.phase.packet.SwitchHotbarNumberPressState;
import org.spongepowered.common.event.tracking.phase.packet.SwitchHotbarScrollState;
import org.spongepowered.common.event.tracking.phase.packet.UnknownPacketState;
import org.spongepowered.common.event.tracking.phase.packet.UpdateSignState;
import org.spongepowered.common.event.tracking.phase.packet.UseItemPacketState;
import org.spongepowered.common.event.tracking.phase.packet.drag.DragInventoryAddSlotState;
import org.spongepowered.common.event.tracking.phase.packet.drag.DragInventoryStartState;
import org.spongepowered.common.event.tracking.phase.packet.drag.PrimaryDragInventoryStopState;
import org.spongepowered.common.event.tracking.phase.packet.drag.SecondaryDragInventoryStopState;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;

public final class PacketPhase
extends TrackingPhase {
    public static final int MAGIC_CLICK_OUTSIDE_SURVIVAL = -999;
    public static final int MAGIC_CLICK_OUTSIDE_CREATIVE = -1;
    public static final int MASK_NONE = 0;
    public static final int MASK_OUTSIDE = 196608;
    public static final int MASK_MODE = 65024;
    public static final int MASK_DRAGDATA = 504;
    public static final int MASK_BUTTON = 7;
    public static final int MASK_ALL = 262143;
    public static final int MASK_NORMAL = 65535;
    public static final int MASK_DRAG = 262143;
    public static final int CLICK_INSIDE_WINDOW = 65536;
    public static final int CLICK_OUTSIDE_WINDOW = 131072;
    public static final int CLICK_ANYWHERE = 196608;
    public static final int MODE_CLICK = 512 << ClickType.PICKUP.ordinal();
    public static final int MODE_SHIFT_CLICK = 512 << ClickType.QUICK_MOVE.ordinal();
    public static final int MODE_HOTBAR = 512 << ClickType.SWAP.ordinal();
    public static final int MODE_PICKBLOCK = 512 << ClickType.CLONE.ordinal();
    public static final int MODE_DROP = 512 << ClickType.THROW.ordinal();
    public static final int MODE_DRAG = 512 << ClickType.QUICK_CRAFT.ordinal();
    public static final int MODE_DOUBLE_CLICK = 512 << ClickType.PICKUP_ALL.ordinal();
    public static final int DRAG_MODE_PRIMARY_BUTTON = 64;
    public static final int DRAG_MODE_SECONDARY_BUTTON = 128;
    public static final int DRAG_MODE_MIDDLE_BUTTON = 256;
    public static final int DRAG_MODE_ANY = 448;
    public static final int DRAG_STATUS_STARTED = 8;
    public static final int DRAG_STATUS_ADD_SLOT = 16;
    public static final int DRAG_STATUS_STOPPED = 32;
    public static final int BUTTON_PRIMARY = 1;
    public static final int BUTTON_SECONDARY = 2;
    public static final int BUTTON_MIDDLE = 4;
    public static final int PACKET_BUTTON_PRIMARY_ID = 0;
    public static final int PACKET_BUTTON_SECONDARY_ID = 0;
    public static final int PACKET_BUTTON_MIDDLE_ID = 0;
    private final Map<Class<? extends Packet<?>>, Function<Packet<?>, IPacketState>> packetTranslationMap = new IdentityHashMap();
    private final Map<Class<? extends Packet<?>>, PacketFunction> packetUnwindMap = new IdentityHashMap();
    public static final ImmutableMap<CPacketEntityAction.Action, IPacketState> PLAYER_ACTION_MAPPINGS = ImmutableMap.builder().put((Object)CPacketEntityAction.Action.START_SNEAKING, (Object)General.START_SNEAKING).put((Object)CPacketEntityAction.Action.STOP_SNEAKING, (Object)General.STOP_SNEAKING).put((Object)CPacketEntityAction.Action.STOP_SLEEPING, (Object)General.STOP_SLEEPING).put((Object)CPacketEntityAction.Action.START_SPRINTING, (Object)General.START_SPRINTING).put((Object)CPacketEntityAction.Action.STOP_SPRINTING, (Object)General.STOP_SPRINTING).put((Object)CPacketEntityAction.Action.START_RIDING_JUMP, (Object)General.START_RIDING_JUMP).put((Object)CPacketEntityAction.Action.STOP_RIDING_JUMP, (Object)General.STOP_RIDING_JUMP).put((Object)CPacketEntityAction.Action.OPEN_INVENTORY, (Object)Inventory.OPEN_INVENTORY).put((Object)CPacketEntityAction.Action.START_FALL_FLYING, (Object)General.START_FALL_FLYING).build();
    public static final ImmutableMap<CPacketPlayerDigging.Action, IPacketState> INTERACTION_ACTION_MAPPINGS = ImmutableMap.builder().put((Object)CPacketPlayerDigging.Action.DROP_ITEM, (Object)Inventory.DROP_ITEM_WITH_HOTKEY).put((Object)CPacketPlayerDigging.Action.DROP_ALL_ITEMS, (Object)Inventory.DROP_ITEM_WITH_HOTKEY).put((Object)CPacketPlayerDigging.Action.START_DESTROY_BLOCK, (Object)General.INTERACTION).put((Object)CPacketPlayerDigging.Action.ABORT_DESTROY_BLOCK, (Object)General.INTERACTION).put((Object)CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, (Object)General.INTERACTION).put((Object)CPacketPlayerDigging.Action.RELEASE_USE_ITEM, (Object)General.INTERACTION).put((Object)CPacketPlayerDigging.Action.SWAP_HELD_ITEMS, (Object)General.SWAP_HAND_ITEMS).build();

    public boolean isPacketInvalid(Packet<?> packetIn, EntityPlayerMP packetPlayer, IPacketState packetState) {
        return packetState.isPacketIgnored(packetIn, packetPlayer);
    }

    public IPacketState getStateForPacket(Packet<?> packet) {
        Function<Packet<?>, IPacketState> packetStateFunction = this.packetTranslationMap.get(packet.getClass());
        if (packetStateFunction != null) {
            return packetStateFunction.apply(packet);
        }
        return General.UNKNOWN;
    }

    public PhaseContext populateContext(Packet<?> packet, EntityPlayerMP entityPlayerMP, IPhaseState state, PhaseContext context) {
        Preconditions.checkNotNull(packet, (Object)"Packet cannot be null!");
        Preconditions.checkArgument((!context.isComplete() ? 1 : 0) != 0, (Object)"PhaseContext cannot be marked as completed!");
        ((IPacketState)state).populateContext(entityPlayerMP, packet, context);
        return context;
    }

    @Override
    public boolean populateCauseForNotifyNeighborEvent(IPhaseState state, PhaseContext context, Cause.Builder builder, CauseTracker causeTracker, IMixinChunk mixinChunk, BlockPos pos) {
        if (!super.populateCauseForNotifyNeighborEvent(state, context, builder, causeTracker, mixinChunk, pos)) {
            Player player = context.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Processing a Player PAcket, expecting a player, but had none!", context));
            builder.named(NamedCause.notifier(player));
        }
        return true;
    }

    @Override
    public void associateNeighborStateNotifier(IPhaseState state, PhaseContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        Player player = context.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be tracking a player, but not!", context));
        ((IMixinChunk)minecraftWorld.func_175726_f(notifyPos)).setBlockNotifier(notifyPos, player.getUniqueId());
    }

    @Override
    public boolean doesCaptureEntityDrops(IPhaseState currentState) {
        return ((IPacketState)currentState).doesCaptureEntityDrops();
    }

    @Override
    public boolean alreadyCapturingItemSpawns(IPhaseState currentState) {
        return currentState == General.INTERACTION;
    }

    @Override
    public boolean ignoresItemPreMerging(IPhaseState currentState) {
        return ((IPacketState)currentState).ignoresItemPreMerges();
    }

    @Override
    public boolean spawnEntityOrCapture(IPhaseState phaseState, PhaseContext context, Entity entity, int chunkX, int chunkZ) {
        return ((IPacketState)phaseState).shouldCaptureEntity() ? context.getCapturedEntities().add(entity) : ((IPacketState)phaseState).spawnEntity(context, entity, chunkX, chunkZ);
    }

    @Override
    public void unwind(IPhaseState phaseState, PhaseContext phaseContext) {
        if (phaseState == General.INVALID) {
            return;
        }
        Packet packetIn = phaseContext.firstNamed("Packet", Packet.class).get();
        EntityPlayerMP player = phaseContext.getSource(EntityPlayerMP.class).get();
        Class<?> packetInClass = packetIn.getClass();
        PacketFunction unwindFunction = this.packetUnwindMap.get(packetInClass);
        Preconditions.checkArgument((boolean)(phaseState instanceof IPacketState), (String)"PhaseState passed in is not an instance of IPacketState! Got %s", (Object[])new Object[]{phaseState});
        if (unwindFunction != null) {
            unwindFunction.unwind(packetIn, (IPacketState)phaseState, player, phaseContext);
        } else {
            PacketFunction.UNKNOWN_PACKET.unwind(packetIn, (IPacketState)phaseState, player, phaseContext);
        }
    }

    @Override
    public boolean requiresBlockCapturing(IPhaseState currentState) {
        return ((IPacketState)currentState).doBlockCapturing();
    }

    @Override
    public boolean requiresPost(IPhaseState state) {
        return state != General.INVALID;
    }

    @Override
    public void processPostEntitySpawns(IPhaseState unwindingState, PhaseContext phaseContext, ArrayList<Entity> entities) {
        ((IPacketState)unwindingState).postSpawnEntities(phaseContext, entities);
    }

    @Override
    public void appendContextPreExplosion(PhaseContext phaseContext, PhaseData currentPhaseData) {
        ((IPacketState)currentPhaseData.state).appendContextPreExplosion(phaseContext, currentPhaseData);
    }

    @Override
    public void addNotifierToBlockEvent(IPhaseState phaseState, PhaseContext context, IMixinWorldServer mixinWorld, BlockPos pos, IMixinBlockEventData blockEvent) {
        ((BasicPacketState)phaseState).associateBlockEventNotifier(context, mixinWorld, pos, blockEvent);
    }

    public static BasicInventoryPacketState fromWindowPacket(CPacketClickWindow windowPacket) {
        int mode = 512 << windowPacket.func_186993_f().ordinal();
        int packed = windowPacket.func_149543_e();
        int unpacked = mode == MODE_DRAG ? 64 << (packed >> 2 & 3) | 8 << (packed & 3) : 1 << (packed & 3);
        BasicInventoryPacketState inventory = PacketPhase.fromState(PacketPhase.clickType(windowPacket.func_149544_d()) | mode | unpacked);
        if (inventory == Inventory.INVENTORY) {
            SpongeImpl.getLogger().warn(String.format("Unable to find InventoryPacketState handler for click window packet: %s", windowPacket));
        }
        return inventory;
    }

    private static int clickType(int slotId) {
        return slotId == -999 || slotId == -1 ? 131072 : 65536;
    }

    public static BasicInventoryPacketState fromState(int state) {
        for (BasicInventoryPacketState inventory : Inventory.VALUES) {
            if (!inventory.matches(state)) continue;
            return inventory;
        }
        return Inventory.INVENTORY;
    }

    public static PacketPhase getInstance() {
        return Holder.INSTANCE;
    }

    private PacketPhase() {
        this.setupPacketToStateMapping();
        this.setupPacketToUnwindMapping();
    }

    public void setupPacketToUnwindMapping() {
        this.packetUnwindMap.put(CPacketKeepAlive.class, PacketFunction.IGNORED);
        this.packetUnwindMap.put(CPacketChatMessage.class, PacketFunction.HANDLED_EXTERNALLY);
        this.packetUnwindMap.put(CPacketUseEntity.class, PacketFunction.USE_ENTITY);
        this.packetUnwindMap.put(CPacketPlayer.class, PacketFunction.MOVEMENT);
        this.packetUnwindMap.put(CPacketPlayer.Position.class, PacketFunction.MOVEMENT);
        this.packetUnwindMap.put(CPacketPlayer.Rotation.class, PacketFunction.MOVEMENT);
        this.packetUnwindMap.put(CPacketPlayer.PositionRotation.class, PacketFunction.MOVEMENT);
        this.packetUnwindMap.put(CPacketPlayerDigging.class, PacketFunction.ACTION);
        this.packetUnwindMap.put(CPacketPlayerTryUseItem.class, PacketFunction.USE_ITEM);
        this.packetUnwindMap.put(CPacketPlayerTryUseItemOnBlock.class, PacketFunction.PLACE_BLOCK);
        this.packetUnwindMap.put(CPacketHeldItemChange.class, PacketFunction.HELD_ITEM_CHANGE);
        this.packetUnwindMap.put(CPacketAnimation.class, PacketFunction.STOP_SLEEPING);
        this.packetUnwindMap.put(CPacketEntityAction.class, PacketFunction.IGNORED);
        this.packetUnwindMap.put(CPacketInput.class, PacketFunction.IGNORED);
        this.packetUnwindMap.put(CPacketCloseWindow.class, PacketFunction.CLOSE_WINDOW);
        this.packetUnwindMap.put(CPacketClickWindow.class, PacketFunction.INVENTORY);
        this.packetUnwindMap.put(CPacketConfirmTransaction.class, PacketFunction.IGNORED);
        this.packetUnwindMap.put(CPacketCreativeInventoryAction.class, PacketFunction.CREATIVE);
        this.packetUnwindMap.put(CPacketEnchantItem.class, PacketFunction.ENCHANTMENT);
        this.packetUnwindMap.put(CPacketUpdateSign.class, PacketFunction.HANDLED_EXTERNALLY);
        this.packetUnwindMap.put(CPacketPlayerAbilities.class, PacketFunction.IGNORED);
        this.packetUnwindMap.put(CPacketTabComplete.class, PacketFunction.HANDLED_EXTERNALLY);
        this.packetUnwindMap.put(CPacketClientStatus.class, PacketFunction.CLIENT_STATUS);
        this.packetUnwindMap.put(CPacketCustomPayload.class, PacketFunction.HANDLED_EXTERNALLY);
        this.packetUnwindMap.put(CPacketSpectate.class, PacketFunction.IGNORED);
        this.packetUnwindMap.put(CPacketResourcePackStatus.class, PacketFunction.RESOURCE_PACKET);
    }

    public void setupPacketToStateMapping() {
        this.packetTranslationMap.put(CPacketKeepAlive.class, packet -> General.IGNORED);
        this.packetTranslationMap.put(CPacketChatMessage.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(CPacketUseEntity.class, packet -> {
            CPacketUseEntity useEntityPacket = (CPacketUseEntity)packet;
            CPacketUseEntity.Action action = useEntityPacket.func_149565_c();
            if (action == CPacketUseEntity.Action.INTERACT) {
                return General.INTERACT_ENTITY;
            }
            if (action == CPacketUseEntity.Action.ATTACK) {
                return General.ATTACK_ENTITY;
            }
            if (action == CPacketUseEntity.Action.INTERACT_AT) {
                return General.INTERACT_AT_ENTITY;
            }
            return General.INVALID;
        });
        this.packetTranslationMap.put(CPacketPlayer.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(CPacketPlayer.Position.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(CPacketPlayer.Rotation.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(CPacketPlayer.PositionRotation.class, packet -> General.MOVEMENT);
        this.packetTranslationMap.put(CPacketPlayerDigging.class, packet -> {
            CPacketPlayerDigging playerDigging = (CPacketPlayerDigging)packet;
            CPacketPlayerDigging.Action action = playerDigging.func_180762_c();
            IPacketState state = (IPacketState)INTERACTION_ACTION_MAPPINGS.get((Object)action);
            return state == null ? General.UNKNOWN : state;
        });
        this.packetTranslationMap.put(CPacketPlayerTryUseItemOnBlock.class, packet -> {
            CPacketPlayerTryUseItemOnBlock blockPlace = (CPacketPlayerTryUseItemOnBlock)packet;
            BlockPos blockPos = blockPlace.func_187023_a();
            EnumFacing front = blockPlace.func_187024_b();
            MinecraftServer server = SpongeImpl.getServer();
            if (blockPos.func_177956_o() < server.func_71207_Z() - 1 || front != EnumFacing.UP && blockPos.func_177956_o() < server.func_71207_Z()) {
                return General.PLACE_BLOCK;
            }
            return General.INVALID;
        });
        this.packetTranslationMap.put(CPacketPlayerTryUseItem.class, packet -> General.USE_ITEM);
        this.packetTranslationMap.put(CPacketHeldItemChange.class, packet -> Inventory.SWITCH_HOTBAR_SCROLL);
        this.packetTranslationMap.put(CPacketAnimation.class, packet -> General.ANIMATION);
        this.packetTranslationMap.put(CPacketEntityAction.class, packet -> {
            CPacketEntityAction playerAction = (CPacketEntityAction)packet;
            CPacketEntityAction.Action action = playerAction.func_180764_b();
            return (IPacketState)PLAYER_ACTION_MAPPINGS.get((Object)action);
        });
        this.packetTranslationMap.put(CPacketInput.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(CPacketCloseWindow.class, packet -> General.CLOSE_WINDOW);
        this.packetTranslationMap.put(CPacketClickWindow.class, packet -> PacketPhase.fromWindowPacket((CPacketClickWindow)packet));
        this.packetTranslationMap.put(CPacketConfirmTransaction.class, packet -> General.UNKNOWN);
        this.packetTranslationMap.put(CPacketCreativeInventoryAction.class, packet -> General.CREATIVE_INVENTORY);
        this.packetTranslationMap.put(CPacketEnchantItem.class, packet -> Inventory.ENCHANT_ITEM);
        this.packetTranslationMap.put(CPacketUpdateSign.class, packet -> General.UPDATE_SIGN);
        this.packetTranslationMap.put(CPacketPlayerAbilities.class, packet -> General.IGNORED);
        this.packetTranslationMap.put(CPacketTabComplete.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(CPacketClientStatus.class, packet -> {
            CPacketClientStatus clientStatus = (CPacketClientStatus)packet;
            CPacketClientStatus.State status = clientStatus.func_149435_c();
            if (status == CPacketClientStatus.State.OPEN_INVENTORY_ACHIEVEMENT) {
                return Inventory.OPEN_INVENTORY;
            }
            if (status == CPacketClientStatus.State.PERFORM_RESPAWN) {
                return General.REQUEST_RESPAWN;
            }
            return General.IGNORED;
        });
        this.packetTranslationMap.put(CPacketCustomPayload.class, packet -> General.HANDLED_EXTERNALLY);
        this.packetTranslationMap.put(CPacketSpectate.class, packet -> General.IGNORED);
        this.packetTranslationMap.put(CPacketResourcePackStatus.class, packet -> General.RESOURCE_PACK);
    }

    private static final class Holder {
        static final PacketPhase INSTANCE = new PacketPhase();

        private Holder() {
        }
    }

    public static final class Inventory {
        public static final BasicInventoryPacketState INVENTORY = new BasicInventoryPacketState();
        public static final BasicInventoryPacketState PRIMARY_INVENTORY_CLICK = new PrimaryInventoryClickState();
        public static final BasicInventoryPacketState SECONDARY_INVENTORY_CLICK = new SecondaryInventoryClickState();
        public static final BasicInventoryPacketState MIDDLE_INVENTORY_CLICK = new MiddleInventoryClickState();
        public static final BasicInventoryPacketState DROP_ITEM_OUTSIDE_WINDOW = new DropItemOutsideWindowState();
        public static final BasicInventoryPacketState DROP_ITEM_WITH_HOTKEY = new DropItemWithHotkeyState();
        public static final BasicInventoryPacketState DROP_ITEMS = new BasicInventoryPacketState();
        public static final BasicInventoryPacketState DROP_INVENTORY = new BasicInventoryPacketState();
        public static final BasicInventoryPacketState SWITCH_HOTBAR_NUMBER_PRESS = new SwitchHotbarNumberPressState();
        public static final BasicInventoryPacketState PRIMARY_INVENTORY_SHIFT_CLICK = new PrimaryInventoryShiftClick();
        public static final BasicInventoryPacketState SECONDARY_INVENTORY_SHIFT_CLICK = new SecondaryInventoryShiftClickState();
        public static final BasicInventoryPacketState DOUBLE_CLICK_INVENTORY = new DoubleClickInventoryState();
        public static final BasicInventoryPacketState PRIMARY_DRAG_INVENTORY_START = new DragInventoryStartState("PRIMARY_DRAG_INVENTORY_START", 64);
        public static final BasicInventoryPacketState SECONDARY_DRAG_INVENTORY_START = new DragInventoryStartState("SECONDARY_DRAG_INVENTORY_START", 128);
        public static final BasicInventoryPacketState PRIMARY_DRAG_INVENTORY_ADDSLOT = new DragInventoryAddSlotState("PRIMARY_DRAG_INVENTORY_ADD_SLOT", 64);
        public static final BasicInventoryPacketState SECONDARY_DRAG_INVENTORY_ADDSLOT = new DragInventoryAddSlotState("SECONDARY_DRAG_INVENTORY_ADD_SLOT", 128);
        public static final BasicInventoryPacketState PRIMARY_DRAG_INVENTORY_STOP = new PrimaryDragInventoryStopState();
        public static final BasicInventoryPacketState SECONDARY_DRAG_INVENTORY_STOP = new SecondaryDragInventoryStopState();
        public static final BasicInventoryPacketState SWITCH_HOTBAR_SCROLL = new SwitchHotbarScrollState();
        public static final BasicInventoryPacketState OPEN_INVENTORY = new BasicInventoryPacketState();
        public static final BasicInventoryPacketState ENCHANT_ITEM = new BasicInventoryPacketState();
        static final ImmutableList<BasicInventoryPacketState> VALUES = ImmutableList.builder().add((Object)INVENTORY).add((Object)PRIMARY_INVENTORY_CLICK).add((Object)SECONDARY_INVENTORY_CLICK).add((Object)MIDDLE_INVENTORY_CLICK).add((Object)DROP_ITEM_OUTSIDE_WINDOW).add((Object)DROP_ITEM_WITH_HOTKEY).add((Object)DROP_ITEMS).add((Object)DROP_INVENTORY).add((Object)SWITCH_HOTBAR_NUMBER_PRESS).add((Object)PRIMARY_INVENTORY_SHIFT_CLICK).add((Object)SECONDARY_INVENTORY_SHIFT_CLICK).add((Object)DOUBLE_CLICK_INVENTORY).add((Object)PRIMARY_DRAG_INVENTORY_START).add((Object)SECONDARY_DRAG_INVENTORY_START).add((Object)PRIMARY_DRAG_INVENTORY_ADDSLOT).add((Object)SECONDARY_DRAG_INVENTORY_ADDSLOT).add((Object)PRIMARY_DRAG_INVENTORY_STOP).add((Object)SECONDARY_DRAG_INVENTORY_STOP).add((Object)SWITCH_HOTBAR_SCROLL).add((Object)OPEN_INVENTORY).add((Object)ENCHANT_ITEM).build();
    }

    public static final class General {
        public static final IPacketState UNKNOWN = new UnknownPacketState();
        public static final IPacketState MOVEMENT = new MovementPacketState();
        public static final IPacketState INTERACTION = new InteractionPacketState();
        public static final IPacketState IGNORED = new IgnoredPacketState();
        public static final IPacketState INTERACT_ENTITY = new InteractEntityPacketState();
        public static final IPacketState ATTACK_ENTITY = new AttackEntityPacketState();
        public static final IPacketState INTERACT_AT_ENTITY = new InteractAtEntityPacketState();
        public static final IPacketState CHAT = new ChatPacketState();
        public static final IPacketState CREATIVE_INVENTORY = new CreativeInventoryPacketState();
        public static final IPacketState NO_CAPTURE_USE_ITEM = new NoCaptureUseItemPacketState();
        public static final IPacketState PLACE_BLOCK = new PlaceBlockPacketState();
        public static final IPacketState OPEN_INVENTORY = new BasicPacketState();
        public static final IPacketState REQUEST_RESPAWN = new BasicPacketState();
        public static final IPacketState USE_ITEM = new UseItemPacketState();
        public static final IPacketState INVALID = new InvalidPacketState();
        public static final IPacketState CLIENT_SETTINGS = new BasicPacketState();
        public static final IPacketState START_RIDING_JUMP = new BasicPacketState();
        public static final IPacketState ANIMATION = new BasicPacketState();
        public static final IPacketState START_SNEAKING = new BasicPacketState();
        public static final IPacketState STOP_SNEAKING = new BasicPacketState();
        public static final IPacketState START_SPRINTING = new BasicPacketState();
        public static final IPacketState STOP_SPRINTING = new BasicPacketState();
        public static final IPacketState STOP_SLEEPING = new StopSleepingPacketState();
        public static final IPacketState CLOSE_WINDOW = new CloseWindowState();
        public static final IPacketState UPDATE_SIGN = new UpdateSignState();
        public static final IPacketState RESOURCE_PACK = new UpdateSignState();
        public static final IPacketState STOP_RIDING_JUMP = new BasicPacketState();
        public static final IPacketState HANDLED_EXTERNALLY = new UnknownPacketState();
        public static final IPacketState START_FALL_FLYING = new BasicPacketState();
        public static final IPacketState SWAP_HAND_ITEMS = new BasicPacketState();
    }
}

