/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.plugin;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.TrackingPhase;
import org.spongepowered.common.event.tracking.phase.plugin.BlockWorkerPhaseState;
import org.spongepowered.common.event.tracking.phase.plugin.CustomExplosionState;
import org.spongepowered.common.event.tracking.phase.plugin.ListenerPhaseState;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhaseState;
import org.spongepowered.common.event.tracking.phase.plugin.PostServerTickListenerState;
import org.spongepowered.common.event.tracking.phase.plugin.PostWorldTickListenerState;
import org.spongepowered.common.event.tracking.phase.plugin.PreServerTickListenerState;
import org.spongepowered.common.event.tracking.phase.plugin.PreWorldTickListenerState;
import org.spongepowered.common.event.tracking.phase.plugin.ScheduledTaskPhaseState;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;

public final class PluginPhase
extends TrackingPhase {
    public static PluginPhase getInstance() {
        return Holder.INSTANCE;
    }

    private PluginPhase() {
    }

    @Override
    public void unwind(IPhaseState state, PhaseContext phaseContext) {
        ((PluginPhaseState)state).processPostTick(phaseContext);
    }

    @Override
    public void associateAdditionalCauses(IPhaseState state, PhaseContext context, Cause.Builder builder) {
        if (state instanceof ListenerPhaseState) {
            ((ListenerPhaseState)state).associateAdditionalBlockChangeCauses(context, builder);
        }
    }

    @Override
    public void addNotifierToBlockEvent(IPhaseState phaseState, PhaseContext context, IMixinWorldServer mixinWorld, BlockPos pos, IMixinBlockEventData blockEvent) {
        if (phaseState instanceof ListenerPhaseState) {
            ((ListenerPhaseState)phaseState).associateBlockEventNotifier(context, mixinWorld, pos, blockEvent);
        }
    }

    @Override
    public void associateNeighborStateNotifier(IPhaseState state, PhaseContext context, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
        if (state instanceof ListenerPhaseState) {
            ((ListenerPhaseState)state).associateNeighborBlockNotifier(context, sourcePos, block, notifyPos, minecraftWorld, notifier);
        }
    }

    @Override
    public void capturePlayerUsingStackToBreakBlock(@Nullable ItemStack itemStack, EntityPlayerMP playerMP, IPhaseState state, PhaseContext context, CauseTracker causeTracker) {
        if (state instanceof ListenerPhaseState) {
            ((ListenerPhaseState)state).capturePlayerUsingStackToBreakBlocks(context, playerMP, itemStack);
        }
    }

    @Override
    public boolean handlesOwnPhaseCompletion(IPhaseState state) {
        return state == State.BLOCK_WORKER;
    }

    private static final class Holder {
        static final PluginPhase INSTANCE = new PluginPhase();

        private Holder() {
        }
    }

    public static final class Listener {
        public static final IPhaseState PRE_WORLD_TICK_LISTENER = new PreWorldTickListenerState();
        public static final IPhaseState POST_WORLD_TICK_LISTENER = new PostWorldTickListenerState();
        public static final IPhaseState PRE_SERVER_TICK_LISTENER = new PreServerTickListenerState();
        public static final IPhaseState POST_SERVER_TICK_LISTENER = new PostServerTickListenerState();

        private Listener() {
        }
    }

    public static final class State {
        public static final IPhaseState BLOCK_WORKER = new BlockWorkerPhaseState();
        public static final IPhaseState CUSTOM_SPAWN = new PluginPhaseState();
        public static final IPhaseState CUSTOM_EXPLOSION = new CustomExplosionState();
        public static final IPhaseState SCHEDULED_TASK = new ScheduledTaskPhaseState();

        private State() {
        }
    }
}

