/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import com.flowpowered.math.vector.Vector3d;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.CombatEntry;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.Ageable;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.spawn.BlockSpawnCause;
import org.spongepowered.api.event.cause.entity.spawn.EntitySpawnCause;
import org.spongepowered.api.event.cause.entity.teleport.EntityTeleportCause;
import org.spongepowered.api.event.cause.entity.teleport.TeleportTypes;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.world.World;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

class EntityTickPhaseState
extends TickPhaseState {
    EntityTickPhaseState() {
    }

    @Override
    public void processPostTick(PhaseContext phaseContext) {
        Entity tickingEntity = phaseContext.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", phaseContext));
        Optional<User> creator = phaseContext.getOwner();
        Optional<User> notifier = phaseContext.getNotifier();
        User entityCreator = notifier.orElseGet(() -> creator.orElse(null));
        phaseContext.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
            SpawnEntityEvent event;
            Cause.Builder builder;
            ArrayList<Entity> experience = new ArrayList<Entity>(entities.size());
            ArrayList<Entity> nonExp = new ArrayList<Entity>(entities.size());
            ArrayList<Entity> breeding = new ArrayList<Entity>(entities.size());
            ArrayList<Entity> projectile = new ArrayList<Entity>(entities.size());
            for (Entity entity : entities) {
                if (entity instanceof EntityXPOrb) {
                    experience.add(entity);
                    continue;
                }
                if (tickingEntity instanceof Ageable && tickingEntity.getClass() == entity.getClass()) {
                    breeding.add(entity);
                    continue;
                }
                if (entity instanceof Projectile) {
                    projectile.add(entity);
                    continue;
                }
                nonExp.add(entity);
            }
            if (!experience.isEmpty()) {
                CombatEntry entry;
                builder = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(tickingEntity)).type(InternalSpawnTypes.EXPERIENCE)).build());
                notifier.ifPresent(builder::notifier);
                creator.ifPresent(builder::owner);
                if (EntityUtil.isEntityDead(tickingEntity) && tickingEntity instanceof EntityLivingBase && (entry = ((EntityLivingBase)tickingEntity).func_110142_aN().func_94544_f()) != null && entry.field_94569_a != null) {
                    builder.named(NamedCause.of("LastDamageSource", entry.field_94569_a));
                }
                if (!SpongeImpl.postEvent(event = SpongeEventFactory.createSpawnEntityEvent(builder.build(), experience))) {
                    for (Entity entity : event.getEntities()) {
                        if (entityCreator != null) {
                            EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            }
            if (!breeding.isEmpty()) {
                EntityPlayer playerInLove;
                builder = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(tickingEntity)).type(InternalSpawnTypes.BREEDING)).build());
                if (tickingEntity instanceof EntityAnimal && (playerInLove = ((EntityAnimal)tickingEntity).func_146083_cb()) != null) {
                    builder.named(NamedCause.of("Player", playerInLove));
                }
                if (!SpongeImpl.postEvent(event = SpongeEventFactory.createSpawnEntityEvent(builder.build(), breeding))) {
                    for (Entity entity : event.getEntities()) {
                        if (entityCreator != null) {
                            EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            }
            if (!projectile.isEmpty()) {
                builder = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(tickingEntity)).type(InternalSpawnTypes.PROJECTILE)).build());
                notifier.ifPresent(builder::notifier);
                creator.ifPresent(builder::owner);
                event = SpongeEventFactory.createSpawnEntityEvent(builder.build(), projectile);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    for (Entity entity : event.getEntities()) {
                        if (entityCreator != null) {
                            entity.setCreator(entityCreator.getUniqueId());
                        }
                        EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                    }
                }
            }
            builder = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(tickingEntity)).type(InternalSpawnTypes.PASSIVE)).build());
            notifier.ifPresent(builder::notifier);
            creator.ifPresent(builder::owner);
            event = SpongeEventFactory.createSpawnEntityEvent(builder.build(), nonExp);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                for (Entity entity : event.getEntities()) {
                    if (entityCreator != null) {
                        entity.setCreator(entityCreator.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        });
        phaseContext.getCapturedItemsSupplier().ifPresentAndNotEmpty(entities -> {
            ArrayList<Entity> capturedEntities = new ArrayList<Entity>();
            for (EntityItem entity : entities) {
                capturedEntities.add(EntityUtil.fromNative((net.minecraft.entity.Entity)entity));
            }
            Cause.Builder builder = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(tickingEntity)).type(InternalSpawnTypes.DROPPED_ITEM)).build());
            notifier.ifPresent(user -> builder.named(NamedCause.notifier(user)));
            creator.ifPresent(user -> builder.named(NamedCause.owner(user)));
            DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(builder.build(), capturedEntities);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                for (Entity entity : event.getEntities()) {
                    if (entityCreator != null) {
                        EntityUtil.toMixin(entity).setCreator(entityCreator.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        });
        phaseContext.getCapturedBlockSupplier().ifPresentAndNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, phaseContext));
        phaseContext.getBlockItemDropSupplier().ifPresentAndNotEmpty(map -> {
            List<BlockSnapshot> capturedBlocks = phaseContext.getCapturedBlocks();
            for (BlockSnapshot snapshot : capturedBlocks) {
                BlockPos blockPos = ((IMixinLocation)((Object)snapshot.getLocation().get())).getBlockPos();
                List entityItems = map.get((Object)blockPos);
                if (entityItems.isEmpty()) continue;
                Cause.Builder builder = Cause.source(((BlockSpawnCause.Builder)((BlockSpawnCause.Builder)BlockSpawnCause.builder().block(snapshot)).type(InternalSpawnTypes.DROPPED_ITEM)).build());
                notifier.ifPresent(builder::notifier);
                creator.ifPresent(builder::owner);
                builder.build();
                List items = entityItems.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
                DropItemEvent.Destruct event = SpongeEventFactory.createDropItemEventDestruct(builder.build(), items);
                SpongeImpl.postEvent(event);
                if (event.isCancelled()) continue;
                for (Entity entity : event.getEntities()) {
                    creator.ifPresent(user -> entity.setCreator(user.getUniqueId()));
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
                }
            }
        });
        phaseContext.getCapturedItemStackSupplier().ifPresentAndNotEmpty(drops -> {
            List items = drops.stream().map(drop -> drop.create(EntityUtil.getMinecraftWorld(tickingEntity))).collect(Collectors.toList());
            Cause.Builder builder = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(tickingEntity)).type(InternalSpawnTypes.DROPPED_ITEM)).build());
            notifier.ifPresent(user -> builder.named(NamedCause.notifier(user)));
            creator.ifPresent(user -> builder.named(NamedCause.owner(user)));
            Cause cause = builder.build();
            List entities = items;
            if (!entities.isEmpty()) {
                DropItemEvent.Custom event = SpongeEventFactory.createDropItemEventCustom(cause, entities);
                SpongeImpl.postEvent(event);
                if (!event.isCancelled()) {
                    for (Entity droppedItem : event.getEntities()) {
                        EntityUtil.getMixinWorld(droppedItem).forceSpawnEntity(droppedItem);
                    }
                }
            }
        });
        this.fireMovementEvents(EntityUtil.toNative(tickingEntity), Cause.source(tickingEntity).build());
    }

    private void fireMovementEvents(net.minecraft.entity.Entity entity, Cause cause) {
        if (entity.field_70128_L || entity instanceof IProjectile || entity instanceof EntityItem) {
            return;
        }
        Entity spongeEntity = (Entity)entity;
        if (entity.field_70142_S != entity.field_70165_t || entity.field_70137_T != entity.field_70163_u || entity.field_70136_U != entity.field_70161_v || entity.field_70125_A != entity.field_70127_C || entity.field_70177_z != entity.field_70126_B) {
            Transform<World> newTransform;
            double currentPosX = entity.field_70165_t;
            double currentPosY = entity.field_70163_u;
            double currentPosZ = entity.field_70161_v;
            Vector3d oldPositionVector = new Vector3d(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U);
            Vector3d currentPositionVector = new Vector3d(currentPosX, currentPosY, currentPosZ);
            Vector3d oldRotationVector = new Vector3d(entity.field_70127_C, entity.field_70126_B, 0.0f);
            Vector3d currentRotationVector = new Vector3d(entity.field_70125_A, entity.field_70177_z, 0.0f);
            Transform<World> oldTransform = new Transform<World>(spongeEntity.getWorld(), oldPositionVector, oldRotationVector, spongeEntity.getScale());
            MoveEntityEvent event = SpongeEventFactory.createMoveEntityEvent(cause, oldTransform, newTransform = new Transform<World>(spongeEntity.getWorld(), currentPositionVector, currentRotationVector, spongeEntity.getScale()), spongeEntity);
            if (SpongeImpl.postEvent(event)) {
                entity.field_70165_t = entity.field_70142_S;
                entity.field_70163_u = entity.field_70137_T;
                entity.field_70161_v = entity.field_70136_U;
                entity.field_70125_A = entity.field_70127_C;
                entity.field_70177_z = entity.field_70126_B;
            } else {
                Vector3d newPosition = event.getToTransform().getPosition();
                if (!newPosition.equals(currentPositionVector)) {
                    entity.field_70165_t = newPosition.getX();
                    entity.field_70163_u = newPosition.getY();
                    entity.field_70161_v = newPosition.getZ();
                }
                if (!event.getToTransform().getRotation().equals(currentRotationVector)) {
                    entity.field_70125_A = (float)currentRotationVector.getX();
                    entity.field_70177_z = (float)currentRotationVector.getY();
                }
            }
        }
    }

    @Override
    public Cause generateTeleportCause(PhaseContext context) {
        Entity entity = context.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking an entity!", context));
        return Cause.source(((EntityTeleportCause.Builder)((EntityTeleportCause.Builder)EntityTeleportCause.builder().entity(entity)).type(TeleportTypes.ENTITY_TELEPORT)).build()).build();
    }

    @Override
    public void handleBlockChangeWithUser(@Nullable BlockChange blockChange, Transaction<BlockSnapshot> transaction, PhaseContext context) {
        if (blockChange == BlockChange.BREAK) {
            Entity tickingEntity = context.getSource(Entity.class).get();
            BlockPos blockPos = VecHelper.toBlockPos(transaction.getOriginal().getPosition());
            for (EntityHanging entityHanging : EntityUtil.findHangingEntities(EntityUtil.getMinecraftWorld(tickingEntity), blockPos)) {
                if (!(entityHanging instanceof EntityItemFrame)) continue;
                EntityItemFrame frame = (EntityItemFrame)entityHanging;
                if (tickingEntity != null && !frame.field_70128_L) {
                    frame.func_146065_b(EntityUtil.toNative(tickingEntity), true);
                }
                frame.func_70106_y();
            }
        }
    }

    @Override
    public void associateAdditionalBlockChangeCauses(PhaseContext context, Cause.Builder builder) {
        Entity tickingEntity = context.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", context));
        builder.named(NamedCause.owner(tickingEntity));
        context.getNotifier().ifPresent(builder::notifier);
    }

    @Override
    public void processPostSpawns(PhaseContext phaseContext, ArrayList<Entity> entities) {
        super.processPostSpawns(phaseContext, entities);
    }

    @Override
    public void appendExplosionContext(PhaseContext explosionContext, PhaseContext context) {
        context.getOwner().ifPresent(explosionContext::owner);
        context.getNotifier().ifPresent(explosionContext::notifier);
        Entity tickingEntity = context.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing over a ticking entity!", context));
        explosionContext.add(NamedCause.source(tickingEntity));
    }

    @Override
    public boolean spawnEntityOrCapture(PhaseContext context, Entity entity, int chunkX, int chunkZ) {
        Entity tickingEntity = context.getSource(Entity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on an Entity!", context));
        Optional<User> creator = context.getOwner();
        Optional<User> notifier = context.getNotifier();
        User entityCreator = notifier.orElseGet(() -> creator.orElse(null));
        if (entity instanceof EntityXPOrb) {
            CombatEntry entry;
            Cause.Builder builder = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(tickingEntity)).type(InternalSpawnTypes.EXPERIENCE)).build());
            notifier.ifPresent(builder::notifier);
            creator.ifPresent(builder::owner);
            if (EntityUtil.isEntityDead(tickingEntity) && tickingEntity instanceof EntityLivingBase && (entry = ((EntityLivingBase)tickingEntity).func_110142_aN().func_94544_f()) != null && entry.field_94569_a != null) {
                builder.named(NamedCause.of("LastDamageSource", entry.field_94569_a));
            }
            ArrayList<Entity> experience = new ArrayList<Entity>(1);
            experience.add(entity);
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(builder.build(), experience);
            if (!SpongeImpl.postEvent(event)) {
                for (Entity anEntity : event.getEntities()) {
                    if (entityCreator != null) {
                        EntityUtil.toMixin(anEntity).setCreator(entityCreator.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
                }
                return true;
            }
            return false;
        }
        if (tickingEntity instanceof Ageable && tickingEntity.getClass() == entity.getClass()) {
            EntityPlayer playerInLove;
            Cause.Builder builder = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(tickingEntity)).type(InternalSpawnTypes.BREEDING)).build());
            if (tickingEntity instanceof EntityAnimal && (playerInLove = ((EntityAnimal)tickingEntity).func_146083_cb()) != null) {
                builder.named(NamedCause.of("Player", playerInLove));
            }
            ArrayList<Entity> breeding = new ArrayList<Entity>(1);
            breeding.add(entity);
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(builder.build(), breeding);
            if (!SpongeImpl.postEvent(event)) {
                for (Entity anEntity : event.getEntities()) {
                    if (entityCreator != null) {
                        EntityUtil.toMixin(anEntity).setCreator(entityCreator.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
                }
                return true;
            }
            return false;
        }
        if (entity instanceof Projectile) {
            Cause.Builder builder = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(tickingEntity)).type(InternalSpawnTypes.PROJECTILE)).build());
            ArrayList<Entity> projectile = new ArrayList<Entity>(1);
            projectile.add(entity);
            notifier.ifPresent(builder::notifier);
            creator.ifPresent(builder::owner);
            SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(builder.build(), projectile);
            SpongeImpl.postEvent(event);
            if (!event.isCancelled()) {
                for (Entity anEntity : event.getEntities()) {
                    if (entityCreator != null) {
                        anEntity.setCreator(entityCreator.getUniqueId());
                    }
                    EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
                }
                return true;
            }
            return false;
        }
        ArrayList<Entity> nonExp = new ArrayList<Entity>(1);
        nonExp.add(entity);
        Cause.Builder builder = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(tickingEntity)).type(InternalSpawnTypes.PASSIVE)).build());
        notifier.ifPresent(builder::notifier);
        creator.ifPresent(builder::owner);
        SpawnEntityEvent event = SpongeEventFactory.createSpawnEntityEvent(builder.build(), nonExp);
        SpongeImpl.postEvent(event);
        if (!event.isCancelled()) {
            for (Entity anEntity : event.getEntities()) {
                if (entityCreator != null) {
                    anEntity.setCreator(entityCreator.getUniqueId());
                }
                EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "EntityTickPhase";
    }
}

