/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.cause.entity.spawn.EntitySpawnCause;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

class PlayerTickPhaseState
extends TickPhaseState {
    PlayerTickPhaseState() {
    }

    @Override
    public void associateBlockEventNotifier(PhaseContext context, BlockPos pos, IMixinBlockEventData blockEvent) {
        blockEvent.setSourceUser(context.getSource(Player.class).get());
    }

    @Override
    public void processPostTick(PhaseContext phaseContext) {
        Player player = phaseContext.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a Player!", phaseContext));
        phaseContext.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
            Cause.Builder builder = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(player)).type(InternalSpawnTypes.PASSIVE)).build());
            SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(builder.build(), entities);
            SpongeImpl.postEvent(spawnEntityEvent);
            for (org.spongepowered.api.entity.Entity entity : spawnEntityEvent.getEntities()) {
                EntityUtil.toMixin(entity).setCreator(player.getUniqueId());
                EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
            }
        });
        phaseContext.getCapturedItemsSupplier().ifPresentAndNotEmpty(entities -> {
            Cause.Builder builder = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(player)).type(InternalSpawnTypes.DROPPED_ITEM)).build());
            ArrayList<org.spongepowered.api.entity.Entity> capturedEntities = new ArrayList<org.spongepowered.api.entity.Entity>();
            for (EntityItem entity : entities) {
                capturedEntities.add(EntityUtil.fromNative((Entity)entity));
            }
            SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(builder.build(), capturedEntities);
            SpongeImpl.postEvent(spawnEntityEvent);
            for (org.spongepowered.api.entity.Entity entity : spawnEntityEvent.getEntities()) {
                EntityUtil.toMixin(entity).setCreator(player.getUniqueId());
                EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
            }
        });
        phaseContext.getCapturedBlockSupplier().ifPresentAndNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, phaseContext));
    }

    @Override
    public void associateAdditionalBlockChangeCauses(PhaseContext context, Cause.Builder builder) {
        builder.named("Owner", context.getSource(Player.class).get());
    }

    @Override
    public void appendExplosionContext(PhaseContext explosionContext, PhaseContext context) {
        Player player = context.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing over a ticking TileEntity!", context));
        explosionContext.owner(player);
        explosionContext.notifier(player);
        explosionContext.add(NamedCause.source(player));
    }

    @Override
    public boolean spawnEntityOrCapture(PhaseContext context, org.spongepowered.api.entity.Entity entity, int chunkX, int chunkZ) {
        Player player = context.getSource(Player.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a Player!", context));
        Cause.Builder builder = Cause.source(((EntitySpawnCause.Builder)((EntitySpawnCause.Builder)EntitySpawnCause.builder().entity(player)).type(InternalSpawnTypes.PASSIVE)).build());
        ArrayList<org.spongepowered.api.entity.Entity> entities = new ArrayList<org.spongepowered.api.entity.Entity>(1);
        entities.add(entity);
        SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(builder.build(), entities);
        SpongeImpl.postEvent(spawnEntityEvent);
        if (!spawnEntityEvent.isCancelled()) {
            for (org.spongepowered.api.entity.Entity anEntity : spawnEntityEvent.getEntities()) {
                EntityUtil.toMixin(anEntity).setCreator(player.getUniqueId());
                EntityUtil.getMixinWorld(entity).forceSpawnEntity(anEntity);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "PlayerTickPhase";
    }
}

