/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.ArrayList;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.entity.spawn.SpawnCause;
import org.spongepowered.api.event.entity.SpawnEntityEvent;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.tick.TickPhaseState;
import org.spongepowered.common.registry.type.event.InternalSpawnTypes;

class WeatherTickPhaseState
extends TickPhaseState {
    WeatherTickPhaseState() {
    }

    @Override
    public void processPostTick(PhaseContext phaseContext) {
        phaseContext.getCapturedEntitySupplier().ifPresentAndNotEmpty(entities -> {
            Cause.Builder builder = Cause.source(((SpawnCause.Builder)SpawnCause.builder().type(InternalSpawnTypes.WEATHER)).build());
            SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(builder.build(), entities);
            SpongeImpl.postEvent(spawnEntityEvent);
            for (Entity entity : spawnEntityEvent.getEntities()) {
                EntityUtil.getMixinWorld(entity).forceSpawnEntity(entity);
            }
        });
        phaseContext.getCapturedBlockSupplier().ifPresentAndNotEmpty(blockSnapshots -> TrackingUtil.processBlockCaptures(blockSnapshots, this, phaseContext));
    }

    @Override
    public void associateAdditionalBlockChangeCauses(PhaseContext context, Cause.Builder builder) {
    }

    @Override
    public boolean spawnEntityOrCapture(PhaseContext context, Entity entity, int chunkX, int chunkZ) {
        Cause.Builder builder = Cause.source(((SpawnCause.Builder)SpawnCause.builder().type(InternalSpawnTypes.WEATHER)).build());
        ArrayList<Entity> capturedEntities = new ArrayList<Entity>();
        capturedEntities.add(entity);
        SpawnEntityEvent spawnEntityEvent = SpongeEventFactory.createSpawnEntityEvent(builder.build(), capturedEntities);
        SpongeImpl.postEvent(spawnEntityEvent);
        if (!spawnEntityEvent.isCancelled()) {
            for (Entity anEntity : spawnEntityEvent.getEntities()) {
                EntityUtil.getMixinWorld(anEntity).forceSpawnEntity(anEntity);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "WeatherTickPhase";
    }
}

