/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inject;

import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.DependencyAndSource;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProvisionListener;
import java.util.List;
import javax.annotation.Nullable;

public final class InjectionPointProvider
extends AbstractMatcher<Binding<?>>
implements Module,
ProvisionListener,
Provider<InjectionPoint> {
    @Nullable
    private InjectionPoint injectionPoint;

    @Override
    public InjectionPoint get() {
        return this.injectionPoint;
    }

    @Override
    public boolean matches(Binding<?> binding) {
        return binding instanceof ProviderInstanceBinding && ((ProviderInstanceBinding)binding).getUserSuppliedProvider() == this;
    }

    @Override
    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
        try {
            this.injectionPoint = InjectionPointProvider.findInjectionPoint(provision.getDependencyChain());
            provision.provision();
        }
        finally {
            this.injectionPoint = null;
        }
    }

    private static InjectionPoint findInjectionPoint(List<DependencyAndSource> dependencyChain) {
        if (dependencyChain.size() < 3) {
            throw new AssertionError((Object)"Provider is not included in the dependency chain");
        }
        for (int i = dependencyChain.size() - 2; i >= 0; --i) {
            Dependency<?> dependency = dependencyChain.get(i).getDependency();
            if (dependency == null) {
                return null;
            }
            InjectionPoint injectionPoint = dependency.getInjectionPoint();
            if (injectionPoint == null) continue;
            return injectionPoint;
        }
        return null;
    }

    @Override
    public void configure(Binder binder) {
        binder.bind(InjectionPoint.class).toProvider(this);
        binder.bindListener(this, this);
    }
}

