/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.common.item.inventory.custom.CustomInventory;

public class SpongeInventoryBuilder
implements Inventory.Builder {
    private static final Map<Class<?>, InventoryArchetype> inventoryTypes = new HashMap();
    private InventoryArchetype archetype;
    private Map<String, InventoryProperty<?, ?>> properties = new HashMap();
    private Map<Class<? extends InteractInventoryEvent>, List<Consumer<? extends InteractInventoryEvent>>> listeners = new HashMap<Class<? extends InteractInventoryEvent>, List<Consumer<? extends InteractInventoryEvent>>>();
    private Carrier carrier;

    public static void registerInventory(Class<? extends IInventory> inventory, InventoryArchetype archetype) {
        inventoryTypes.put(inventory, archetype);
    }

    public static void registerContainer(Class<? extends Container> container, InventoryArchetype archetype) {
        inventoryTypes.put(container, archetype);
    }

    public SpongeInventoryBuilder() {
        this.archetype = InventoryArchetypes.CHEST;
    }

    @Override
    public Inventory.Builder of(InventoryArchetype archetype) {
        this.archetype = archetype;
        return this;
    }

    @Override
    public Inventory.Builder property(String name, InventoryProperty<?, ?> property) {
        this.properties.put(name, property);
        return this;
    }

    @Override
    public Inventory.Builder withCarrier(Carrier carrier) {
        this.carrier = carrier;
        return this;
    }

    @Override
    public Inventory build(Object plugin) {
        return (Inventory)((Object)new CustomInventory(this.archetype, this.properties, this.carrier, this.listeners, plugin));
    }

    @Override
    public Inventory.Builder from(Inventory value) {
        if (value instanceof CustomInventory) {
            this.archetype = ((CustomInventory)((Object)value)).getArchetype();
            this.properties.putAll(((CustomInventory)((Object)value)).getProperties());
            return this;
        }
        InventoryArchetype archetype = inventoryTypes.get(value.getClass());
        if (archetype == null) {
            throw new UnsupportedOperationException("Currently not supported for all inventories");
        }
        this.archetype = archetype;
        this.properties = new HashMap();
        return this;
    }

    @Override
    public Inventory.Builder forCarrier(Carrier carrier) {
        return this.forCarrier(carrier.getClass());
    }

    @Override
    public Inventory.Builder forCarrier(Class<? extends Carrier> carrier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Inventory.Builder reset() {
        this.archetype = InventoryArchetypes.CHEST;
        this.properties = new HashMap();
        return this;
    }

    @Override
    public <E extends InteractInventoryEvent> Inventory.Builder listener(Class<E> type, Consumer<E> listener) {
        List<Consumer<? extends InteractInventoryEvent>> list = this.listeners.get(type);
        if (list == null) {
            list = new ArrayList<Consumer<? extends InteractInventoryEvent>>();
            this.listeners.put(type, list);
        }
        list.add(listener);
        return this;
    }
}

