/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.lens.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.common.item.inventory.adapter.InvalidAdapterException;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.InvalidLensDefinitionException;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.MutableLensCollection;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.ObservableLens;
import org.spongepowered.common.item.inventory.lens.impl.collections.MutableLensCollectionImpl;
import org.spongepowered.common.item.inventory.lens.impl.struct.LensHandle;
import org.spongepowered.common.item.inventory.observer.InventoryEventArgs;
import org.spongepowered.common.util.observer.Observer;

public abstract class AbstractLens<TInventory, TStack>
extends ObservableLens<TInventory, TStack>
implements Observer<InventoryEventArgs> {
    protected final InventoryAdapter<TInventory, TStack> adapter;
    protected final Class<? extends Inventory> adapterType;
    protected final int base;
    protected final IntSet availableSlots = new IntOpenHashSet();
    protected Lens<TInventory, TStack> parent;
    protected MutableLensCollection<TInventory, TStack> children;
    protected List<LensHandle<TInventory, TStack>> spanningChildren;
    protected int size;
    private int maxOrdinal = 0;

    public AbstractLens(int base, int size, InventoryAdapter<TInventory, TStack> adapter, SlotProvider<TInventory, TStack> slots) {
        this(base, size, (InventoryAdapter)Preconditions.checkNotNull(adapter, (Object)"adapter"), adapter.getClass(), slots);
    }

    public AbstractLens(int base, int size, Class<? extends Inventory> adapterType, SlotProvider<TInventory, TStack> slots) {
        this(base, size, null, (Class)Preconditions.checkNotNull(adapterType, (Object)"adapterType"), slots);
    }

    public AbstractLens(int base, int size, InventoryAdapter<TInventory, TStack> adapter, Class<? extends Inventory> adapterType, SlotProvider<TInventory, TStack> slots) {
        Preconditions.checkArgument((base >= 0 ? 1 : 0) != 0, (String)"Invalid offset: %s", (Object[])new Object[]{base});
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (String)"Invalid size: %s", (Object[])new Object[]{size});
        this.base = base;
        this.size = size;
        this.adapterType = adapterType;
        this.adapter = adapter;
        this.prepare();
        if (!this.isDelayedInit()) {
            this.init(adapter, slots);
        }
    }

    protected void prepare() {
        this.children = new MutableLensCollectionImpl(0, false);
        this.spanningChildren = new ArrayList<LensHandle<TInventory, TStack>>();
    }

    protected void init(InventoryAdapter<TInventory, TStack> adapter, SlotProvider<TInventory, TStack> slots) {
        try {
            if (slots != null) {
                this.init(slots);
            } else if (adapter instanceof SlotProvider) {
                this.init((SlotProvider)((Object)adapter));
            } else {
                this.init(index -> {
                    throw new NoSuchElementException("Attempted to fetch slot at index " + index + " but no provider was available instancing " + this);
                });
            }
        }
        catch (NoSuchElementException ex) {
            throw new InvalidLensDefinitionException("Invalid lens definition, the lens referenced slots which do not exist.", ex);
        }
    }

    protected boolean isDelayedInit() {
        return false;
    }

    protected abstract void init(SlotProvider<TInventory, TStack> var1);

    protected void addChild(Lens<TInventory, TStack> lens, InventoryProperty<?, ?> ... properties) {
        Preconditions.checkNotNull(lens, (Object)"Attempted to register a null lens");
        this.children.add(lens, properties);
        this.availableSlots.addAll(lens.getSlots());
        if (lens instanceof ObservableLens) {
            ((ObservableLens)lens).addObserver(this);
        }
        this.raise(new InventoryEventArgs(InventoryEventArgs.Type.LENS_ADDED, this));
    }

    protected void addSpanningChild(Lens<TInventory, TStack> lens, InventoryProperty<?, ?> ... properties) {
        this.addChild(lens, properties);
        LensHandle<TInventory, TStack> child = new LensHandle<TInventory, TStack>(lens, properties);
        this.spanningChildren.add(child);
        child.ordinal = this.maxOrdinal;
        this.maxOrdinal += lens.getSlots().size();
        if (lens instanceof AbstractLens) {
            ((AbstractLens)lens).setParent(this);
        }
    }

    protected void setParent(Lens<TInventory, TStack> parent) {
        this.parent = parent;
    }

    @Override
    public Translation getName(Fabric<TInventory> inv) {
        return inv.getDisplayName();
    }

    @Override
    public Lens<TInventory, TStack> getParent() {
        return this.parent;
    }

    @Override
    public IntSet getSlots() {
        return IntSets.unmodifiable(this.availableSlots);
    }

    @Override
    public boolean hasSlot(int index) {
        return this.availableSlots.contains(index);
    }

    @Override
    public Class<? extends Inventory> getAdapterType() {
        return this.adapterType;
    }

    @Override
    public InventoryAdapter<TInventory, TStack> getAdapter(Fabric<TInventory> inv, Inventory parent) {
        if (this.adapter != null) {
            return this.adapter;
        }
        if (inv instanceof InventoryAdapter) {
            return (InventoryAdapter)((Object)inv);
        }
        return this.createAdapter(inv, parent);
    }

    protected InventoryAdapter<TInventory, TStack> createAdapter(Fabric<TInventory> inv, Inventory parent) {
        try {
            Constructor<InventoryAdapter<TInventory, TStack>> ctor = this.getAdapterCtor();
            return ctor.newInstance(inv, this, parent);
        }
        catch (Exception ex) {
            throw new InvalidAdapterException("Adapter class for " + this.getClass().getSimpleName() + " does not have a constructor which accepts this lens", ex);
        }
    }

    protected abstract Constructor<InventoryAdapter<TInventory, TStack>> getAdapterCtor() throws NoSuchMethodException;

    @Override
    public TStack getStack(Fabric<TInventory> inv, int ordinal) {
        LensHandle<TInventory, TStack> lens = this.getLensForOrdinal(ordinal);
        if (lens == null) {
            return null;
        }
        return lens.lens.getStack(inv, ordinal - lens.ordinal);
    }

    @Override
    public boolean setStack(Fabric<TInventory> inv, int ordinal, TStack stack) {
        LensHandle<TInventory, TStack> lens = this.getLensForOrdinal(ordinal);
        return lens != null && lens.lens.setStack(inv, ordinal - lens.ordinal, stack);
    }

    protected LensHandle<TInventory, TStack> getLensForOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal > this.maxOrdinal) {
            return null;
        }
        for (LensHandle<TInventory, TStack> child : this.spanningChildren) {
            if (child.ordinal > ordinal || ordinal - child.ordinal >= child.lens.slotCount()) continue;
            return child;
        }
        return null;
    }

    @Override
    public List<Lens<TInventory, TStack>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public List<Lens<TInventory, TStack>> getSpanningChildren() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (LensHandle<TInventory, TStack> child : this.spanningChildren) {
            listBuilder.add(child.lens);
        }
        return listBuilder.build();
    }

    @Override
    public int slotCount() {
        return this.size;
    }

    @Override
    public Lens<TInventory, TStack> getLens(int index) {
        return this.children.getLens(index);
    }

    @Override
    public Collection<InventoryProperty<?, ?>> getProperties(int index) {
        return this.children.getProperties(index);
    }

    @Override
    public Collection<InventoryProperty<?, ?>> getProperties(Lens<TInventory, TStack> child) {
        int index = this.children.indexOf(child);
        if (index < 0) {
            throw new NoSuchElementException("Specified child lens is not a direct descendant this lens");
        }
        return this.children.getProperties(index);
    }

    @Override
    public boolean has(Lens<TInventory, TStack> lens) {
        return this.children.contains(lens);
    }

    @Override
    public boolean isSubsetOf(Collection<Lens<TInventory, TStack>> c) {
        return this.children.isSubsetOf(c);
    }

    @Override
    public Iterator<Lens<TInventory, TStack>> iterator() {
        return this.children.iterator();
    }

    @Override
    public void notify(Object source, InventoryEventArgs e) {
        if (e.type == InventoryEventArgs.Type.LENS_INVALIDATED || e.type == InventoryEventArgs.Type.SLOT_CONTENT_CHANGED) {
            this.raise(e);
        }
        if (e.type == InventoryEventArgs.Type.LENS_ADDED && source instanceof Lens && this.children.contains(source)) {
            this.availableSlots.addAll(((Lens)source).getSlots());
        }
    }

    @Override
    public void invalidate(Fabric<TInventory> inv) {
        this.raise(new InventoryEventArgs(InventoryEventArgs.Type.LENS_INVALIDATED, this));
    }

    @Override
    public int getRealIndex(Fabric<TInventory> inv, int ordinal) {
        LensHandle<TInventory, TStack> child = this.getLensForOrdinal(ordinal);
        return child.lens.getRealIndex(inv, ordinal - child.ordinal);
    }

    protected boolean checkOrdinal(int ordinal) {
        return ordinal >= 0 && ordinal < this.size;
    }
}

