/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.util;

import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerBeacon;
import net.minecraft.inventory.ContainerBrewingStand;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.ContainerDispenser;
import net.minecraft.inventory.ContainerEnchantment;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.ContainerHopper;
import net.minecraft.inventory.ContainerHorseInventory;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerRepair;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.inventory.Slot;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Container;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.slot.InputSlot;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.ItemDropData;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.Adapter;
import org.spongepowered.common.item.inventory.adapter.impl.MinecraftInventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.slots.CraftingOutputAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.slots.EquipmentSlotAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.inventory.custom.CustomContainer;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.Lens;
import org.spongepowered.common.item.inventory.lens.LensProvider;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.comp.CraftingInventoryLens;
import org.spongepowered.common.item.inventory.lens.comp.GridInventoryLens;
import org.spongepowered.common.item.inventory.lens.comp.Inventory2DLens;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftFabric;
import org.spongepowered.common.item.inventory.lens.impl.MinecraftLens;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.impl.comp.CraftingInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.GridInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.HotbarLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.Inventory2DLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.comp.OrderedInventoryLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.BrewingStandInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.FurnaceInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.PlayerInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.container.ContainerLens;
import org.spongepowered.common.item.inventory.lens.impl.slots.CraftingOutputSlotLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.slots.SlotLensImpl;
import org.spongepowered.common.util.VecHelper;

public final class ContainerUtil {
    private static final Random RANDOM = new Random();

    private ContainerUtil() {
    }

    public static Container fromNative(net.minecraft.inventory.Container container) {
        return (Container)container;
    }

    public static net.minecraft.inventory.Container toNative(Container container) {
        return (net.minecraft.inventory.Container)container;
    }

    public static IMixinContainer toMixin(net.minecraft.inventory.Container container) {
        return (IMixinContainer)container;
    }

    public static net.minecraft.inventory.Container fromMixin(IMixinContainer container) {
        return (net.minecraft.inventory.Container)container;
    }

    public static void performBlockInventoryDrops(WorldServer worldServer, double x, double y, double z, IInventory inventory) {
        PhaseData currentPhase = CauseTracker.getInstance().getCurrentPhaseData();
        IPhaseState currentState = currentPhase.state;
        if (CauseTracker.ENABLED && currentState.tracksBlockSpecificDrops()) {
            PhaseContext context = currentPhase.context;
            if (!currentState.getPhase().ignoresItemPreMerging(currentState) && SpongeImpl.getGlobalConfig().getConfig().getOptimizations().doDropsPreMergeItemDrops()) {
                ListMultimap<BlockPos, ItemDropData> multimap = context.getBlockDropSupplier().get();
                BlockPos pos = new BlockPos(x, y, z);
                Collection itemStacks = multimap.get((Object)pos);
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    net.minecraft.item.ItemStack itemStack = inventory.func_70301_a(i);
                    if (itemStack.func_190926_b()) continue;
                    SpongeImplHooks.addItemStackToListForSpawning(itemStacks, ItemDropData.item(itemStack).position(VecHelper.toVector3d(pos)).build());
                }
            } else {
                ListMultimap<BlockPos, EntityItem> multimap = context.getBlockItemDropSupplier().get();
                BlockPos pos = new BlockPos(x, y, z);
                Collection itemStacks = multimap.get((Object)pos);
                for (int j = 0; j < inventory.func_70302_i_(); ++j) {
                    net.minecraft.item.ItemStack itemStack = inventory.func_70301_a(j);
                    if (itemStack.func_190926_b()) continue;
                    float f = RANDOM.nextFloat() * 0.8f + 0.1f;
                    float f1 = RANDOM.nextFloat() * 0.8f + 0.1f;
                    float f2 = RANDOM.nextFloat() * 0.8f + 0.1f;
                    while (!itemStack.func_190926_b()) {
                        int i = RANDOM.nextInt(21) + 10;
                        EntityItem entityitem = new EntityItem((World)worldServer, x + (double)f, y + (double)f1, z + (double)f2, itemStack.func_77979_a(i));
                        float f3 = 0.05f;
                        entityitem.field_70159_w = RANDOM.nextGaussian() * (double)0.05f;
                        entityitem.field_70181_x = RANDOM.nextGaussian() * (double)0.05f + (double)0.2f;
                        entityitem.field_70179_y = RANDOM.nextGaussian() * (double)0.05f;
                        itemStacks.add(entityitem);
                    }
                }
            }
            return;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            net.minecraft.item.ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)worldServer, (double)x, (double)y, (double)z, (net.minecraft.item.ItemStack)itemStack);
        }
    }

    @Nullable
    public static Lens<IInventory, net.minecraft.item.ItemStack> getLens(Fabric<IInventory> fabric, net.minecraft.inventory.Container container, SlotCollection slots) {
        Lens<IInventory, net.minecraft.item.ItemStack> lens;
        if (container instanceof InventoryAdapter && (lens = ((InventoryAdapter)container).getRootLens()) != null) {
            return lens;
        }
        if (container instanceof LensProvider) {
            InventoryAdapter adapter = container instanceof InventoryAdapter ? (InventoryAdapter)container : new Adapter(MinecraftFabric.of(container));
            return ((LensProvider)container).getRootLens(fabric, adapter);
        }
        if (container.func_75138_a().size() == 0) {
            return null;
        }
        return ContainerUtil.generateLens(container, slots);
    }

    private static Lens<IInventory, net.minecraft.item.ItemStack> generateLens(net.minecraft.inventory.Container container, SlotCollection slots) {
        Map viewed = container.field_75151_b.stream().collect(Collectors.groupingBy(i -> Optional.ofNullable(i.field_75224_c), LinkedHashMap::new, Collectors.toList()));
        int index = 0;
        ArrayList<Lens<IInventory, net.minecraft.item.ItemStack>> lenses = new ArrayList<Lens<IInventory, net.minecraft.item.ItemStack>>();
        for (Map.Entry entry : viewed.entrySet()) {
            Lens<IInventory, net.minecraft.item.ItemStack> adapterLens;
            IInventory subInventory = ((Optional)entry.getKey()).orElse(null);
            int slotCount = ((List)entry.getValue()).size();
            MinecraftLens lens = null;
            boolean playerLens = false;
            if (subInventory instanceof InventoryAdapter && (adapterLens = ((InventoryAdapter)subInventory).getRootLens()) != null) {
                lens = ContainerUtil.copyLens(index, (InventoryAdapter)subInventory, adapterLens, slots);
                if (adapterLens instanceof PlayerInventoryLens) {
                    playerLens = true;
                }
            }
            if (lens == null && subInventory instanceof LensProvider) {
                Fabric<IInventory> keyFabric = MinecraftFabric.of(subInventory);
                lens = ((LensProvider)subInventory).getRootLens(keyFabric, new Adapter(keyFabric));
            }
            if (lens == null || lens.slotCount() != slotCount) {
                if (subInventory instanceof InventoryCraftResult) {
                    Slot slot = (Slot)((List)entry.getValue()).get(0);
                    lens = new CraftingOutputSlotLensImpl(index, item -> slot.func_75214_a((net.minecraft.item.ItemStack)item), itemType -> slot.func_75214_a((net.minecraft.item.ItemStack)ItemStack.of(itemType, 1)));
                } else if (subInventory instanceof InventoryCrafting) {
                    InventoryCrafting craftGrid = (InventoryCrafting)subInventory;
                    lens = new GridInventoryLensImpl(index, craftGrid.func_174922_i(), craftGrid.func_174923_h(), craftGrid.func_174922_i(), InputSlot.class, slots);
                } else if (slotCount == 1) {
                    lens = new SlotLensImpl(index);
                } else if ((lens instanceof PlayerInventoryLens || playerLens) && slotCount == 36) {
                    lenses.add(new GridInventoryLensImpl(index, 9, 3, 9, (SlotProvider<IInventory, net.minecraft.item.ItemStack>)slots));
                    lenses.add(new HotbarLensImpl(index + 27, 9, slots));
                    lens = null;
                } else if (subInventory instanceof InventoryBasic && subInventory.getClass().isAnonymousClass()) {
                    switch (subInventory.func_70005_c_()) {
                        case "Enchant": 
                        case "Repair": {
                            lens = new OrderedInventoryLensImpl(index, slotCount, 1, InputSlot.class, slots);
                            break;
                        }
                        default: {
                            lens = new OrderedInventoryLensImpl(index, slotCount, 1, (SlotProvider<IInventory, net.minecraft.item.ItemStack>)slots);
                            break;
                        }
                    }
                } else {
                    lens = new OrderedInventoryLensImpl(index, slotCount, 1, (SlotProvider<IInventory, net.minecraft.item.ItemStack>)slots);
                }
            }
            if (lens != null) {
                lenses.add(lens);
            }
            index += slotCount;
        }
        return new ContainerLens((InventoryAdapter)container, slots, lenses);
    }

    private static Lens<IInventory, net.minecraft.item.ItemStack> copyLens(int base, InventoryAdapter<IInventory, net.minecraft.item.ItemStack> adapter, Lens<IInventory, net.minecraft.item.ItemStack> lens, SlotCollection slots) {
        if (lens instanceof FurnaceInventoryLens) {
            return new FurnaceInventoryLens(base, adapter, slots);
        }
        if (lens instanceof BrewingStandInventoryLens) {
            return new BrewingStandInventoryLens(base, adapter, slots);
        }
        if (lens instanceof CraftingInventoryLens) {
            return new CraftingInventoryLensImpl(base, ((GridInventoryLens)lens).getWidth(), ((GridInventoryLens)lens).getHeight(), ((GridInventoryLens)lens).getStride(), (SlotProvider<IInventory, net.minecraft.item.ItemStack>)slots);
        }
        if (lens instanceof GridInventoryLens) {
            return new GridInventoryLensImpl(base, ((GridInventoryLens)lens).getWidth(), ((GridInventoryLens)lens).getHeight(), ((GridInventoryLens)lens).getStride(), (SlotProvider<IInventory, net.minecraft.item.ItemStack>)slots);
        }
        if (lens instanceof Inventory2DLens) {
            return new Inventory2DLensImpl(base, ((Inventory2DLens)lens).getWidth(), ((Inventory2DLens)lens).getHeight(), (SlotProvider<IInventory, net.minecraft.item.ItemStack>)slots);
        }
        return null;
    }

    public static SlotCollection countSlots(net.minecraft.inventory.Container container) {
        if (container instanceof ContainerPlayer) {
            SlotCollection.Builder builder = new SlotCollection.Builder().add(1, CraftingOutputAdapter.class, i -> new CraftingOutputSlotLensImpl(i, t -> false, t -> false)).add(4).add(4, EquipmentSlotAdapter.class).add(36).add(1);
            builder.add(container.field_75151_b.size() - 46);
            return builder.build();
        }
        return new SlotCollection.Builder().add(((MinecraftInventoryAdapter)container).getInventory().getSize()).build();
    }

    public static InventoryArchetype getArchetype(net.minecraft.inventory.Container container) {
        if (container instanceof ContainerChest) {
            IInventory inventory = ((ContainerChest)container).func_85151_d();
            if (inventory instanceof TileEntityChest) {
                return InventoryArchetypes.CHEST;
            }
            if (inventory instanceof InventoryLargeChest) {
                return InventoryArchetypes.DOUBLE_CHEST;
            }
            return InventoryArchetypes.UNKNOWN;
        }
        if (container instanceof ContainerHopper) {
            return InventoryArchetypes.HOPPER;
        }
        if (container instanceof ContainerDispenser) {
            return InventoryArchetypes.DISPENSER;
        }
        if (container instanceof ContainerWorkbench) {
            return InventoryArchetypes.WORKBENCH;
        }
        if (container instanceof ContainerFurnace) {
            return InventoryArchetypes.FURNACE;
        }
        if (container instanceof ContainerEnchantment) {
            return InventoryArchetypes.ENCHANTING_TABLE;
        }
        if (container instanceof ContainerRepair) {
            return InventoryArchetypes.ANVIL;
        }
        if (container instanceof ContainerBrewingStand) {
            return InventoryArchetypes.BREWING_STAND;
        }
        if (container instanceof ContainerBeacon) {
            return InventoryArchetypes.BEACON;
        }
        if (container instanceof ContainerHorseInventory) {
            AbstractHorse horse = ((ContainerHorseInventory)container).field_111242_f;
            if (horse instanceof AbstractChestHorse && ((AbstractChestHorse)horse).func_190695_dh()) {
                return InventoryArchetypes.HORSE_WITH_CHEST;
            }
            return InventoryArchetypes.HORSE;
        }
        if (container instanceof ContainerMerchant) {
            return InventoryArchetypes.VILLAGER;
        }
        if (container instanceof ContainerPlayer) {
            return InventoryArchetypes.PLAYER;
        }
        return InventoryArchetypes.UNKNOWN;
    }

    public static Carrier getCarrier(Container container) {
        Iterator iterator;
        EntityPlayer player;
        if (container instanceof CustomContainer) {
            return ((CustomContainer)((Object)container)).inv.getCarrier();
        }
        if (container instanceof ContainerChest) {
            IInventory inventory = ((ContainerChest)container).func_85151_d();
            if (inventory instanceof TileEntityChest) {
                return (Carrier)inventory;
            }
            if (inventory instanceof InventoryLargeChest) {
                return null;
            }
            return inventory instanceof Carrier ? (Carrier)inventory : null;
        }
        if (container instanceof ContainerHopper) {
            return ContainerUtil.carrierOrNull(((ContainerHopper)container).field_94538_a);
        }
        if (container instanceof ContainerDispenser) {
            return ContainerUtil.carrierOrNull(((ContainerDispenser)container).field_178146_a);
        }
        if (container instanceof ContainerWorkbench) {
            return null;
        }
        if (container instanceof ContainerFurnace) {
            return ContainerUtil.carrierOrNull(((ContainerFurnace)container).field_75158_e);
        }
        if (container instanceof ContainerEnchantment) {
            return null;
        }
        if (container instanceof ContainerRepair) {
            return null;
        }
        if (container instanceof ContainerBrewingStand) {
            return ContainerUtil.carrierOrNull(((ContainerBrewingStand)container).field_75188_e);
        }
        if (container instanceof ContainerBeacon) {
            return ContainerUtil.carrierOrNull(((ContainerBeacon)container).func_180611_e());
        }
        if (container instanceof ContainerHorseInventory) {
            return (Carrier)((ContainerHorseInventory)container).field_111242_f;
        }
        if (container instanceof ContainerMerchant && ((ContainerMerchant)container).field_75178_e instanceof Carrier) {
            return (Carrier)((ContainerMerchant)container).field_75178_e;
        }
        if (container instanceof ContainerPlayer && (player = ((ContainerPlayer)container).field_82862_h) instanceof EntityPlayerMP) {
            return (Carrier)player;
        }
        if (container instanceof net.minecraft.inventory.Container && (iterator = ((net.minecraft.inventory.Container)container).field_75151_b.iterator()).hasNext()) {
            Slot slot = (Slot)iterator.next();
            if (slot.field_75224_c instanceof Carrier) {
                return (Carrier)slot.field_75224_c;
            }
            return null;
        }
        return null;
    }

    private static Carrier carrierOrNull(IInventory inventory) {
        if (inventory instanceof Carrier) {
            return (Carrier)inventory;
        }
        return null;
    }

    public static SlotAdapter getSlotAdapter(net.minecraft.inventory.Container container, int slot) {
        return ((IMixinContainer)container).getSlotAdapter(slot);
    }
}

