/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableMoistureData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeMoistureData;
import org.spongepowered.common.interfaces.entity.IMixinGriefer;
import org.spongepowered.common.mixin.core.block.MixinBlock;

@Mixin(value={BlockFarmland.class})
public abstract class MixinBlockFarmland
extends MixinBlock {
    @Nullable
    private Entity currentGriefer;

    @Shadow
    private void func_190970_b(World world, BlockPos pos) {
    }

    public ImmutableList<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.getMoistureData(blockState));
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableMoistureData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableMoistureData) {
            int moisture = (Integer)((ImmutableMoistureData)manipulator).moisture().get();
            if (moisture > 7) {
                moisture = 7;
            }
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(moisture)));
        }
        return super.getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.MOISTURE)) {
            int moisture = (Integer)value;
            if (moisture > 7) {
                moisture = 7;
            }
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(moisture)));
        }
        return super.getStateWithValue(blockState, key, value);
    }

    private ImmutableMoistureData getMoistureData(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeMoistureData.class, blockState.func_177229_b((IProperty)BlockFarmland.field_176531_a), 0, 7);
    }

    @Inject(method="onFallenUpon", at={@At(value="HEAD")})
    private void onFallenUponHead(World worldIn, BlockPos pos, Entity entityIn, float fallDistance, CallbackInfo ci) {
        this.currentGriefer = entityIn;
    }

    @Inject(method="onFallenUpon", at={@At(value="RETURN")})
    private void onEntityFallenUponReturn(World worldIn, BlockPos pos, Entity entityIn, float fallDistance, CallbackInfo ci) {
        this.currentGriefer = null;
    }

    @Redirect(method="onFallenUpon", at=@At(value="INVOKE", target="Lnet/minecraft/block/BlockFarmland;turnToDirt(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"))
    private void beforeTurnToDirt(BlockFarmland block, World world, BlockPos pos) {
        if (this.currentGriefer instanceof IMixinGriefer && ((IMixinGriefer)this.currentGriefer).canGrief()) {
            this.func_190970_b(world, pos);
        }
    }
}

