/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableDirectionalData;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutablePistonData;
import org.spongepowered.api.data.type.PistonType;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeDirectionalData;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongePistonData;
import org.spongepowered.common.data.util.DirectionResolver;
import org.spongepowered.common.mixin.core.block.MixinBlock;

@Mixin(value={BlockPistonExtension.class})
public abstract class MixinBlockPistonExtension
extends MixinBlock {
    public ImmutableList<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.getPistonTypeFor(blockState), (Object)this.getDirectionalData(blockState));
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutablePistonData.class.isAssignableFrom(immutable) || ImmutableDirectionalData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutablePistonData) {
            BlockPistonExtension.EnumPistonType pistonType = (BlockPistonExtension.EnumPistonType)((ImmutablePistonData)manipulator).type().get();
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockPistonExtension.field_176325_b, (Comparable)pistonType));
        }
        if (manipulator instanceof ImmutableDirectionalData) {
            Direction dir = (Direction)((Object)((ImmutableDirectionalData)manipulator).direction().get());
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockPistonExtension.field_176387_N, (Comparable)DirectionResolver.getFor(dir)));
        }
        return super.getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.PISTON_TYPE)) {
            BlockPistonExtension.EnumPistonType pistonType = (BlockPistonExtension.EnumPistonType)value;
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockPistonExtension.field_176325_b, (Comparable)pistonType));
        }
        if (key.equals(Keys.DIRECTION)) {
            Direction dir = (Direction)((Object)value);
            return Optional.of((BlockState)blockState.func_177226_a((IProperty)BlockPistonExtension.field_176387_N, (Comparable)DirectionResolver.getFor(dir)));
        }
        return super.getStateWithValue(blockState, key, value);
    }

    private ImmutablePistonData getPistonTypeFor(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongePistonData.class, (PistonType)((Object)blockState.func_177229_b((IProperty)BlockPistonExtension.field_176325_b)));
    }

    private ImmutableDirectionalData getDirectionalData(IBlockState blockState) {
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeDirectionalData.class, new Object[]{DirectionResolver.getFor((EnumFacing)blockState.func_177229_b((IProperty)BlockPistonExtension.field_176387_N))});
    }
}

