/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.passive;

import net.minecraft.entity.passive.AbstractHorse;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.mutable.entity.HorseData;
import org.spongepowered.api.data.type.HorseColor;
import org.spongepowered.api.data.type.HorseStyle;
import org.spongepowered.api.data.type.HorseVariant;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.living.animal.Horse;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeHorseData;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.mixin.core.entity.passive.MixinEntityAnimal;

@Mixin(value={AbstractHorse.class})
@Implements(value={@Interface(iface=Horse.class, prefix="horse$", unique=true)})
public abstract class MixinAbstractHorse
extends MixinEntityAnimal
implements Horse {
    @Override
    public HorseData getHorseData() {
        this.printDeprecatedHorseUsage("HorseData is not applicable to Horse, only Rideable Horse!");
        return new SpongeHorseData(DataConstants.Horse.DEFAULT_COLOR, DataConstants.Horse.DEFAULT_STYLE, DataConstants.Horse.DEFAULT_VARIANT);
    }

    @Override
    public Value<HorseVariant> variant() {
        this.printDeprecatedHorseUsage("HorseVariant is no longer applicable to all horses! HorseVariants cannot be changed!");
        return new SpongeValue<HorseVariant>(Keys.HORSE_VARIANT, DataConstants.Horse.DEFAULT_VARIANT);
    }

    @Override
    public Value<HorseStyle> style() {
        this.printDeprecatedHorseUsage("HorseStyle is only applicable to RideableHorses!");
        return new SpongeValue<HorseStyle>(Keys.HORSE_STYLE, DataConstants.Horse.DEFAULT_STYLE);
    }

    @Override
    public Value<HorseColor> color() {
        this.printDeprecatedHorseUsage("HorseColor is only applicable to RideableHorses!");
        return new SpongeValue<HorseColor>(Keys.HORSE_COLOR, DataConstants.Horse.DEFAULT_COLOR);
    }

    @Unique
    protected void printDeprecatedHorseUsage(String specificSubHeader) {
        new PrettyPrinter(60).add("Deprecated Usage Detected").centre().hr().add(specificSubHeader).addWrapped(50, "Usage of these Horse related methods are no longer supported\nwhile they work technically for data retrieval, setting\nthis unsupported data is no longer possible. Please \nnotify the plugin developer using these methods!", new Object[0]).add(new UnsupportedOperationException("Deprecated Usage Detected")).trace();
    }
}

