/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.projectile;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.spongepowered.api.entity.projectile.explosive.WitherSkull;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.interfaces.entity.IMixinGriefer;
import org.spongepowered.common.interfaces.entity.explosive.IMixinExplosive;
import org.spongepowered.common.mixin.core.entity.projectile.MixinEntityFireball;

@Mixin(value={EntityWitherSkull.class})
public abstract class MixinEntityWitherSkull
extends MixinEntityFireball
implements WitherSkull,
IMixinExplosive {
    private static final String EXPLOSION_TARGET = "Lnet/minecraft/world/World;newExplosion(Lnet/minecraft/entity/Entity;DDDFZZ)Lnet/minecraft/world/Explosion;";
    private static final int DEFAULT_EXPLOSION_RADIUS = 1;
    @Nullable
    private Cause detonationCause;
    private int explosionRadius = 1;
    private float damage = 0.0f;
    private boolean damageSet = false;

    @ModifyArg(method="onImpact", at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    protected float onAttackEntityFrom(float amount) {
        return (float)this.getDamage();
    }

    public double getDamage() {
        if (this.damageSet) {
            return this.damage;
        }
        if (this.field_70235_a != null) {
            return 8.0;
        }
        return 5.0;
    }

    public void setDamage(double damage) {
        this.damageSet = true;
        this.damage = (float)damage;
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        super.readFromNbt(compound);
        if (compound.func_74764_b("damageAmount")) {
            this.damage = compound.func_74760_g("damageAmount");
            this.damageSet = true;
        }
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        super.writeToNbt(compound);
        if (this.damageSet) {
            compound.func_74776_a("damageAmount", this.damage);
        } else {
            compound.func_82580_o("damageAmount");
        }
    }

    public Cause getDetonationCause() {
        if (this.detonationCause != null) {
            return this.detonationCause;
        }
        return Cause.of(NamedCause.of("Thrower", this.getShooter()));
    }

    @Override
    public Optional<Integer> getExplosionRadius() {
        return Optional.of(this.explosionRadius);
    }

    @Override
    public void setExplosionRadius(Optional<Integer> explosionRadius) {
        this.explosionRadius = explosionRadius.orElse(1);
    }

    @Override
    public void detonate(Cause cause) {
        this.detonationCause = (Cause)Preconditions.checkNotNull((Object)cause, (Object)"cause");
        this.onExplode(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, false, true);
        this.func_70106_y();
    }

    @Redirect(method="onImpact", at=@At(value="INVOKE", target="Lnet/minecraft/world/World;newExplosion(Lnet/minecraft/entity/Entity;DDDFZZ)Lnet/minecraft/world/Explosion;"))
    protected net.minecraft.world.Explosion onExplode(World worldObj, Entity self, double x, double y, double z, float strength, boolean flaming, boolean smoking) {
        boolean griefer = ((IMixinGriefer)((Object)this)).canGrief();
        return this.detonate(this.getDetonationCause(), Explosion.builder().location(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)worldObj, new Vector3d(x, y, z))).sourceExplosive(this).radius(this.explosionRadius).canCauseFire(flaming).shouldPlaySmoke(smoking && griefer).shouldBreakBlocks(smoking && griefer)).orElse(null);
    }
}

