/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network;

import io.netty.channel.Channel;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalAddress;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.network.PlayerConnection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeMinecraftVersion;
import org.spongepowered.common.interfaces.IMixinNetworkManager;

@Mixin(value={NetworkManager.class})
public abstract class MixinNetworkManager
extends SimpleChannelInboundHandler
implements PlayerConnection,
IMixinNetworkManager {
    @Shadow
    private Channel field_150746_k;
    @Shadow
    private INetHandler field_150744_m;
    private InetSocketAddress virtualHost;
    private MinecraftVersion version;
    private static final InetSocketAddress localhost = InetSocketAddress.createUnresolved("127.0.0.1", 0);

    @Shadow
    public abstract SocketAddress func_74430_c();

    @Override
    public InetSocketAddress getAddress() {
        SocketAddress remoteAddress = this.func_74430_c();
        if (remoteAddress instanceof LocalAddress) {
            return localhost;
        }
        return (InetSocketAddress)remoteAddress;
    }

    @Override
    public InetSocketAddress getVirtualHost() {
        if (this.virtualHost != null) {
            return this.virtualHost;
        }
        SocketAddress local = this.field_150746_k.localAddress();
        if (local instanceof LocalAddress) {
            return localhost;
        }
        return (InetSocketAddress)local;
    }

    @Override
    public void setVirtualHost(String host, int port) {
        try {
            this.virtualHost = new InetSocketAddress(InetAddress.getByAddress(host, ((InetSocketAddress)this.field_150746_k.localAddress()).getAddress().getAddress()), port);
        }
        catch (UnknownHostException e) {
            this.virtualHost = InetSocketAddress.createUnresolved(host, port);
        }
    }

    @Override
    public MinecraftVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = new SpongeMinecraftVersion(String.valueOf(version), version);
    }

    @Override
    public Player getPlayer() {
        if (this.field_150744_m instanceof NetHandlerPlayServer) {
            return (Player)((NetHandlerPlayServer)this.field_150744_m).field_147369_b;
        }
        throw new IllegalStateException("Player is not currently available");
    }

    @Override
    public int getLatency() {
        if (this.field_150744_m instanceof NetHandlerPlayServer) {
            return ((NetHandlerPlayServer)this.field_150744_m).field_147369_b.field_71138_i;
        }
        throw new IllegalStateException("Latency is not currently available");
    }
}

