/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server.network;

import java.net.SocketAddress;
import java.util.Optional;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.login.server.SPacketDisconnect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.network.NetHandlerLoginServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.IMixinNetHandlerLoginServer;
import org.spongepowered.common.text.SpongeTexts;

@Mixin(value={NetHandlerLoginServer.class})
public abstract class MixinNetHandlerLoginServer
implements IMixinNetHandlerLoginServer {
    @Shadow
    @Final
    private static Logger field_147332_c;
    @Shadow
    @Final
    public NetworkManager field_147333_a;
    @Shadow
    @Final
    private MinecraftServer field_147327_f;
    @Shadow
    private com.mojang.authlib.GameProfile field_147337_i;

    @Shadow
    public abstract String func_147317_d();

    @Shadow
    protected abstract com.mojang.authlib.GameProfile func_152506_a(com.mojang.authlib.GameProfile var1);

    @Redirect(method="tryAcceptPlayer", at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;allowUserToConnect(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Ljava/lang/String;"))
    public String onAllowUserToConnect(PlayerList confMgr, SocketAddress address, com.mojang.authlib.GameProfile profile) {
        return null;
    }

    private void closeConnection(ITextComponent reason) {
        try {
            field_147332_c.info("Disconnecting " + this.func_147317_d() + ": " + reason.func_150260_c());
            this.field_147333_a.func_179290_a((Packet)new SPacketDisconnect(reason));
            this.field_147333_a.func_150718_a(reason);
        }
        catch (Exception exception) {
            field_147332_c.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    private void disconnectClient(Optional<Text> disconnectMessage) {
        Object reason = null;
        reason = disconnectMessage.isPresent() ? SpongeTexts.toComponent(disconnectMessage.get()) : new TextComponentTranslation("disconnect.disconnected", new Object[0]);
        this.closeConnection((ITextComponent)reason);
    }

    @Override
    public boolean fireAuthEvent() {
        LiteralText disconnectMessage = Text.of("You are not allowed to log in to this server.");
        ClientConnectionEvent.Auth event = SpongeEventFactory.createClientConnectionEventAuth(Cause.of(NamedCause.source(this.field_147337_i)), (RemoteConnection)this.field_147333_a, new MessageEvent.MessageFormatter(disconnectMessage), (GameProfile)this.field_147337_i, false);
        SpongeImpl.postEvent(event);
        if (event.isCancelled()) {
            this.disconnectClient(event.isMessageCancelled() ? Optional.empty() : Optional.of(event.getMessage()));
        }
        return event.isCancelled();
    }

    @Inject(method="processLoginStart", at={@At(value="FIELD", target="Lnet/minecraft/server/network/NetHandlerLoginServer;currentLoginState:Lnet/minecraft/server/network/NetHandlerLoginServer$LoginState;", opcode=181, ordinal=1)}, cancellable=true)
    public void fireAuthEventOffline(CallbackInfo ci) {
        if (!this.field_147337_i.isComplete()) {
            this.field_147337_i = this.func_152506_a(this.field_147337_i);
        }
        if (this.fireAuthEvent()) {
            ci.cancel();
        }
    }
}

