/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.stats;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.TupleIntJsonSerializable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.statistic.ChangeStatisticEvent;
import org.spongepowered.api.statistic.Statistic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.interfaces.statistic.IMixinStatisticsManager;

@Mixin(value={StatisticsManager.class})
public abstract class MixinStatisticsManager
implements IMixinStatisticsManager {
    @Shadow
    @Final
    protected Map<StatBase, TupleIntJsonSerializable> field_150875_a;
    private boolean statCaptured = false;

    @Shadow
    public abstract int func_77444_a(StatBase var1);

    @Shadow
    public abstract void func_150871_b(EntityPlayer var1, StatBase var2, int var3);

    @Inject(method="increaseStat(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/stats/StatBase;I)V", at={@At(value="HEAD")}, cancellable=true)
    public void onStatChange(EntityPlayer player, StatBase stat, int amount, CallbackInfo ci) {
        if (this.statCaptured) {
            return;
        }
        int prev = this.func_77444_a(stat);
        ChangeStatisticEvent.TargetPlayer event = SpongeEventFactory.createChangeStatisticEventTargetPlayer(Cause.source(player).build(), prev, prev + amount, (Statistic)stat, (Player)player);
        boolean cancelled = Sponge.getEventManager().post(event);
        this.statCaptured = true;
        ci.cancel();
        if (!cancelled) {
            this.func_150871_b(player, stat, (int)(event.getValue() - (long)prev));
            this.statCaptured = false;
        }
    }

    @Override
    public Map<StatBase, TupleIntJsonSerializable> getStatsData() {
        return ImmutableMap.copyOf(this.field_150875_a);
    }
}

