/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.status;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.event.server.ClientPingServerEvent;
import org.spongepowered.api.network.status.Favicon;
import org.spongepowered.api.text.Text;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.network.status.SpongeFavicon;
import org.spongepowered.common.text.SpongeTexts;

@Mixin(value={ServerStatusResponse.class})
public abstract class MixinServerStatusResponse
implements ClientPingServerEvent.Response {
    @Shadow
    @Nullable
    private ITextComponent field_151326_a;
    @Shadow
    @Nullable
    private ServerStatusResponse.Players field_151324_b;
    @Shadow
    private ServerStatusResponse.Version field_151325_c;
    @Shadow
    @Nullable
    private String field_151323_d;
    private Text descriptionText = Text.of();
    @Nullable
    private ServerStatusResponse.Players playerBackup;
    @Nullable
    private Favicon faviconHandle;

    @Inject(method="<init>", at={@At(value="RETURN")})
    public void onInit(CallbackInfo ci) {
        this.func_151315_a(null);
    }

    @Override
    public Text getDescription() {
        return this.descriptionText;
    }

    @Override
    public void setDescription(Text description) {
        this.descriptionText = (Text)Preconditions.checkNotNull((Object)description, (Object)"description");
        this.field_151326_a = SpongeTexts.toComponent(description);
    }

    @Overwrite
    public void func_151315_a(@Nullable ITextComponent motd) {
        if (motd != null) {
            this.field_151326_a = motd;
            this.descriptionText = SpongeTexts.toText(motd);
        } else {
            this.field_151326_a = new TextComponentString("");
            this.descriptionText = Text.of();
        }
    }

    @Override
    public Optional<ClientPingServerEvent.Response.Players> getPlayers() {
        return Optional.ofNullable((ClientPingServerEvent.Response.Players)this.field_151324_b);
    }

    @Override
    public void setHidePlayers(boolean hide) {
        if (this.field_151324_b == null != hide) {
            if (hide) {
                this.playerBackup = this.field_151324_b;
                this.field_151324_b = null;
            } else {
                this.field_151324_b = this.playerBackup;
                this.playerBackup = null;
            }
        }
    }

    @Override
    public MinecraftVersion getVersion() {
        return (MinecraftVersion)this.field_151325_c;
    }

    @Override
    public Optional<Favicon> getFavicon() {
        return Optional.ofNullable(this.faviconHandle);
    }

    @Override
    public void setFavicon(@Nullable Favicon favicon) {
        this.faviconHandle = favicon;
        this.field_151323_d = this.faviconHandle != null ? ((SpongeFavicon)this.faviconHandle).getEncoded() : null;
    }

    @Overwrite
    public void func_151320_a(@Nullable String faviconBlob) {
        if (faviconBlob == null) {
            this.field_151323_d = null;
            this.faviconHandle = null;
        } else {
            try {
                this.faviconHandle = new SpongeFavicon(faviconBlob);
                this.field_151323_d = faviconBlob;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

