/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.PortalAgent;
import org.spongepowered.api.world.PortalAgentType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.interfaces.world.IMixinLocation;
import org.spongepowered.common.interfaces.world.IMixinTeleporter;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.registry.type.world.PortalAgentRegistryModule;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={Teleporter.class})
public class MixinTeleporter
implements PortalAgent,
IMixinTeleporter {
    private int searchRadius = 128;
    private int creationRadius = 16;
    private boolean createNetherPortal = true;
    private PortalAgentType portalAgentType = PortalAgentRegistryModule.getInstance().validatePortalAgent((Teleporter)this);
    @Shadow
    @Final
    private WorldServer field_85192_a;
    @Shadow
    @Final
    private Random field_77187_a;
    @Shadow
    @Final
    private Long2ObjectMap<Teleporter.PortalPosition> field_85191_c;

    @Override
    public int getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    public PortalAgent setSearchRadius(int radius) {
        this.searchRadius = radius;
        return this;
    }

    @Override
    public int getCreationRadius() {
        return this.creationRadius;
    }

    @Override
    public PortalAgent setCreationRadius(int radius) {
        this.creationRadius = radius;
        return this;
    }

    @Overwrite
    public void func_180266_a(Entity entityIn, float rotationYaw) {
        Location<org.spongepowered.api.world.World> targetLocation = ((org.spongepowered.api.entity.Entity)entityIn).getLocation();
        if (this.createNetherPortal) {
            if (!this.func_180620_b(entityIn, rotationYaw)) {
                this.func_85188_a(entityIn);
                this.func_180620_b(entityIn, rotationYaw);
            }
        } else {
            this.createEndPortal(targetLocation);
            entityIn.func_70012_b(targetLocation.getX(), targetLocation.getY() - 1.0, targetLocation.getZ(), entityIn.field_70177_z, 0.0f);
            entityIn.field_70179_y = 0.0;
            entityIn.field_70181_x = 0.0;
            entityIn.field_70159_w = 0.0;
        }
    }

    private void createEndPortal(Location<org.spongepowered.api.world.World> targetLocation) {
        int xTarget = targetLocation.getBlockX();
        int yTarget = targetLocation.getBlockY() - 1;
        int zTarget = targetLocation.getBlockZ();
        int l = 1;
        int i1 = 0;
        for (int j1 = -2; j1 <= 2; ++j1) {
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -1; l1 < 3; ++l1) {
                    int x = xTarget + k1 * l + j1 * i1;
                    int y = yTarget + l1;
                    int z = zTarget + k1 * i1 - j1 * l;
                    boolean flag = l1 < 0;
                    this.field_85192_a.func_175656_a(new BlockPos(x, y, z), flag ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    @Override
    public Optional<Location<org.spongepowered.api.world.World>> findOrCreatePortal(Location<org.spongepowered.api.world.World> targetLocation) {
        Optional<Location<org.spongepowered.api.world.World>> foundTeleporter = this.findPortal(targetLocation);
        if (!foundTeleporter.isPresent()) {
            if (this.createPortal(targetLocation).isPresent()) {
                return this.findPortal(targetLocation);
            }
            return Optional.empty();
        }
        return foundTeleporter;
    }

    @Overwrite
    public boolean func_180620_b(Entity entityIn, float rotationYaw) {
        if (entityIn == null) {
            return false;
        }
        org.spongepowered.api.entity.Entity spongeEntity = (org.spongepowered.api.entity.Entity)entityIn;
        Optional<Location<org.spongepowered.api.world.World>> location = this.findPortal(spongeEntity.getLocation());
        if (location.isPresent()) {
            this.handleEntityPortalExit(entityIn, location.get(), rotationYaw);
            return true;
        }
        return false;
    }

    @Override
    public Optional<Location<org.spongepowered.api.world.World>> findPortal(Location<org.spongepowered.api.world.World> searchLocation) {
        double closest = -1.0;
        boolean addToCache = true;
        BlockPos portalPosition = BlockPos.field_177992_a;
        Vector3i chunkPosition = searchLocation.getChunkPosition();
        long targetPosition = ChunkPos.func_77272_a((int)chunkPosition.getX(), (int)chunkPosition.getZ());
        if (this.field_85191_c.containsKey(targetPosition)) {
            Teleporter.PortalPosition teleporter$portalposition = (Teleporter.PortalPosition)this.field_85191_c.get(targetPosition);
            closest = 0.0;
            portalPosition = teleporter$portalposition;
            teleporter$portalposition.field_85087_d = this.field_85192_a.func_82737_E();
            addToCache = false;
        } else {
            BlockPos blockSearchPosition = ((IMixinLocation)((Object)searchLocation)).getBlockPos();
            for (int i1 = -this.searchRadius; i1 <= this.searchRadius; ++i1) {
                for (int j1 = -this.searchRadius; j1 <= this.searchRadius; ++j1) {
                    BlockPos blockpos1 = blockSearchPosition.func_177982_a(i1, this.field_85192_a.func_72940_L() - 1 - blockSearchPosition.func_177956_o(), j1);
                    while (blockpos1.func_177956_o() >= 0) {
                        BlockPos blockpos2 = blockpos1.func_177977_b();
                        if (this.field_85192_a.func_180495_p(blockpos1).func_177230_c() == Blocks.field_150427_aO) {
                            while (this.field_85192_a.func_180495_p(blockpos2 = blockpos1.func_177977_b()).func_177230_c() == Blocks.field_150427_aO) {
                                blockpos1 = blockpos2;
                            }
                            double distance = blockpos1.func_177951_i((Vec3i)blockSearchPosition);
                            if (closest < 0.0 || distance < closest) {
                                closest = distance;
                                portalPosition = blockpos1;
                            }
                        }
                        blockpos1 = blockpos2;
                    }
                }
            }
        }
        if (closest >= 0.0) {
            if (addToCache) {
                Teleporter teleporter = (Teleporter)this;
                teleporter.getClass();
                this.field_85191_c.put(targetPosition, new Teleporter.PortalPosition(teleporter, portalPosition, this.field_85192_a.func_82737_E()));
            }
            return Optional.of(new Location<org.spongepowered.api.world.World>(searchLocation.getExtent(), VecHelper.toVector3d(portalPosition)));
        }
        return Optional.empty();
    }

    private void handleEntityPortalExit(Entity entityIn, Location<org.spongepowered.api.world.World> portalLocation, float rotationYaw) {
        BlockPos blockPos = ((IMixinLocation)((Object)portalLocation)).getBlockPos();
        double xTarget = portalLocation.getX() + 0.5;
        double yTarget = portalLocation.getY() + 0.5;
        double zTarget = portalLocation.getZ() + 0.5;
        BlockPattern.PatternHelper blockpattern$patternhelper = Blocks.field_150427_aO.func_181089_f((World)this.field_85192_a, blockPos);
        boolean flag1 = blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
        double d2 = blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X ? (double)blockpattern$patternhelper.func_181117_a().func_177952_p() : (double)blockpattern$patternhelper.func_181117_a().func_177958_n();
        yTarget = (double)(blockpattern$patternhelper.func_181117_a().func_177956_o() + 1) - entityIn.func_181014_aG().field_72448_b * (double)blockpattern$patternhelper.func_181119_e();
        if (flag1) {
            d2 += 1.0;
        }
        if (blockpattern$patternhelper.func_177669_b().func_176740_k() == EnumFacing.Axis.X) {
            zTarget = d2 + (1.0 - entityIn.func_181014_aG().field_72450_a) * (double)blockpattern$patternhelper.func_181118_d() * (double)blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
        } else {
            xTarget = d2 + (1.0 - entityIn.func_181014_aG().field_72450_a) * (double)blockpattern$patternhelper.func_181118_d() * (double)blockpattern$patternhelper.func_177669_b().func_176746_e().func_176743_c().func_179524_a();
        }
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (blockpattern$patternhelper.func_177669_b().func_176734_d() == entityIn.func_181012_aH()) {
            f = 1.0f;
            f1 = 1.0f;
        } else if (blockpattern$patternhelper.func_177669_b().func_176734_d() == entityIn.func_181012_aH().func_176734_d()) {
            f = -1.0f;
            f1 = -1.0f;
        } else if (blockpattern$patternhelper.func_177669_b().func_176734_d() == entityIn.func_181012_aH().func_176746_e()) {
            f2 = 1.0f;
            f3 = -1.0f;
        } else {
            f2 = -1.0f;
            f3 = 1.0f;
        }
        double d3 = entityIn.field_70159_w;
        double d4 = entityIn.field_70179_y;
        entityIn.field_70159_w = d3 * (double)f + d4 * (double)f3;
        entityIn.field_70179_y = d3 * (double)f2 + d4 * (double)f1;
        entityIn.field_70177_z = rotationYaw - (float)(entityIn.func_181012_aH().func_176734_d().func_176736_b() * 90) + (float)(blockpattern$patternhelper.func_177669_b().func_176736_b() * 90);
        entityIn.func_70012_b(xTarget, yTarget, zTarget, entityIn.field_70177_z, entityIn.field_70125_A);
    }

    @Overwrite
    public boolean func_85188_a(Entity entityIn) {
        return this.createPortal(((org.spongepowered.api.entity.Entity)entityIn).getLocation()).isPresent();
    }

    @Override
    public Optional<Location<org.spongepowered.api.world.World>> createPortal(Location<org.spongepowered.api.world.World> toLocation) {
        return this.createTeleporter(toLocation, false);
    }

    public Optional<Location<org.spongepowered.api.world.World>> createTeleporter(Location<org.spongepowered.api.world.World> nearLocation, boolean plugin) {
        IMixinWorldServer spongeWorld = (IMixinWorldServer)((Object)nearLocation.getExtent());
        CauseTracker causeTracker = CauseTracker.getInstance();
        double closest = -1.0;
        int xNearTarget = nearLocation.getBlockX();
        int yNearTarget = nearLocation.getBlockY();
        int zNearTarget = nearLocation.getBlockZ();
        int xAdjustedTarget = xNearTarget;
        int yAdjustedTarget = yNearTarget;
        int zAdjustedTarget = zNearTarget;
        int direction = 0;
        int dirOffset = this.field_77187_a.nextInt(4);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j2 = xNearTarget - this.creationRadius; j2 <= xNearTarget + this.creationRadius; ++j2) {
            double d1 = (double)j2 + 0.5 - (double)nearLocation.getBlockX();
            for (int l2 = zNearTarget - this.creationRadius; l2 <= zNearTarget + this.creationRadius; ++l2) {
                double d2 = (double)l2 + 0.5 - (double)nearLocation.getBlockZ();
                block2: for (int j3 = this.field_85192_a.func_72940_L() - 1; j3 >= 0; --j3) {
                    if (!this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(j2, j3, l2))) continue;
                    while (j3 > 0 && this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(j2, j3 - 1, l2))) {
                        --j3;
                    }
                    for (int k3 = dirOffset; k3 < dirOffset + 4; ++k3) {
                        int l3 = k3 % 2;
                        int i4 = 1 - l3;
                        if (k3 % 4 >= 2) {
                            l3 = -l3;
                            i4 = -i4;
                        }
                        for (int j4 = 0; j4 < 3; ++j4) {
                            for (int k4 = 0; k4 < 4; ++k4) {
                                for (int l4 = -1; l4 < 4; ++l4) {
                                    int i5 = j2 + (k4 - 1) * l3 + j4 * i4;
                                    int j5 = j3 + l4;
                                    int k5 = l2 + (k4 - 1) * i4 - j4 * l3;
                                    blockpos$mutableblockpos.func_181079_c(i5, j5, k5);
                                    if (l4 < 0 && !this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() || l4 >= 0 && !this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos)) continue block2;
                                }
                            }
                        }
                        double d5 = (double)j3 + 0.5 - (double)nearLocation.getBlockY();
                        double distance = d1 * d1 + d5 * d5 + d2 * d2;
                        if (!(closest < 0.0) && !(distance < closest)) continue;
                        closest = distance;
                        xAdjustedTarget = j2;
                        yAdjustedTarget = j3;
                        zAdjustedTarget = l2;
                        direction = k3 % 4;
                    }
                }
            }
        }
        if (closest < 0.0) {
            for (int l5 = xNearTarget - this.creationRadius; l5 <= xNearTarget + this.creationRadius; ++l5) {
                double d3 = (double)l5 + 0.5 - (double)nearLocation.getBlockX();
                for (int j6 = zNearTarget - this.creationRadius; j6 <= zNearTarget + this.creationRadius; ++j6) {
                    double d4 = (double)j6 + 0.5 - (double)nearLocation.getBlockZ();
                    block10: for (int i7 = this.field_85192_a.func_72940_L() - 1; i7 >= 0; --i7) {
                        if (!this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(l5, i7, j6))) continue;
                        while (i7 > 0 && this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(l5, i7 - 1, j6))) {
                            --i7;
                        }
                        for (int k7 = dirOffset; k7 < dirOffset + 2; ++k7) {
                            int j8 = k7 % 2;
                            int j9 = 1 - j8;
                            for (int j10 = 0; j10 < 4; ++j10) {
                                for (int j11 = -1; j11 < 4; ++j11) {
                                    int j12 = l5 + (j10 - 1) * j8;
                                    int i13 = i7 + j11;
                                    int j13 = j6 + (j10 - 1) * j9;
                                    blockpos$mutableblockpos.func_181079_c(j12, i13, j13);
                                    if (j11 < 0 && !this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() || j11 >= 0 && !this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos)) continue block10;
                                }
                            }
                            double d6 = (double)i7 + 0.5 - (double)nearLocation.getBlockY();
                            double distance = d3 * d3 + d6 * d6 + d4 * d4;
                            if (!(closest < 0.0) && !(distance < closest)) continue;
                            closest = distance;
                            xAdjustedTarget = l5;
                            yAdjustedTarget = i7;
                            zAdjustedTarget = j6;
                            direction = k7 % 2;
                        }
                    }
                }
            }
        }
        int xFinalTarget = xAdjustedTarget;
        int yFinalTarget = yAdjustedTarget;
        int zFinalTarget = zAdjustedTarget;
        int targetDirection = direction % 2;
        int targetDirOffset = 1 - targetDirection;
        if (direction % 4 >= 2) {
            targetDirection = -targetDirection;
            targetDirOffset = -targetDirOffset;
        }
        if (closest < 0.0) {
            yFinalTarget = yAdjustedTarget = MathHelper.func_76125_a((int)yAdjustedTarget, (int)70, (int)(this.field_85192_a.func_72940_L() - 10));
            for (int j7 = -1; j7 <= 1; ++j7) {
                for (int l7 = 1; l7 < 3; ++l7) {
                    for (int k8 = -1; k8 < 3; ++k8) {
                        int k9 = xFinalTarget + (l7 - 1) * targetDirection + j7 * targetDirOffset;
                        int k10 = yFinalTarget + k8;
                        int k11 = zFinalTarget + (l7 - 1) * targetDirOffset - j7 * targetDirection;
                        boolean flag = k8 < 0;
                        this.field_85192_a.func_175656_a(new BlockPos(k9, k10, k11), flag ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
        IBlockState iblockstate = Blocks.field_150427_aO.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)(targetDirection != 0 ? EnumFacing.Axis.X : EnumFacing.Axis.Z));
        for (int i8 = 0; i8 < 4; ++i8) {
            for (int l8 = 0; l8 < 4; ++l8) {
                for (int l9 = -1; l9 < 4; ++l9) {
                    int l10 = xFinalTarget + (l8 - 1) * targetDirection;
                    int l11 = yFinalTarget + l9;
                    int k12 = zFinalTarget + (l8 - 1) * targetDirOffset;
                    boolean flag1 = l8 == 0 || l8 == 3 || l9 == -1 || l9 == 3;
                    this.field_85192_a.func_180501_a(new BlockPos(l10, l11, k12), flag1 ? Blocks.field_150343_Z.func_176223_P() : iblockstate, 2);
                }
            }
            for (int i9 = 0; i9 < 4; ++i9) {
                for (int i10 = -1; i10 < 4; ++i10) {
                    int i11 = xFinalTarget + (i9 - 1) * targetDirection;
                    int i12 = yFinalTarget + i10;
                    int l12 = zFinalTarget + (i9 - 1) * targetDirOffset;
                    BlockPos blockpos = new BlockPos(i11, i12, l12);
                    this.field_85192_a.func_190524_a(blockpos, this.field_85192_a.func_180495_p(blockpos).func_177230_c(), blockpos);
                }
            }
        }
        if (plugin) {
            // empty if block
        }
        return Optional.of(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)this.field_85192_a, new Vector3i(xFinalTarget, yFinalTarget, zFinalTarget)));
    }

    @Override
    public void removePortalPositionFromCache(Long portalPosition) {
        this.field_85191_c.remove(portalPosition);
    }

    @Override
    public void setPortalAgentType(PortalAgentType type) {
        this.portalAgentType = type;
    }

    @Override
    public PortalAgentType getType() {
        return this.portalAgentType;
    }

    @Override
    public void setPortalType(int dimensionId) {
        this.createNetherPortal = dimensionId == -1;
    }

    public String toString() {
        return Objects.toStringHelper((String)"PortalAgent").add("PortalAgentType", (Object)this.portalAgentType).add("SearchRadius", this.searchRadius).add("CreationRadius", this.creationRadius).add("World", (Object)this.field_85192_a.func_72912_H().func_76065_j()).add("DimensionId", (Object)((IMixinWorldServer)this.field_85192_a).getDimensionId()).toString();
    }
}

