/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.effect.Viewer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.projectile.EnderPearl;
import org.spongepowered.api.entity.projectile.source.ProjectileSource;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.NamedCause;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.chat.ChatType;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.Functional;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.ChunkPreGenerate;
import org.spongepowered.api.world.Dimension;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.extent.EntityUniverse;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.extent.worker.MutableBiomeVolumeWorker;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.BlockUtil;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.data.type.SpongeTileEntityType;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.CauseTracker;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.data.IMixinCustomDataHolder;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.entity.player.IMixinEntityPlayer;
import org.spongepowered.common.interfaces.util.math.IMixinBlockPos;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;
import org.spongepowered.common.interfaces.world.IMixinWorldProvider;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.extent.ExtentViewDownsize;
import org.spongepowered.common.world.extent.worker.SpongeMutableBiomeVolumeWorker;
import org.spongepowered.common.world.extent.worker.SpongeMutableBlockVolumeWorker;
import org.spongepowered.common.world.pregen.SpongeChunkPreGenerateTask;
import org.spongepowered.common.world.storage.SpongeChunkLayout;

@NonnullByDefault
@Mixin(value={net.minecraft.world.World.class})
public abstract class MixinWorld
implements World,
IMixinWorld {
    private static final Vector3i BLOCK_MIN = new Vector3i(-30000000, 0, -30000000);
    private static final Vector3i BLOCK_MAX = new Vector3i(30000000, 256, 30000000).sub(Vector3i.ONE);
    private static final Vector3i BLOCK_SIZE = BLOCK_MAX.sub(BLOCK_MIN).add(Vector3i.ONE);
    private static final Vector3i BIOME_MIN = new Vector3i(BLOCK_MIN.getX(), 0, BLOCK_MIN.getZ());
    private static final Vector3i BIOME_MAX = new Vector3i(BLOCK_MAX.getX(), 256, BLOCK_MAX.getZ());
    private static final Vector3i BIOME_SIZE = BIOME_MAX.sub(BIOME_MIN).add(Vector3i.ONE);
    private static final String CHECK_NO_ENTITY_COLLISION = "checkNoEntityCollision(Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/entity/Entity;)Z";
    private static final String GET_ENTITIES_WITHIN_AABB = "Lnet/minecraft/world/World;getEntitiesWithinAABBExcludingEntity(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;)Ljava/util/List;";
    public SpongeBlockSnapshotBuilder builder = new SpongeBlockSnapshotBuilder();
    @Nullable
    private Context worldContext;
    protected boolean processingExplosion = false;
    protected boolean isDefinitelyFake = false;
    protected boolean hasChecked = false;
    protected NamedCause worldNamedCause;
    @Shadow
    @Final
    public boolean field_72995_K;
    @Shadow
    @Final
    public WorldProvider field_73011_w;
    @Shadow
    @Final
    public Random field_73012_v;
    @Shadow
    @Final
    public Profiler field_72984_F;
    @Shadow
    @Final
    public List<EntityPlayer> field_73010_i;
    @Shadow
    @Final
    public List<net.minecraft.entity.Entity> field_72996_f;
    @Shadow
    @Final
    public List<net.minecraft.entity.Entity> field_73007_j;
    @Shadow
    @Final
    public List<net.minecraft.entity.Entity> field_72997_g;
    @Shadow
    @Final
    public List<TileEntity> field_147482_g;
    @Shadow
    @Final
    public List<TileEntity> field_175730_i;
    @Shadow
    @Final
    public List<TileEntity> field_147483_b;
    @Shadow
    @Final
    private List<TileEntity> field_147484_a;
    @Shadow
    @Final
    protected ISaveHandler field_73019_z;
    @Shadow
    protected List<IWorldEventListener> field_73021_x;
    @Shadow
    public int[] field_72994_J;
    @Shadow
    public int field_73008_k;
    @Shadow
    public boolean field_147481_N;
    @Shadow
    protected boolean field_72999_e;
    @Shadow
    protected WorldInfo field_72986_A;
    @Shadow
    protected IChunkProvider field_73020_y;
    @Shadow
    @Final
    public net.minecraft.world.border.WorldBorder field_175728_M;
    @Shadow
    protected int field_73005_l;

    @Shadow
    public abstract net.minecraft.world.border.WorldBorder shadow$func_175723_af();

    @Shadow
    public abstract EnumDifficulty shadow$func_175659_aa();

    @Shadow
    protected abstract void func_184147_l();

    @Shadow
    public net.minecraft.world.World func_175643_b() {
        throw new RuntimeException("Bad things have happened");
    }

    @Shadow
    public abstract int func_175699_k(BlockPos var1);

    @Shadow
    public abstract int func_175721_c(BlockPos var1, boolean var2);

    @Shadow
    public abstract int func_175638_a(BlockPos var1, EnumSkyBlock var2);

    @Shadow
    public abstract int func_175657_ab();

    @Shadow
    public abstract net.minecraft.world.chunk.Chunk func_175726_f(BlockPos var1);

    @Shadow
    public abstract WorldInfo func_72912_H();

    @Shadow
    public abstract boolean func_175664_x(BlockPos var1);

    @Shadow
    public abstract boolean func_180500_c(EnumSkyBlock var1, BlockPos var2);

    @Shadow
    public abstract boolean func_175700_a(TileEntity var1);

    @Shadow
    public abstract void func_72923_a(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract boolean func_175707_a(BlockPos var1, BlockPos var2);

    @Shadow
    public abstract boolean func_175648_a(BlockPos var1, int var2, boolean var3);

    @Shadow
    public abstract boolean func_175663_a(int var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    @Shadow
    public abstract void func_72847_b(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void func_72870_g(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract boolean func_175667_e(BlockPos var1);

    @Shadow
    public abstract boolean func_72942_c(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract Biome func_180494_b(BlockPos var1);

    @Shadow
    public abstract BiomeProvider func_72959_q();

    @Shadow
    public abstract boolean func_175640_z(BlockPos var1);

    @Shadow
    public abstract net.minecraft.world.chunk.Chunk func_72964_e(int var1, int var2);

    @Shadow
    public abstract boolean func_175680_a(int var1, int var2, boolean var3);

    @Shadow
    public abstract Explosion func_72885_a(@Nullable net.minecraft.entity.Entity var1, double var2, double var4, double var6, float var8, boolean var9, boolean var10);

    @Shadow
    public abstract List<net.minecraft.entity.Entity> func_175644_a(Class<net.minecraft.entity.Entity> var1, com.google.common.base.Predicate<net.minecraft.entity.Entity> var2);

    @Shadow
    public abstract <T extends net.minecraft.entity.Entity> List<T> func_175647_a(Class<? extends T> var1, AxisAlignedBB var2, com.google.common.base.Predicate<? super T> var3);

    @Shadow
    public abstract List<net.minecraft.entity.Entity> func_72839_b(net.minecraft.entity.Entity var1, AxisAlignedBB var2);

    @Shadow
    public abstract MinecraftServer func_73046_m();

    @Shadow
    public abstract boolean func_72838_d(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void func_72854_c();

    @Shadow
    public abstract boolean func_175656_a(BlockPos var1, IBlockState var2);

    @Shadow
    public abstract boolean func_180501_a(BlockPos var1, IBlockState var2, int var3);

    @Shadow
    public abstract void func_189507_a(BlockPos var1, IBlockState var2, Random var3);

    @Shadow
    public abstract void func_175666_e(BlockPos var1, Block var2);

    @Shadow
    public abstract void func_190524_a(BlockPos var1, Block var2, BlockPos var3);

    @Shadow
    public abstract void func_175695_a(BlockPos var1, Block var2, EnumFacing var3);

    @Shadow
    public abstract void func_190522_c(BlockPos var1, Block var2);

    @Shadow
    public abstract void func_175722_b(BlockPos var1, Block var2, boolean var3);

    @Shadow
    public abstract void func_175685_c(BlockPos var1, Block var2, boolean var3);

    @Shadow
    public abstract void func_184138_a(BlockPos var1, IBlockState var2, IBlockState var3, int var4);

    @Shadow
    public abstract void func_175654_a(BlockPos var1, Block var2, int var3, int var4);

    @Shadow
    public abstract void func_184148_a(EntityPlayer var1, double var2, double var4, double var6, SoundEvent var8, SoundCategory var9, float var10, float var11);

    @Shadow
    protected abstract void func_147456_g();

    @Shadow
    public abstract GameRules shadow$func_82736_K();

    @Shadow
    public abstract boolean func_72896_J();

    @Shadow
    public abstract boolean func_72911_I();

    @Shadow
    public abstract boolean func_175727_C(BlockPos var1);

    @Shadow
    public abstract DifficultyInstance func_175649_E(BlockPos var1);

    @Shadow
    public abstract BlockPos func_175725_q(BlockPos var1);

    @Shadow
    public abstract boolean func_175662_w(BlockPos var1);

    @Shadow
    public abstract boolean func_175708_f(BlockPos var1, boolean var2);

    @Shadow
    public abstract List<AxisAlignedBB> func_184144_a(net.minecraft.entity.Entity var1, AxisAlignedBB var2);

    @Shadow
    public abstract void func_175679_n(BlockPos var1);

    @Shadow
    @Nullable
    private TileEntity func_189508_F(BlockPos p_189508_1_) {
        return null;
    }

    @Shadow
    public abstract int func_189649_b(int var1, int var2);

    @Redirect(method="<init>", at=@At(value="INVOKE", target="Lnet/minecraft/world/WorldProvider;createWorldBorder()Lnet/minecraft/world/border/WorldBorder;"))
    private net.minecraft.world.border.WorldBorder onCreateWorldBorder(WorldProvider provider) {
        if (this.field_72995_K) {
            return provider.func_177501_r();
        }
        return ((IMixinWorldProvider)provider).createServerWorldBorder();
    }

    @Inject(method="getCollisionBoxes", at={@At(value="HEAD")}, cancellable=true)
    public void onGetCollisionBoxes(net.minecraft.entity.Entity entity, AxisAlignedBB axis, CallbackInfoReturnable<List> cir) {
        if (this.field_72995_K || entity == null) {
            return;
        }
        if (entity.field_70170_p != null && !entity.field_70170_p.field_72995_K && SpongeHooks.checkBoundingBoxSize(entity, axis)) {
            cir.setReturnValue(new ArrayList());
        }
    }

    @Override
    public Collection<Player> getPlayers() {
        return ImmutableList.copyOf((Collection)this.field_73010_i);
    }

    @Override
    public UUID getUniqueId() {
        WorldProperties properties = this.getProperties();
        UUID worldId = properties.getUniqueId();
        if (worldId == null) {
            IMixinWorldInfo mixinWorldInfo = (IMixinWorldInfo)((Object)properties);
            mixinWorldInfo.setUniqueId(UUID.randomUUID());
            return properties.getUniqueId();
        }
        return worldId;
    }

    @Override
    public Optional<Chunk> getChunk(int x, int y, int z) {
        if (!SpongeChunkLayout.instance.isValidChunk(x, y, z)) {
            return Optional.empty();
        }
        WorldServer worldserver = (WorldServer)this;
        return Optional.ofNullable((Chunk)worldserver.func_72863_F().func_186026_b(x, z));
    }

    @Override
    public Optional<Chunk> loadChunk(int x, int y, int z, boolean shouldGenerate) {
        if (!SpongeChunkLayout.instance.isValidChunk(x, y, z)) {
            return Optional.empty();
        }
        WorldServer worldserver = (WorldServer)this;
        if (!shouldGenerate) {
            return Optional.ofNullable((Chunk)worldserver.func_72863_F().func_186028_c(x, z));
        }
        return Optional.ofNullable((Chunk)worldserver.func_72863_F().func_186025_d(x, z));
    }

    @Override
    public int getHighestYAt(int x, int z) {
        return this.func_189649_b(x, z);
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        if (!this.containsBlock(x, y, z)) {
            return BlockTypes.AIR.getDefaultState();
        }
        this.checkBlockBounds(x, y, z);
        return (BlockState)this.func_180495_p(new BlockPos(x, y, z));
    }

    @Override
    public BlockType getBlockType(int x, int y, int z) {
        if (!this.containsBlock(x, y, z)) {
            return BlockTypes.AIR;
        }
        this.checkBlockBounds(x, y, z);
        return (BlockType)this.func_72964_e(x >> 4, z >> 4).func_177435_g(new BlockPos(x, y, z)).func_177230_c();
    }

    @Override
    public boolean setBlock(int x, int y, int z, BlockState block, Cause cause) {
        return this.setBlock(x, y, z, block, BlockChangeFlag.ALL, cause);
    }

    @Override
    public BiomeType getBiome(int x, int y, int z) {
        this.checkBiomeBounds(x, y, z);
        return (BiomeType)this.func_180494_b(new BlockPos(x, y, z));
    }

    @Override
    public void setBiome(int x, int y, int z, BiomeType biome) {
        this.checkBiomeBounds(x, y, z);
        ((Chunk)this.func_72964_e(x >> 4, z >> 4)).setBiome(x, y, z, biome);
    }

    @Override
    public Collection<Entity> getEntities() {
        return Lists.newArrayList((Iterable)this.field_72996_f);
    }

    @Override
    public Collection<Entity> getEntities(Predicate<Entity> filter) {
        return this.func_175644_a(net.minecraft.entity.Entity.class, Functional.java8ToGuava(filter));
    }

    @Override
    public Entity createEntity(EntityType type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return this.createEntity(type, position, false);
    }

    @Override
    public Entity createEntityNaturally(EntityType type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return this.createEntity(type, position, true);
    }

    private Entity createEntity(EntityType type, Vector3d position, boolean naturally) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkNotNull((Object)type, (Object)"The entity type cannot be null!");
        Preconditions.checkNotNull((Object)position, (Object)"The position cannot be null!");
        Entity entity = null;
        Class<? extends Entity> entityClass = type.getEntityClass();
        double x = position.getX();
        double y = position.getY();
        double z = position.getZ();
        if (entityClass.isAssignableFrom(EntityPlayerMP.class) || entityClass.isAssignableFrom(EntityDragonPart.class)) {
            throw new IllegalArgumentException("Cannot construct " + type.getId() + " please look to using entity types correctly!");
        }
        net.minecraft.world.World world = (net.minecraft.world.World)this;
        if (entityClass.isAssignableFrom(EntityLightningBolt.class)) {
            entity = (Entity)new EntityLightningBolt(world, x, y, z, false);
        } else if (entityClass.isAssignableFrom(EntityEnderPearl.class)) {
            EntityArmorStand tempEntity = new EntityArmorStand(world, x, y, z);
            tempEntity.field_70163_u -= (double)tempEntity.func_70047_e();
            entity = (Entity)new EntityEnderPearl(world, (EntityLivingBase)tempEntity);
            ((EnderPearl)entity).setShooter(ProjectileSource.UNKNOWN);
        }
        if (entityClass.isAssignableFrom(EntityFallingBlock.class)) {
            entity = (Entity)new EntityFallingBlock(world, x, y, z, Blocks.field_150354_m.func_176223_P());
        } else if (entityClass.isAssignableFrom(EntityItem.class)) {
            entity = (Entity)new EntityItem(world, x, y, z, new ItemStack(Blocks.field_150348_b));
        }
        if (entity == null) {
            try {
                entity = (Entity)ConstructorUtils.invokeConstructor(entityClass, (Object[])new Object[]{this});
                ((net.minecraft.entity.Entity)entity).func_70107_b(x, y, z);
            }
            catch (Exception e) {
                throw new RuntimeException("There was an issue attempting to construct " + type.getId(), e);
            }
        }
        if (naturally && entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_180482_a(world.func_175649_E(new BlockPos(x, y, z)), null);
        }
        if (entity instanceof EntityPainting) {
            ((EntityPainting)entity).field_70522_e = EntityPainting.EnumArt.KEBAB;
        }
        return entity;
    }

    @Override
    public Optional<Entity> createEntity(DataContainer entityContainer) {
        return Optional.empty();
    }

    @Override
    public Optional<Entity> createEntity(DataContainer entityContainer, Vector3d position) {
        return Optional.empty();
    }

    @Override
    public Optional<Entity> restoreSnapshot(EntitySnapshot snapshot, Vector3d position) {
        EntitySnapshot entitySnapshot = (EntitySnapshot)snapshot.withLocation(new Location<World>(this, position));
        return entitySnapshot.restore();
    }

    @Override
    public WorldBorder getWorldBorder() {
        return (WorldBorder)this.shadow$func_175723_af();
    }

    @Override
    public ChunkPreGenerate.Builder newChunkPreGenerate(Vector3d center, double diameter) {
        return new SpongeChunkPreGenerateTask.Builder(this, center, diameter);
    }

    @Override
    public Dimension getDimension() {
        return (Dimension)this.field_73011_w;
    }

    @Override
    public Optional<Entity> getEntity(UUID uuid) {
        for (net.minecraft.entity.Entity entity : this.field_72996_f) {
            if (!entity.func_110124_au().equals(uuid)) continue;
            return Optional.of((Entity)entity);
        }
        return Optional.empty();
    }

    @Override
    public Iterable<Chunk> getLoadedChunks() {
        if (this.field_72995_K) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)((WorldServer)this).func_72863_F().func_189548_a());
    }

    @Override
    public boolean unloadChunk(Chunk chunk) {
        Preconditions.checkArgument((chunk != null ? 1 : 0) != 0, (Object)"Chunk cannot be null!");
        return chunk.unloadChunk();
    }

    @Override
    public WorldProperties getProperties() {
        return (WorldProperties)this.field_72986_A;
    }

    @Override
    public Context getContext() {
        if (this.worldContext == null) {
            WorldInfo worldInfo = this.func_72912_H();
            if (worldInfo == null) {
                worldInfo = new WorldInfo(new WorldSettings(0L, GameType.NOT_SET, false, false, WorldType.field_77137_b), "sponge$dummy_World");
            }
            this.worldContext = new Context("world", worldInfo.func_76065_j());
        }
        return this.worldContext;
    }

    @Override
    public Optional<org.spongepowered.api.block.tileentity.TileEntity> getTileEntity(int x, int y, int z) {
        TileEntity tileEntity = this.func_175625_s(new BlockPos(x, y, z));
        if (tileEntity == null) {
            return Optional.empty();
        }
        return Optional.of((org.spongepowered.api.block.tileentity.TileEntity)tileEntity);
    }

    @Override
    public Vector3i getBiomeMin() {
        return BIOME_MIN;
    }

    @Override
    public Vector3i getBiomeMax() {
        return BIOME_MAX;
    }

    @Override
    public Vector3i getBiomeSize() {
        return BIOME_SIZE;
    }

    @Override
    public Vector3i getBlockMin() {
        return BLOCK_MIN;
    }

    @Override
    public Vector3i getBlockMax() {
        return BLOCK_MAX;
    }

    @Override
    public Vector3i getBlockSize() {
        return BLOCK_SIZE;
    }

    @Override
    public boolean containsBiome(int x, int y, int z) {
        return VecHelper.inBounds(x, y, z, BIOME_MIN, BIOME_MAX);
    }

    @Override
    public boolean containsBlock(int x, int y, int z) {
        return VecHelper.inBounds(x, y, z, BLOCK_MIN, BLOCK_MAX);
    }

    private void checkBiomeBounds(int x, int y, int z) {
        if (!this.containsBiome(x, y, z)) {
            throw new PositionOutOfBoundsException(new Vector3i(x, y, z), BIOME_MIN, BIOME_MAX);
        }
    }

    private void checkBlockBounds(int x, int y, int z) {
        if (!this.containsBlock(x, y, z)) {
            throw new PositionOutOfBoundsException(new Vector3i(x, y, z), BLOCK_MIN, BLOCK_MAX);
        }
    }

    @Override
    public void sendMessage(ChatType type, Text message) {
        Preconditions.checkNotNull((Object)type, (Object)"type");
        Preconditions.checkNotNull((Object)message, (Object)"message");
        for (Player player : this.getPlayers()) {
            player.sendMessage(type, message);
        }
    }

    @Override
    public void sendTitle(Title title) {
        Preconditions.checkNotNull((Object)title, (Object)"title");
        for (Player player : this.getPlayers()) {
            player.sendTitle(title);
        }
    }

    @Override
    public void resetTitle() {
        this.getPlayers().forEach(Viewer::resetTitle);
    }

    @Override
    public void clearTitle() {
        this.getPlayers().forEach(Viewer::clearTitle);
    }

    @Override
    public Collection<org.spongepowered.api.block.tileentity.TileEntity> getTileEntities() {
        return Lists.newArrayList(this.field_147482_g);
    }

    @Override
    public Collection<org.spongepowered.api.block.tileentity.TileEntity> getTileEntities(Predicate<org.spongepowered.api.block.tileentity.TileEntity> filter) {
        return this.field_147482_g.stream().filter(filter).collect(Collectors.toList());
    }

    @Override
    public void triggerExplosion(org.spongepowered.api.world.explosion.Explosion explosion, Cause cause) {
        Preconditions.checkNotNull((Object)explosion, (Object)"explosion");
        Location<World> origin = explosion.getLocation();
        Preconditions.checkNotNull(origin, (Object)"location");
        this.func_72885_a(EntityUtil.toNullableNative(explosion.getSourceExplosive().orElse(null)), origin.getX(), origin.getY(), origin.getZ(), explosion.getRadius(), explosion.canCauseFire(), explosion.shouldBreakBlocks());
    }

    @Override
    public Extent getExtentView(Vector3i newMin, Vector3i newMax) {
        this.checkBlockBounds(newMin.getX(), newMin.getY(), newMin.getZ());
        this.checkBlockBounds(newMax.getX(), newMax.getY(), newMax.getZ());
        return new ExtentViewDownsize(this, newMin, newMax);
    }

    @Override
    public MutableBiomeVolumeWorker<World> getBiomeWorker() {
        return new SpongeMutableBiomeVolumeWorker<World>(this);
    }

    @Override
    public MutableBlockVolumeWorker<World> getBlockWorker(Cause cause) {
        return new SpongeMutableBlockVolumeWorker<World>(this, cause);
    }

    @Override
    public BlockSnapshot createSnapshot(int x, int y, int z) {
        if (!this.containsBlock(x, y, z)) {
            return BlockSnapshot.NONE;
        }
        MixinWorld world = this;
        BlockState state = world.getBlock(x, y, z);
        Optional<org.spongepowered.api.block.tileentity.TileEntity> te = world.getTileEntity(x, y, z);
        SpongeBlockSnapshotBuilder builder = new SpongeBlockSnapshotBuilder().blockState(state).worldId(world.getUniqueId()).position(new Vector3i(x, y, z));
        Optional<UUID> creator = this.getCreator(x, y, z);
        Optional<UUID> notifier = this.getNotifier(x, y, z);
        if (creator.isPresent()) {
            builder.creator(creator.get());
        }
        if (notifier.isPresent()) {
            builder.notifier(notifier.get());
        }
        if (te.isPresent()) {
            org.spongepowered.api.block.tileentity.TileEntity tileEntity = te.get();
            for (DataManipulator<?, ?> manipulator : ((IMixinCustomDataHolder)((Object)tileEntity)).getCustomManipulators()) {
                builder.add((DataManipulator)manipulator);
            }
            NBTTagCompound compound = new NBTTagCompound();
            ((TileEntity)tileEntity).func_189515_b(compound);
            builder.unsafeNbt(compound);
        }
        return builder.build();
    }

    @Override
    public boolean restoreSnapshot(BlockSnapshot snapshot, boolean force, BlockChangeFlag flag, Cause cause) {
        return snapshot.restore(force, flag);
    }

    @Override
    public boolean restoreSnapshot(int x, int y, int z, BlockSnapshot snapshot, boolean force, BlockChangeFlag flag, Cause cause) {
        snapshot = (BlockSnapshot)snapshot.withLocation(new Location<World>(this, new Vector3i(x, y, z)));
        return snapshot.restore(force, flag);
    }

    @Override
    public Optional<UUID> getCreator(int x, int y, int z) {
        return Optional.empty();
    }

    @Override
    public Optional<UUID> getNotifier(int x, int y, int z) {
        return Optional.empty();
    }

    @Override
    public void setCreator(int x, int y, int z, @Nullable UUID uuid) {
    }

    @Override
    public void setNotifier(int x, int y, int z, @Nullable UUID uuid) {
    }

    @Override
    public Optional<AABB> getBlockSelectionBox(int x, int y, int z) {
        this.checkBlockBounds(x, y, z);
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = this.func_180495_p(pos);
        AxisAlignedBB box = state.func_185900_c((IBlockAccess)this, pos);
        try {
            return Optional.of(VecHelper.toSponge(box).offset(x, y, z));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    @Override
    public Set<Entity> getIntersectingEntities(AABB box, Predicate<Entity> filter) {
        Preconditions.checkNotNull((Object)box, (Object)"box");
        Preconditions.checkNotNull(filter, (Object)"filter");
        return this.func_175647_a(net.minecraft.entity.Entity.class, VecHelper.toMC(box), entity -> filter.test((Entity)entity)).stream().map(entity -> (Entity)entity).collect(Collectors.toSet());
    }

    @Override
    public Set<AABB> getIntersectingBlockCollisionBoxes(AABB box) {
        Preconditions.checkNotNull((Object)box, (Object)"box");
        return this.func_184144_a(null, VecHelper.toMC(box)).stream().map(VecHelper::toSponge).collect(Collectors.toSet());
    }

    @Override
    public Set<AABB> getIntersectingCollisionBoxes(Entity owner, AABB box) {
        Preconditions.checkNotNull((Object)owner, (Object)"owner");
        Preconditions.checkNotNull((Object)box, (Object)"box");
        return this.func_184144_a((net.minecraft.entity.Entity)owner, VecHelper.toMC(box)).stream().map(VecHelper::toSponge).collect(Collectors.toSet());
    }

    @Override
    public Set<EntityUniverse.EntityHit> getIntersectingEntities(Vector3d start, Vector3d end, Predicate<EntityUniverse.EntityHit> filter) {
        Preconditions.checkNotNull((Object)start, (Object)"start");
        Preconditions.checkNotNull((Object)end, (Object)"end");
        Vector3d diff = end.sub(start);
        return this.getIntersectingEntities(start, diff.normalize(), diff.length(), filter);
    }

    @Override
    public Set<EntityUniverse.EntityHit> getIntersectingEntities(Vector3d start, Vector3d direction, double distance, Predicate<EntityUniverse.EntityHit> filter) {
        Preconditions.checkNotNull((Object)start, (Object)"start");
        Preconditions.checkNotNull((Object)direction, (Object)"direction");
        Preconditions.checkNotNull(filter, (Object)"filter");
        direction = direction.normalize();
        if (direction.getX() == 0.0 && direction.getZ() == 0.0) {
            return this.getIntersectingEntities(start, direction.getY(), distance, filter);
        }
        int chunkWidth = SpongeChunkLayout.CHUNK_SIZE.getX();
        int xPlaneIncrement = direction.getX() >= 0.0 ? chunkWidth : -chunkWidth;
        int zPlaneIncrement = direction.getZ() >= 0.0 ? chunkWidth : -chunkWidth;
        double xInChunk = GenericMath.mod(start.getX(), (double)chunkWidth);
        double zInChunk = GenericMath.mod(start.getZ(), (double)chunkWidth);
        int xPlaneNext = (int)(start.getX() - xInChunk);
        int zPlaneNext = (int)(start.getZ() - zInChunk);
        if (xInChunk != 0.0 && direction.getX() < 0.0) {
            xPlaneNext += chunkWidth;
        }
        if (zInChunk != 0.0 && direction.getZ() < 0.0) {
            zPlaneNext += chunkWidth;
        }
        double xPlaneT = ((double)xPlaneNext - start.getX()) / direction.getX();
        double zPlaneT = ((double)zPlaneNext - start.getZ()) / direction.getZ();
        double currentT = 0.0;
        double xCurrent = start.getX();
        double yCurrent = start.getY();
        double zCurrent = start.getZ();
        double remainingDistance = distance;
        HashSet<EntityUniverse.EntityHit> intersecting = new HashSet<EntityUniverse.EntityHit>();
        do {
            double zNext;
            double xNext;
            double nextT;
            if (xPlaneT < zPlaneT) {
                nextT = xPlaneT;
                xNext = xPlaneNext;
                zNext = direction.getZ() * nextT + start.getZ();
                xPlaneT = ((double)(xPlaneNext += xPlaneIncrement) - start.getX()) / direction.getX();
            } else {
                nextT = zPlaneT;
                xNext = direction.getX() * nextT + start.getX();
                zNext = zPlaneNext;
                zPlaneT = ((double)(zPlaneNext += zPlaneIncrement) - start.getZ()) / direction.getZ();
            }
            double yNext = direction.getY() * Math.min(nextT, distance) + start.getY();
            if (nextT >= 0.0) {
                IMixinChunk nearIntersections;
                xInChunk = GenericMath.mod(xCurrent, (double)chunkWidth);
                zInChunk = GenericMath.mod(zCurrent, (double)chunkWidth);
                int xChunk = (int)(xCurrent - (xInChunk == 0.0 && direction.getX() < 0.0 ? (double)chunkWidth : xInChunk));
                int zChunk = (int)(zCurrent - (zInChunk == 0.0 && direction.getZ() < 0.0 ? (double)chunkWidth : zInChunk));
                Vector3d chunkStart = currentT <= 0.0 ? start : new Vector3d(xCurrent, yCurrent, zCurrent);
                Optional<Chunk> chunk = this.getChunkAtBlock(xChunk, 0, zChunk);
                if (chunk.isPresent()) {
                    ((IMixinChunk)((Object)chunk.get())).getIntersectingEntities(chunkStart, direction, remainingDistance, filter, chunkStart.getY(), yNext, intersecting);
                }
                if ((nearIntersections = this.getChunkNearIntersections(xChunk, zChunk, xCurrent, zCurrent, xNext, zNext)) != null) {
                    nearIntersections.getIntersectingEntities(chunkStart, direction, remainingDistance, filter, chunkStart.getY(), yNext, intersecting);
                }
                remainingDistance -= nextT - Math.max(0.0, currentT);
            }
            currentT = nextT;
            xCurrent = xNext;
            yCurrent = yNext;
            zCurrent = zNext;
        } while (remainingDistance >= 0.0);
        return intersecting;
    }

    private IMixinChunk getChunkNearIntersections(int xChunk, int zChunk, double xCurrent, double zCurrent, double xNext, double zNext) {
        boolean d24;
        boolean d23;
        boolean d22;
        boolean d21;
        int chunkWidth = SpongeChunkLayout.CHUNK_SIZE.getX();
        Vector2d c1 = new Vector2d(xChunk, zChunk);
        Vector2d c2 = new Vector2d(xChunk + chunkWidth, zChunk);
        Vector2d c3 = new Vector2d(xChunk, zChunk + chunkWidth);
        Vector2d c4 = new Vector2d(xChunk + chunkWidth, zChunk + chunkWidth);
        int nearDistance2 = 4;
        boolean d11 = c1.distanceSquared(xCurrent, zCurrent) <= 4.0;
        boolean bl = d21 = c1.distanceSquared(xNext, zNext) <= 4.0;
        if (d11 && d21) {
            return this.getChunkAtBlock(xChunk - chunkWidth, 0, zChunk - chunkWidth).orElse(null);
        }
        boolean d12 = c2.distanceSquared(xCurrent, zCurrent) <= 4.0;
        boolean bl2 = d22 = c2.distanceSquared(xNext, zNext) <= 4.0;
        if (d12 && d22) {
            return this.getChunkAtBlock(xChunk + chunkWidth, 0, zChunk - chunkWidth).orElse(null);
        }
        boolean d13 = c3.distanceSquared(xCurrent, zCurrent) <= 4.0;
        boolean bl3 = d23 = c3.distanceSquared(xNext, zNext) <= 4.0;
        if (d13 && d23) {
            return this.getChunkAtBlock(xChunk - chunkWidth, 0, zChunk + chunkWidth).orElse(null);
        }
        boolean d14 = c4.distanceSquared(xCurrent, zCurrent) <= 4.0;
        boolean bl4 = d24 = c4.distanceSquared(xNext, zNext) <= 4.0;
        if (d14 && d24) {
            return this.getChunkAtBlock(xChunk + chunkWidth, 0, zChunk + chunkWidth).orElse(null);
        }
        if (d11 && d23 || d21 && d13) {
            return this.getChunkAtBlock(xChunk - chunkWidth, 0, zChunk).orElse(null);
        }
        if (d11 && d22 || d21 && d12) {
            return this.getChunkAtBlock(xChunk, 0, zChunk - chunkWidth).orElse(null);
        }
        if (d14 && d22 || d24 && d12) {
            return this.getChunkAtBlock(xChunk + chunkWidth, 0, zChunk).orElse(null);
        }
        if (d14 && d23 || d24 && d13) {
            return this.getChunkAtBlock(xChunk, 0, zChunk + chunkWidth).orElse(null);
        }
        return null;
    }

    private Set<EntityUniverse.EntityHit> getIntersectingEntities(Vector3d start, double yDirection, double distance, Predicate<EntityUniverse.EntityHit> filter) {
        HashSet<EntityUniverse.EntityHit> intersecting = new HashSet<EntityUniverse.EntityHit>();
        Vector3d direction = yDirection < 0.0 ? Vector3d.UNIT_Y.negate() : Vector3d.UNIT_Y;
        double endY = start.getY() + yDirection * distance;
        Vector3i chunkPos = SpongeChunkLayout.instance.forceToChunk(start.toInt());
        ((IMixinChunk)((Object)this.getChunk(chunkPos).get())).getIntersectingEntities(start, direction, distance, filter, start.getY(), endY, intersecting);
        int nearDistance = 2;
        Vector3i chunkBlockPos = SpongeChunkLayout.instance.forceToWorld(chunkPos);
        if (start.getX() - (double)chunkBlockPos.getX() <= 2.0) {
            ((IMixinChunk)((Object)this.getChunk(chunkPos.add(-1, 0, 0)).get())).getIntersectingEntities(start, direction, distance, filter, start.getY(), endY, intersecting);
        }
        if (start.getZ() - (double)chunkBlockPos.getZ() <= 2.0) {
            ((IMixinChunk)((Object)this.getChunk(chunkPos.add(0, 0, -1)).get())).getIntersectingEntities(start, direction, distance, filter, start.getY(), endY, intersecting);
        }
        int chunkWidth = SpongeChunkLayout.CHUNK_SIZE.getX();
        if ((double)(chunkBlockPos.getX() + chunkWidth) - start.getX() <= 2.0) {
            ((IMixinChunk)((Object)this.getChunk(chunkPos.add(1, 0, 0)).get())).getIntersectingEntities(start, direction, distance, filter, start.getY(), endY, intersecting);
        }
        if ((double)(chunkBlockPos.getZ() + chunkWidth) - start.getZ() <= 2.0) {
            ((IMixinChunk)((Object)this.getChunk(chunkPos.add(0, 0, 1)).get())).getIntersectingEntities(start, direction, distance, filter, start.getY(), endY, intersecting);
        }
        return intersecting;
    }

    @Override
    @Nullable
    public EntityPlayer getClosestPlayerToEntityWhoAffectsSpawning(net.minecraft.entity.Entity entity, double distance) {
        return this.getClosestPlayerWhoAffectsSpawning(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, distance);
    }

    @Override
    @Nullable
    public EntityPlayer getClosestPlayerWhoAffectsSpawning(double x, double y, double z, double distance) {
        double bestDistance = -1.0;
        EntityPlayer result = null;
        for (EntityPlayer entity : this.field_73010_i) {
            EntityPlayer player = entity;
            if (player == null || player.field_70128_L || !((IMixinEntityPlayer)player).affectsSpawning()) continue;
            double playerDistance = player.func_70092_e(x, y, z);
            if (!(distance < 0.0) && !(playerDistance < distance * distance) || bestDistance != -1.0 && !(playerDistance < bestDistance)) continue;
            bestDistance = playerDistance;
            result = player;
        }
        return result;
    }

    @Override
    public boolean isFake() {
        if (this.hasChecked) {
            return this.isDefinitelyFake;
        }
        this.isDefinitelyFake = this.field_72995_K || this.field_72986_A == null || !(this instanceof IMixinWorldServer);
        this.hasChecked = true;
        return this.isDefinitelyFake;
    }

    @Redirect(method="isAnyPlayerWithinRangeAt", at=@At(value="INVOKE", target="Lcom/google/common/base/Predicate;apply(Ljava/lang/Object;)Z", remap=false))
    public boolean onIsAnyPlayerWithinRangePredicate(com.google.common.base.Predicate<EntityPlayer> predicate, Object object) {
        EntityPlayer player = (EntityPlayer)object;
        return !player.field_70128_L && ((IMixinEntityPlayer)player).affectsSpawning() && predicate.apply((Object)player);
    }

    @Redirect(method="checkNoEntityCollision(Lnet/minecraft/util/math/AxisAlignedBB;Lnet/minecraft/entity/Entity;)Z", at=@At(value="INVOKE", target="Lnet/minecraft/world/World;getEntitiesWithinAABBExcludingEntity(Lnet/minecraft/entity/Entity;Lnet/minecraft/util/math/AxisAlignedBB;)Ljava/util/List;"))
    public List<net.minecraft.entity.Entity> filterInvisibile(net.minecraft.world.World world, net.minecraft.entity.Entity entityIn, AxisAlignedBB axisAlignedBB) {
        List entities = world.func_72839_b(entityIn, axisAlignedBB);
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            net.minecraft.entity.Entity entity = (net.minecraft.entity.Entity)iterator.next();
            if (!((IMixinEntity)entity).isVanished() || !((IMixinEntity)entity).ignoresCollision()) continue;
            iterator.remove();
        }
        return entities;
    }

    @Redirect(method="getClosestPlayer(DDDDLcom/google/common/base/Predicate;)Lnet/minecraft/entity/player/EntityPlayer;", at=@At(value="INVOKE", target="Lcom/google/common/base/Predicate;apply(Ljava/lang/Object;)Z", remap=false))
    private boolean onGetClosestPlayerCheck(com.google.common.base.Predicate<net.minecraft.entity.Entity> predicate, Object entityPlayer) {
        EntityPlayer player = (EntityPlayer)entityPlayer;
        IMixinEntity mixinEntity = (IMixinEntity)player;
        return predicate.apply((Object)player) && !mixinEntity.isVanished();
    }

    @Inject(method="playSound(Lnet/minecraft/entity/player/EntityPlayer;DDDLnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V", at={@At(value="HEAD")}, cancellable=true)
    private void spongePlaySoundAtEntity(EntityPlayer entity, double x, double y, double z, SoundEvent name, SoundCategory category, float volume, float pitch, CallbackInfo callbackInfo) {
        if (entity instanceof IMixinEntity && ((IMixinEntity)entity).isVanished()) {
            callbackInfo.cancel();
        }
    }

    @Override
    public void sendBlockChange(int x, int y, int z, BlockState state) {
        Preconditions.checkNotNull((Object)state, (Object)"state");
        SPacketBlockChange packet = new SPacketBlockChange();
        packet.field_179828_a = new BlockPos(x, y, z);
        packet.field_148883_d = BlockUtil.toNative(state);
        for (EntityPlayer player : this.field_73010_i) {
            if (!(player instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)packet);
        }
    }

    @Override
    public void resetBlockChange(int x, int y, int z) {
        SPacketBlockChange packet = new SPacketBlockChange((net.minecraft.world.World)this, new BlockPos(x, y, z));
        for (EntityPlayer player : this.field_73010_i) {
            if (!(player instanceof EntityPlayerMP)) continue;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)packet);
        }
    }

    @Redirect(method="updateEntities", at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;onUpdate()V"))
    protected void onUpdateWeatherEffect(net.minecraft.entity.Entity entityIn) {
        entityIn.func_70071_h_();
    }

    @Redirect(method="updateEntities", at=@At(value="INVOKE", target="Lnet/minecraft/util/ITickable;update()V"))
    protected void onUpdateTileEntities(ITickable tile) {
        tile.func_73660_a();
    }

    @Redirect(method="updateEntityWithOptionalForce", at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;onUpdate()V"))
    protected void onCallEntityUpdate(net.minecraft.entity.Entity entity) {
        entity.func_70071_h_();
    }

    @Redirect(method="updateEntityWithOptionalForce", at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;updateRidden()V"))
    protected void onCallEntityRidingUpdate(net.minecraft.entity.Entity entity) {
        entity.func_70098_U();
    }

    @Redirect(method="addTileEntity", at=@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=1, remap=false))
    public boolean onAddTileEntity(List<TileEntity> list, Object tile) {
        if (!this.field_72995_K && !this.canTileUpdate((TileEntity)tile)) {
            return false;
        }
        return list.add((TileEntity)tile);
    }

    private boolean canTileUpdate(TileEntity tile) {
        org.spongepowered.api.block.tileentity.TileEntity spongeTile = (org.spongepowered.api.block.tileentity.TileEntity)tile;
        return spongeTile.getType() == null || ((SpongeTileEntityType)spongeTile.getType()).canTick();
    }

    @Inject(method="getPlayerEntityByUUID", at={@At(value="HEAD")}, cancellable=true)
    public void onGetPlayerEntityByUUID(UUID uuid, CallbackInfoReturnable<UUID> cir) {
        if (uuid == null) {
            cir.setReturnValue(null);
        }
    }

    @Overwrite
    public boolean func_175678_i(BlockPos pos) {
        net.minecraft.world.chunk.Chunk chunk = ((IMixinChunkProviderServer)this.field_73020_y).getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        if (chunk == null || chunk.field_189550_d) {
            return false;
        }
        return chunk.func_177444_d(pos);
    }

    @Override
    public int getRawBlockLight(BlockPos pos, EnumSkyBlock lightType) {
        return this.func_175638_a(pos, lightType);
    }

    @Inject(method="getRawLight", at={@At(value="INVOKE", target="Lnet/minecraft/world/World;getBlockState(Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/block/state/IBlockState;")}, cancellable=true)
    private void onLightGetBlockState(BlockPos pos, EnumSkyBlock enumSkyBlock, CallbackInfoReturnable<Integer> cir) {
        net.minecraft.world.chunk.Chunk chunk = !this.field_72995_K ? ((IMixinChunkProviderServer)((WorldServer)this).func_72863_F()).getLoadedChunkWithoutMarkingActive(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4) : this.func_175726_f(pos);
        if (chunk == null || chunk.field_189550_d) {
            cir.setReturnValue(0);
        }
    }

    @Overwrite
    public IBlockState func_180495_p(BlockPos pos) {
        if (((IMixinBlockPos)pos).isInvalidYPosition()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        net.minecraft.world.chunk.Chunk chunk = this.func_175726_f(pos);
        return chunk.func_177435_g(pos);
    }

    @Overwrite
    @Nullable
    public TileEntity func_175625_s(BlockPos pos) {
        if (((IMixinBlockPos)pos).isInvalidYPosition()) {
            return null;
        }
        TileEntity tileentity = null;
        if (this.field_147481_N) {
            tileentity = this.func_189508_F(pos);
        }
        if (tileentity == null) {
            if (!this.field_72995_K && !SpongeImpl.getServer().func_152345_ab()) {
                return this.func_175726_f(pos).func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
            }
            tileentity = this.func_175726_f(pos).func_177424_a(pos, Chunk.EnumCreateEntityType.IMMEDIATE);
        }
        if (tileentity == null) {
            tileentity = this.func_189508_F(pos);
        }
        return tileentity;
    }

    @Redirect(method="checkLightFor", at=@At(value="INVOKE", target="Lnet/minecraft/world/World;isAreaLoaded(Lnet/minecraft/util/math/BlockPos;IZ)Z"))
    protected boolean spongeIsAreaLoadedForCheckingLight(net.minecraft.world.World thisWorld, BlockPos pos, int radius, boolean allowEmtpy, EnumSkyBlock lightType, BlockPos samePosition) {
        return this.func_175648_a(pos, radius, allowEmtpy);
    }

    @Overwrite
    public boolean func_175701_a(BlockPos pos) {
        return ((IMixinBlockPos)pos).isValidPosition();
    }

    @Overwrite
    public boolean func_189509_E(BlockPos pos) {
        return ((IMixinBlockPos)pos).isInvalidYPosition();
    }

    @Overwrite
    public int func_175642_b(EnumSkyBlock type, BlockPos pos) {
        if (pos.func_177956_o() < 0) {
            pos = new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p());
        }
        if (!((IMixinBlockPos)pos).isValidPosition()) {
            return type.field_77198_c;
        }
        net.minecraft.world.chunk.Chunk chunk = this.func_175726_f(pos);
        return chunk.func_177413_a(type, pos);
    }

    @Overwrite
    public void func_175653_a(EnumSkyBlock type, BlockPos pos, int lightValue) {
        if (((IMixinBlockPos)pos).isValidPosition() && this.func_175667_e(pos)) {
            net.minecraft.world.chunk.Chunk chunk = this.func_175726_f(pos);
            chunk.func_177431_a(type, pos, lightValue);
            this.func_175679_n(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public boolean func_184143_b(AxisAlignedBB bbox) {
        ArrayList list = Lists.newArrayList();
        int i = MathHelper.func_76128_c((double)bbox.field_72340_a) - 1;
        int j = MathHelper.func_76143_f((double)bbox.field_72336_d) + 1;
        int k = MathHelper.func_76128_c((double)bbox.field_72338_b) - 1;
        int l = MathHelper.func_76143_f((double)bbox.field_72337_e) + 1;
        int i1 = MathHelper.func_76128_c((double)bbox.field_72339_c) - 1;
        int j1 = MathHelper.func_76143_f((double)bbox.field_72334_f) + 1;
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.func_185346_s();
        try {
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = i1; l1 < j1; ++l1) {
                    int i2 = (k1 != i && k1 != j - 1 ? 0 : 1) + (l1 != i1 && l1 != j1 - 1 ? 0 : 1);
                    if (i2 == 2 || !this.func_175667_e((BlockPos)blockpos$pooledmutableblockpos.func_181079_c(k1, 64, l1))) continue;
                    for (int j2 = k; j2 < l; ++j2) {
                        boolean flag;
                        if (i2 > 0 && (j2 == k || j2 == l - 1)) continue;
                        blockpos$pooledmutableblockpos.func_181079_c(k1, j2, l1);
                        if (!((IMixinBlockPos)blockpos$pooledmutableblockpos).isValidXZPosition()) {
                            boolean flag1;
                            boolean bl = flag1 = true;
                            return bl;
                        }
                        IBlockState iblockstate = this.func_180495_p((BlockPos)blockpos$pooledmutableblockpos);
                        iblockstate.func_185908_a((net.minecraft.world.World)this, (BlockPos)blockpos$pooledmutableblockpos, bbox, (List)list, (net.minecraft.entity.Entity)null, false);
                        if (list.isEmpty()) continue;
                        boolean bl = flag = true;
                        return bl;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            blockpos$pooledmutableblockpos.func_185344_t();
        }
    }

    @Overwrite
    public void func_72939_s() {
        this.startEntityGlobalTimings();
        for (int i = 0; i < this.field_73007_j.size(); ++i) {
            net.minecraft.entity.Entity entity = this.field_73007_j.get(i);
            try {
                ++entity.field_70173_aa;
                entity.func_70071_h_();
            }
            catch (Throwable throwable) {
                this.stopTimingForWeatherEntityTickCrash(entity);
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Ticking entity");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being ticked");
                if (entity == null) {
                    crashreportcategory.func_71507_a("Entity", (Object)"~~NULL~~");
                } else {
                    entity.func_85029_a(crashreportcategory);
                }
                SpongeImplHooks.onEntityError(entity, crashreport);
            }
            if (!entity.field_70128_L) continue;
            this.field_73007_j.remove(i--);
        }
        this.stopEntityTickTimingStartEntityRemovalTiming();
        this.field_72996_f.removeAll(this.field_72997_g);
        for (int k = 0; k < this.field_72997_g.size(); ++k) {
            net.minecraft.entity.Entity entity1 = this.field_72997_g.get(k);
            int n = entity1.field_70176_ah;
            int k1 = entity1.field_70164_aj;
            if (!entity1.field_70175_ag || !this.func_175680_a(n, k1, true)) continue;
            this.func_72964_e(n, k1).func_76622_b(entity1);
        }
        for (int l = 0; l < this.field_72997_g.size(); ++l) {
            this.func_72847_b(this.field_72997_g.get(l));
        }
        this.field_72997_g.clear();
        this.stopEntityRemovalTiming();
        this.func_184147_l();
        this.entityActivationCheck();
        for (int i1 = 0; i1 < this.field_72996_f.size(); ++i1) {
            net.minecraft.entity.Entity entity2 = this.field_72996_f.get(i1);
            net.minecraft.entity.Entity entity = entity2.func_184187_bx();
            if (entity != null) {
                if (!entity.field_70128_L && entity.func_184196_w(entity2)) continue;
                entity2.func_184210_p();
            }
            this.startEntityTickTiming();
            if (!entity2.field_70128_L && !(entity2 instanceof EntityPlayerMP)) {
                try {
                    this.func_72870_g(entity2);
                }
                catch (Throwable throwable1) {
                    this.stopTimingTickEntityCrash(entity2);
                    CrashReport crashreport1 = CrashReport.func_85055_a((Throwable)throwable1, (String)"Ticking entity");
                    CrashReportCategory crashreportcategory1 = crashreport1.func_85058_a("Entity being ticked");
                    entity2.func_85029_a(crashreportcategory1);
                    SpongeImplHooks.onEntityError(entity2, crashreport1);
                }
            }
            this.stopEntityTickSectionBeforeRemove();
            this.startEntityRemovalTick();
            if (entity2.field_70128_L) {
                int l1 = entity2.field_70176_ah;
                int i2 = entity2.field_70164_aj;
                if (entity2.field_70175_ag && this.func_175680_a(l1, i2, true)) {
                    this.func_72964_e(l1, i2).func_76622_b(entity2);
                }
                this.field_72996_f.remove(i1--);
                this.func_72847_b(entity2);
            }
            this.stopEntityRemovalTiming();
        }
        this.spongeTileEntityActivation();
        this.field_147481_N = true;
        Iterator<TileEntity> iterator = this.field_175730_i.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos;
            this.startTileTickTimer();
            TileEntity tileentity = iterator.next();
            if (!tileentity.func_145837_r() && tileentity.func_145830_o() && this.func_175667_e(blockPos = tileentity.func_174877_v()) && this.field_175728_M.func_177746_a(blockPos)) {
                try {
                    ((ITickable)tileentity).func_73660_a();
                }
                catch (Throwable throwable) {
                    this.stopTimingTickTileEntityCrash(tileentity);
                    CrashReport crashreport2 = CrashReport.func_85055_a((Throwable)throwable, (String)"Ticking block entity");
                    CrashReportCategory crashreportcategory2 = crashreport2.func_85058_a("Block entity being ticked");
                    tileentity.func_145828_a(crashreportcategory2);
                    SpongeImplHooks.onTileEntityError(tileentity, crashreport2);
                }
            }
            this.stopTileEntityAndStartRemoval();
            if (tileentity.func_145837_r()) {
                net.minecraft.world.chunk.Chunk chunk;
                iterator.remove();
                this.field_147482_g.remove(tileentity);
                if (this.func_175667_e(tileentity.func_174877_v()) && (chunk = this.func_175726_f(tileentity.func_174877_v())).func_177424_a(tileentity.func_174877_v(), Chunk.EnumCreateEntityType.CHECK) == tileentity) {
                    chunk.func_177425_e(tileentity.func_174877_v());
                }
            }
            this.stopTileEntityRemovelInWhile();
        }
        this.field_147481_N = false;
        this.startPendingTileEntityTimings();
        if (!this.field_72995_K && CauseTracker.ENABLED) {
            CauseTracker.getInstance().switchToPhase(GeneralPhase.State.TILE_ENTITY_UNLOAD, PhaseContext.start().add(this.worldNamedCause).complete());
        }
        if (!this.field_147483_b.isEmpty()) {
            for (Object e : this.field_147483_b) {
                SpongeImplHooks.onTileChunkUnload((TileEntity)e);
            }
            this.field_175730_i.removeAll(this.field_147483_b);
            this.field_147482_g.removeAll(this.field_147483_b);
            this.field_147483_b.clear();
        }
        if (!this.field_72995_K && CauseTracker.ENABLED) {
            CauseTracker.getInstance().completePhase(GeneralPhase.State.TILE_ENTITY_UNLOAD);
        }
        if (!this.field_147484_a.isEmpty()) {
            for (int j1 = 0; j1 < this.field_147484_a.size(); ++j1) {
                TileEntity tileEntity = this.field_147484_a.get(j1);
                if (tileEntity.func_145837_r()) continue;
                if (!this.field_147482_g.contains(tileEntity)) {
                    this.func_175700_a(tileEntity);
                }
                if (!this.func_175667_e(tileEntity.func_174877_v())) continue;
                net.minecraft.world.chunk.Chunk chunk = this.func_175726_f(tileEntity.func_174877_v());
                IBlockState iblockstate = chunk.func_177435_g(tileEntity.func_174877_v());
                chunk.func_177426_a(tileEntity.func_174877_v(), tileEntity);
                this.func_184138_a(tileEntity.func_174877_v(), iblockstate, iblockstate, 3);
            }
            this.field_147484_a.clear();
        }
        this.endPendingTileEntities();
    }

    public void spongeTileEntityActivation() {
    }

    public void entityActivationCheck() {
    }

    protected void startEntityGlobalTimings() {
    }

    protected void stopTimingForWeatherEntityTickCrash(net.minecraft.entity.Entity updatingEntity) {
    }

    protected void stopEntityTickTimingStartEntityRemovalTiming() {
    }

    protected void stopEntityRemovalTiming() {
    }

    protected void startEntityTickTiming() {
    }

    protected void stopTimingTickEntityCrash(net.minecraft.entity.Entity updatingEntity) {
    }

    protected void stopEntityTickSectionBeforeRemove() {
    }

    protected void startEntityRemovalTick() {
    }

    protected void startTileTickTimer() {
    }

    protected void stopTimingTickTileEntityCrash(TileEntity updatingTileEntity) {
    }

    protected void stopTileEntityAndStartRemoval() {
    }

    protected void stopTileEntityRemovelInWhile() {
    }

    protected void startPendingTileEntityTimings() {
    }

    protected void endPendingTileEntities() {
    }
}

