/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.DimensionType;
import org.spongepowered.api.world.DimensionTypes;
import org.spongepowered.api.world.GeneratorType;
import org.spongepowered.api.world.PortalAgentType;
import org.spongepowered.api.world.PortalAgentTypes;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.SerializationBehaviors;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.difficulty.Difficulties;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.gen.WorldGeneratorModifier;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.interfaces.world.IMixinWorldInfo;
import org.spongepowered.common.interfaces.world.IMixinWorldSettings;
import org.spongepowered.common.registry.type.world.WorldGeneratorModifierRegistryModule;

@NonnullByDefault
@Mixin(value={WorldSettings.class})
@Implements(value={@Interface(iface=WorldArchetype.class, prefix="archetype$")})
public abstract class MixinWorldSettings
implements WorldArchetype,
IMixinWorldSettings {
    @Shadow
    private boolean field_77168_f;
    @Shadow
    private String field_82751_h;
    private String id;
    private String name;
    private DimensionType dimensionType = DimensionTypes.OVERWORLD;
    private Difficulty difficulty = Difficulties.NORMAL;
    private SerializationBehavior serializationBehavior = SerializationBehaviors.AUTOMATIC;
    private DataContainer generatorSettings = DataContainer.createNew();
    private boolean isEnabled = true;
    private boolean loadOnStartup = true;
    private boolean keepSpawnLoaded = true;
    private boolean generateSpawnOnLoad = false;
    private boolean pvpEnabled = true;
    private boolean generateBonusChest = false;
    private boolean fromBuilder = false;
    private PortalAgentType portalAgentType;
    private Collection<WorldGeneratorModifier> generatorModifiers = ImmutableList.of();
    private boolean seedRandomized = false;

    @Shadow
    public abstract long shadow$func_77160_d();

    @Shadow
    public abstract GameType func_77162_e();

    @Shadow
    public abstract boolean func_77158_f();

    @Shadow
    public abstract boolean func_77164_g();

    @Shadow
    public abstract WorldType func_77165_h();

    @Shadow
    public abstract boolean shadow$func_77163_i();

    @Inject(method="<init>(Lnet/minecraft/world/storage/WorldInfo;)V", at={@At(value="RETURN")})
    public void onConstruct(WorldInfo info, CallbackInfo ci) {
        WorldProperties properties = (WorldProperties)info;
        if (((IMixinWorldInfo)((Object)properties)).getWorldConfig() != null) {
            this.dimensionType = properties.getDimensionType();
            this.difficulty = properties.getDifficulty();
            this.serializationBehavior = properties.getSerializationBehavior();
            this.generatorSettings = properties.getGeneratorSettings().copy();
            this.isEnabled = properties.isEnabled();
            this.loadOnStartup = properties.loadOnStartup();
            this.keepSpawnLoaded = properties.doesKeepSpawnLoaded();
            this.generateSpawnOnLoad = properties.doesGenerateSpawnOnLoad();
            this.pvpEnabled = properties.isPVPEnabled();
            this.generateBonusChest = properties.doesGenerateBonusChest();
            WorldGeneratorModifierRegistryModule.getInstance().checkAllRegistered(properties.getGeneratorModifiers());
            this.generatorModifiers = ImmutableList.copyOf(properties.getGeneratorModifiers());
        }
    }

    @Intrinsic
    public long archetype$getSeed() {
        return this.shadow$func_77160_d();
    }

    @Override
    public boolean isSeedRandomized() {
        return this.seedRandomized;
    }

    @Override
    public void setRandomSeed(boolean state) {
        this.seedRandomized = state;
    }

    @Inject(method="setGeneratorOptions", at={@At(value="RETURN")})
    public void onSetGeneratorOptions(String generatorOptions, CallbackInfoReturnable<WorldSettings> cir) {
        DataContainer settings = null;
        try {
            settings = DataFormats.JSON.read(generatorOptions);
        }
        catch (JsonParseException | IOException throwable) {
            // empty catch block
        }
        if (settings == null) {
            settings = DataContainer.createNew().set(DataQueries.WORLD_CUSTOM_SETTINGS, (Object)generatorOptions);
        }
        this.generatorSettings = settings;
    }

    @Override
    public GameMode getGameMode() {
        return (GameMode)this.func_77162_e();
    }

    @Override
    public GeneratorType getGeneratorType() {
        return (GeneratorType)this.func_77165_h();
    }

    @Override
    public boolean usesMapFeatures() {
        return this.func_77164_g();
    }

    @Override
    public boolean isHardcore() {
        return this.func_77158_f();
    }

    @Intrinsic
    public boolean archetype$areCommandsAllowed() {
        return this.shadow$func_77163_i();
    }

    @Override
    public boolean doesGenerateBonusChest() {
        return this.generateBonusChest;
    }

    @Override
    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    @Override
    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    @Override
    public PortalAgentType getPortalAgentType() {
        if (this.portalAgentType == null) {
            this.portalAgentType = PortalAgentTypes.DEFAULT;
        }
        return this.portalAgentType;
    }

    @Override
    public void setPortalAgentType(PortalAgentType type) {
        this.portalAgentType = type;
    }

    @Override
    public DataContainer getGeneratorSettings() {
        return this.generatorSettings;
    }

    @Override
    public SerializationBehavior getSerializationBehavior() {
        return this.serializationBehavior;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean loadOnStartup() {
        return this.loadOnStartup;
    }

    @Override
    public boolean doesKeepSpawnLoaded() {
        return this.keepSpawnLoaded;
    }

    @Override
    public boolean doesGenerateSpawnOnLoad() {
        return this.generateSpawnOnLoad;
    }

    @Override
    public boolean isPVPEnabled() {
        return this.pvpEnabled;
    }

    @Override
    public Collection<WorldGeneratorModifier> getGeneratorModifiers() {
        return this.generatorModifiers;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setId(String id) {
        Preconditions.checkNotNull((Object)id);
        if (this.id != null) {
            throw new IllegalStateException("Attempt made to set id twice!");
        }
        this.id = id;
    }

    @Override
    public void setName(String name) {
        Preconditions.checkNotNull((Object)name);
        if (this.name != null) {
            throw new IllegalStateException("Attempt made to set name twice!");
        }
        this.name = name;
    }

    @Override
    public boolean isFromBuilder() {
        return this.fromBuilder;
    }

    @Override
    public void setDimensionType(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    @Override
    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    @Override
    public void setSerializationBehavior(SerializationBehavior behavior) {
        this.serializationBehavior = behavior;
    }

    @Override
    public void setGeneratorSettings(DataContainer generatorSettings) {
        Optional<String> optCustomSettings = generatorSettings.getString(DataQueries.WORLD_CUSTOM_SETTINGS);
        if (optCustomSettings.isPresent()) {
            this.field_82751_h = optCustomSettings.get();
        } else {
            try {
                this.field_82751_h = DataFormats.JSON.write(generatorSettings);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.generatorSettings = generatorSettings;
    }

    @Override
    public void setGeneratorModifiers(ImmutableList<WorldGeneratorModifier> generatorModifiers) {
        this.generatorModifiers = generatorModifiers;
    }

    @Override
    public void setEnabled(boolean state) {
        this.isEnabled = state;
    }

    @Override
    public void setLoadOnStartup(boolean state) {
        this.loadOnStartup = state;
    }

    @Override
    public void setKeepSpawnLoaded(boolean state) {
        this.keepSpawnLoaded = state;
    }

    @Override
    public void setGenerateSpawnOnLoad(boolean state) {
        this.generateSpawnOnLoad = state;
    }

    @Override
    public void setPVPEnabled(boolean state) {
        this.pvpEnabled = state;
    }

    @Override
    public void setCommandsAllowed(boolean state) {
        this.field_77168_f = state;
    }

    @Override
    public void setGenerateBonusChest(boolean state) {
        this.generateBonusChest = state;
    }

    @Override
    public void fromBuilder(boolean state) {
        this.fromBuilder = state;
    }
}

