/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen;

import com.flowpowered.math.vector.Vector3i;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.ChunkProviderFlat;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenStructure;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeGenerationSettings;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.gen.GenerationPopulator;
import org.spongepowered.api.world.gen.Populator;
import org.spongepowered.api.world.gen.WorldGenerator;
import org.spongepowered.api.world.gen.populator.Dungeon;
import org.spongepowered.api.world.gen.populator.Lake;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.world.gen.IPopulatorProvider;
import org.spongepowered.common.world.gen.populators.FilteredPopulator;

@Mixin(value={ChunkProviderFlat.class})
public class MixinChunkProviderFlat
implements GenerationPopulator,
IPopulatorProvider {
    @Shadow
    @Final
    private IBlockState[] field_82700_c;
    @Shadow
    @Final
    private Map<String, MapGenStructure> field_82696_f;
    @Shadow
    @Final
    private boolean field_82697_g;
    @Shadow
    @Final
    private boolean field_82702_h;
    @Shadow
    @Final
    private FlatGeneratorInfo field_82699_e;
    private final Cause providerCause = SpongeImpl.getImplementationCause();

    @Override
    public void addPopulators(WorldGenerator generator) {
        FilteredPopulator filtered;
        Lake lake;
        for (MapGenStructure o : this.field_82696_f.values()) {
            if (!(o instanceof MapGenBase)) continue;
            generator.getGenerationPopulators().add((GenerationPopulator)o);
            if (!(o instanceof MapGenStructure)) continue;
            generator.getPopulators().add((Populator)o);
        }
        if (this.field_82699_e.func_82644_b().containsKey("lake")) {
            lake = Lake.builder().chance(0.25).liquidType((BlockState)Blocks.field_150355_j.func_176223_P()).height(VariableAmount.baseWithRandomAddition(0.0, 256.0)).build();
            filtered = new FilteredPopulator(lake);
            filtered.setRequiredFlags("VILLAGE");
            generator.getPopulators().add(lake);
        }
        if (this.field_82699_e.func_82644_b().containsKey("lava_lake")) {
            lake = Lake.builder().chance(0.125).liquidType((BlockState)Blocks.field_150355_j.func_176223_P()).height(VariableAmount.baseWithVariance(0.0, VariableAmount.baseWithRandomAddition(8.0, VariableAmount.baseWithOptionalAddition(55.0, 193.0, 0.1)))).build();
            filtered = new FilteredPopulator(lake);
            filtered.setRequiredFlags("VILLAGE");
            generator.getPopulators().add(filtered);
        }
        if (this.field_82702_h) {
            Dungeon dungeon = Dungeon.builder().attempts(8).build();
            generator.getPopulators().add(dungeon);
        }
        for (BiomeType type : Sponge.getRegistry().getAllOf(BiomeType.class)) {
            BiomeGenerationSettings settings = generator.getBiomeSettings(type);
            settings.getGroundCoverLayers().clear();
            if (this.field_82697_g) continue;
            settings.getPopulators().clear();
            settings.getGenerationPopulators().clear();
        }
    }

    @Override
    public void populate(World world, MutableBlockVolume buffer, ImmutableBiomeVolume biomes) {
        Vector3i min = buffer.getBlockMin();
        for (int y = 0; y < this.field_82700_c.length; ++y) {
            int y0 = min.getY() + y;
            IBlockState iblockstate = this.field_82700_c[y];
            if (iblockstate == null) continue;
            for (int x = 0; x < 16; ++x) {
                int x0 = min.getX() + x;
                for (int z = 0; z < 16; ++z) {
                    buffer.setBlock(x0, y0, min.getZ() + z, (BlockState)iblockstate, this.providerCause);
                }
            }
        }
    }
}

