/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen;

import com.flowpowered.math.GenericMath;
import com.flowpowered.math.vector.Vector3i;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderOverworld;
import net.minecraft.world.gen.ChunkProviderSettings;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.WoodlandMansion;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.api.world.gen.BiomeGenerator;
import org.spongepowered.api.world.gen.GenerationPopulator;
import org.spongepowered.api.world.gen.Populator;
import org.spongepowered.api.world.gen.WorldGenerator;
import org.spongepowered.api.world.gen.populator.Dungeon;
import org.spongepowered.api.world.gen.populator.Lake;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.interfaces.world.gen.IChunkProviderOverworld;
import org.spongepowered.common.interfaces.world.gen.IPopulatorProvider;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.util.gen.ChunkBufferPrimer;
import org.spongepowered.common.util.gen.ObjectArrayMutableBiomeBuffer;
import org.spongepowered.common.world.gen.WorldGenConstants;
import org.spongepowered.common.world.gen.populators.AnimalPopulator;
import org.spongepowered.common.world.gen.populators.FilteredPopulator;
import org.spongepowered.common.world.gen.populators.SnowPopulator;

@Mixin(value={ChunkProviderOverworld.class})
public abstract class MixinChunkProviderOverworld
implements IChunkProvider,
GenerationPopulator,
IPopulatorProvider,
IChunkProviderOverworld {
    @Shadow
    @Final
    private double[] field_185998_q;
    @Shadow
    @Final
    private boolean field_185996_o;
    @Shadow
    @Final
    private net.minecraft.world.World field_185995_n;
    @Shadow
    private ChunkProviderSettings field_186000_s;
    @Shadow
    @Final
    private Random field_185990_i;
    @Shadow
    @Final
    private MapGenBase field_186003_v;
    @Shadow
    @Final
    private MapGenStronghold field_186004_w;
    @Shadow
    @Final
    private MapGenVillage field_186005_x;
    @Shadow
    @Final
    private MapGenMineshaft field_186006_y;
    @Shadow
    @Final
    private MapGenScatteredFeature field_186007_z;
    @Shadow
    @Final
    private MapGenBase field_185979_A;
    @Shadow
    @Final
    private StructureOceanMonument field_185980_B;
    @Shadow
    @Final
    private WoodlandMansion field_191060_C;
    @Shadow
    private Biome[] field_185981_C;
    private Cause cause = SpongeImpl.getImplementationCause();
    private BiomeGenerator biomegen;
    private boolean isVanilla = true;

    @Shadow
    public abstract void func_185976_a(int var1, int var2, ChunkPrimer var3);

    @Inject(method="<init>", at={@At(value="RETURN")})
    private void onConstruct(net.minecraft.world.World worldIn, long p_i45636_2_, boolean p_i45636_4_, String p_i45636_5_, CallbackInfo ci) {
        if (this.field_186000_s == null) {
            this.field_186000_s = new ChunkProviderSettings.Factory().func_177864_b();
        }
        this.isVanilla = WorldGenConstants.isValid((IChunkGenerator)this, GenerationPopulator.class);
    }

    @Override
    public void setBiomeGenerator(BiomeGenerator biomes) {
        this.biomegen = biomes;
    }

    @Override
    public void addPopulators(WorldGenerator generator) {
        FilteredPopulator filtered;
        Lake lake;
        if (this.field_186000_s.field_177839_r) {
            generator.getGenerationPopulators().add((GenerationPopulator)this.field_186003_v);
        }
        if (this.field_186000_s.field_177850_z) {
            generator.getGenerationPopulators().add((GenerationPopulator)this.field_185979_A);
        }
        if (this.field_186000_s.field_177829_w && this.field_185996_o) {
            generator.getGenerationPopulators().add((GenerationPopulator)this.field_186006_y);
            generator.getPopulators().add((Populator)this.field_186006_y);
        }
        if (this.field_186000_s.field_177831_v && this.field_185996_o) {
            generator.getGenerationPopulators().add((GenerationPopulator)this.field_186005_x);
            generator.getPopulators().add((Populator)this.field_186005_x);
        }
        if (this.field_186000_s.field_177833_u && this.field_185996_o) {
            generator.getGenerationPopulators().add((GenerationPopulator)this.field_186004_w);
            generator.getPopulators().add((Populator)this.field_186004_w);
        }
        if (this.field_186000_s.field_177854_x && this.field_185996_o) {
            generator.getGenerationPopulators().add((GenerationPopulator)this.field_186007_z);
            generator.getPopulators().add((Populator)this.field_186007_z);
        }
        if (this.field_186000_s.field_177852_y && this.field_185996_o) {
            generator.getGenerationPopulators().add((GenerationPopulator)this.field_185980_B);
            generator.getPopulators().add((Populator)this.field_185980_B);
        }
        if (this.field_186000_s.field_191077_z && this.field_185996_o) {
            generator.getGenerationPopulators().add((GenerationPopulator)this.field_191060_C);
            generator.getPopulators().add((Populator)this.field_191060_C);
        }
        if (this.field_186000_s.field_177781_A) {
            lake = Lake.builder().chance(1.0 / (double)this.field_186000_s.field_177782_B).liquidType((BlockState)Blocks.field_150355_j.func_176223_P()).height(VariableAmount.baseWithRandomAddition(0.0, 256.0)).build();
            filtered = new FilteredPopulator(lake, c -> {
                Biome biomegenbase = this.field_185995_n.func_180494_b(VecHelper.toBlockPos(c.getBlockMin()).func_177982_a(16, 0, 16));
                return biomegenbase != Biomes.field_76769_d && biomegenbase != Biomes.field_76786_s;
            });
            filtered.setRequiredFlags("VILLAGE");
            generator.getPopulators().add(filtered);
        }
        if (this.field_186000_s.field_177783_C) {
            lake = Lake.builder().chance(1.0 / (double)this.field_186000_s.field_177777_D).liquidType((BlockState)Blocks.field_150355_j.func_176223_P()).height(VariableAmount.baseWithVariance(0.0, VariableAmount.baseWithRandomAddition(8.0, VariableAmount.baseWithOptionalAddition(55.0, 193.0, 0.1)))).build();
            filtered = new FilteredPopulator(lake);
            filtered.setRequiredFlags("VILLAGE");
            generator.getPopulators().add(filtered);
        }
        if (this.field_186000_s.field_177837_s) {
            Dungeon dungeon = Dungeon.builder().attempts(this.field_186000_s.field_177835_t).build();
            generator.getPopulators().add(dungeon);
        }
        generator.getPopulators().add(new AnimalPopulator());
        generator.getPopulators().add(new SnowPopulator());
    }

    @Override
    public void populate(World world, MutableBlockVolume buffer, ImmutableBiomeVolume biomes) {
        int x = GenericMath.floor((float)buffer.getBlockMin().getX() / 16.0f);
        int z = GenericMath.floor((float)buffer.getBlockMin().getZ() / 16.0f);
        this.field_185990_i.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        this.field_185981_C = this.getBiomesFromGenerator(x, z);
        ChunkBufferPrimer chunkprimer = new ChunkBufferPrimer(buffer);
        this.func_185976_a(x, z, chunkprimer);
        this.setBedrock(buffer);
    }

    private void setBedrock(MutableBlockVolume buffer) {
        Vector3i min = buffer.getBlockMin();
        for (int x = 0; x < 16; ++x) {
            int x0 = min.getX() + x;
            for (int z = 0; z < 16; ++z) {
                int z0 = min.getZ() + z;
                for (int y = 0; y < 6; ++y) {
                    int y0 = min.getY() + y;
                    if (y > this.field_185990_i.nextInt(5)) continue;
                    buffer.setBlock(x0, y0, z0, BlockTypes.BEDROCK.getDefaultState(), this.cause);
                }
            }
        }
    }

    private Biome[] getBiomesFromGenerator(int x, int z) {
        if (this.biomegen instanceof BiomeProvider) {
            return ((BiomeProvider)this.biomegen).func_76937_a(this.field_185981_C, x * 4 - 2, z * 4 - 2, 10, 10);
        }
        ObjectArrayMutableBiomeBuffer buffer = new ObjectArrayMutableBiomeBuffer(new Vector3i(x * 16 - 6, 0, z * 16 - 6), new Vector3i(37, 1, 37));
        this.biomegen.generateBiomes(buffer);
        if (this.field_185981_C == null || this.field_185981_C.length < 100) {
            this.field_185981_C = new Biome[100];
        }
        for (int bx = 0; bx < 40; bx += 4) {
            int absX = bx + x * 16 - 6;
            for (int bz = 0; bz < 40; bz += 4) {
                Biome type;
                int absZ = bz + z * 16 - 6;
                this.field_185981_C[bx / 4 + bz / 4 * 10] = type = buffer.getNativeBiome(absX, 0, absZ);
            }
        }
        return this.field_185981_C;
    }

    @Redirect(method="setBlocksInChunk", at=@At(value="INVOKE", target="Lnet/minecraft/world/biome/BiomeProvider;getBiomesForGeneration([Lnet/minecraft/world/biome/Biome;IIII)[Lnet/minecraft/world/biome/Biome;"))
    private Biome[] onSetBlocksGetBiomesIgnore(BiomeProvider manager, Biome[] biomes, int x, int z, int width, int height) {
        if (this.isVanilla) {
            return biomes;
        }
        return this.field_185995_n.func_72959_q().func_76937_a(this.field_185981_C, x * 4 - 2, z * 4 - 2, 10, 10);
    }
}

