/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.BlockBlob;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldGenBlockBlob.class})
public abstract class MixinWorldGenBlockBlob
implements BlockBlob {
    private BlockState blockState;
    private VariableAmount radius;
    private VariableAmount count;

    @Inject(method="<init>(Lnet/minecraft/block/Block;I)V", at={@At(value="RETURN")})
    public void onConstructed(Block block, int radius, CallbackInfo ci) {
        this.blockState = (BlockState)block.func_176223_P();
        this.radius = VariableAmount.fixed(radius);
        this.count = VariableAmount.baseWithRandomAddition(0.0, 3.0);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.BLOCK_BLOB;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = this.count.getFlooredAmount(random);
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getZ());
            this.func_180709_b(world, random, world.func_175645_m(chunkPos.func_177982_a(x, 0, z)));
        }
    }

    @Overwrite
    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        Block block;
        while (position.func_177956_o() > 3 && (worldIn.func_175623_d(position.func_177977_b()) || (block = worldIn.func_180495_p(position.func_177977_b()).func_177230_c()) != Blocks.field_150349_c && block != Blocks.field_150346_d && block != Blocks.field_150348_b)) {
            position = position.func_177977_b();
        }
        if (position.func_177956_o() <= 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            int j = this.getRadiusInstance(rand);
            int k = this.getRadiusInstance(rand);
            int l = this.getRadiusInstance(rand);
            float f = (float)(j + k + l) * 0.333f + 0.5f;
            for (BlockPos blockpos1 : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
                if (!(blockpos1.func_177951_i((Vec3i)position) <= (double)(f * f))) continue;
                worldIn.func_180501_a(blockpos1, (IBlockState)this.blockState, 4);
            }
            position = position.func_177982_a(-(j + 1) + rand.nextInt(2 + j * 2), 0 - rand.nextInt(2), -(l + 1) + rand.nextInt(2 + l * 2));
        }
        return true;
    }

    private int getRadiusInstance(Random rand) {
        int i = this.radius.getFlooredAmount(rand);
        return i < 0 ? 0 : i;
    }

    @Override
    public BlockState getBlock() {
        return this.blockState;
    }

    @Override
    public void setBlock(BlockState state) {
        this.blockState = state;
    }

    @Override
    public VariableAmount getRadius() {
        return this.radius;
    }

    @Override
    public void setRadius(VariableAmount radius) {
        this.radius = radius;
    }

    @Override
    public VariableAmount getCount() {
        return this.count;
    }

    @Override
    public void setCount(VariableAmount count) {
        this.count = count;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Type", (Object)"BlockBlob").add("Block", (Object)this.blockState).add("Radius", (Object)this.radius).add("Count", (Object)this.count).toString();
    }
}

