/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.data.manipulator.mutable.MobSpawnerData;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.weighted.LootTable;
import org.spongepowered.api.util.weighted.UnmodifiableWeightedTable;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedSerializableObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Dungeon;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.data.processor.common.SpawnerUtils;
import org.spongepowered.common.registry.type.world.gen.DungeonMobRegistryModule;

@Mixin(value={WorldGenDungeons.class})
public abstract class MixinWorldGenDungeons
extends WorldGenerator
implements Dungeon {
    private WeightedTable<EntityArchetype> defaultEntities;
    private VariableAmount attempts;
    @Nullable
    private MobSpawnerData data;
    @Nullable
    private WeightedTable<EntityArchetype> choices;
    private LootTable<ItemStackSnapshot> items;

    @Inject(method="<init>()V", at={@At(value="RETURN")})
    public void onConstructed(CallbackInfo ci) {
        this.attempts = VariableAmount.fixed(8.0);
        this.items = new LootTable();
        this.defaultEntities = new UnmodifiableWeightedTable<EntityArchetype>(DungeonMobRegistryModule.getInstance().getRaw());
    }

    @Redirect(method="generate", at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/MobSpawnerBaseLogic;setEntityId(Lnet/minecraft/util/ResourceLocation;)V"))
    public void onSetEntityName(MobSpawnerBaseLogic logic, ResourceLocation mobName) {
        if (this.data != null) {
            SpawnerUtils.applyData(logic, this.data);
            return;
        }
        if (this.choices != null) {
            WeightedTable<EntityArchetype> choices = this.getChoices().get();
            EntityArchetype entity = choices.get(logic.func_98271_a().field_73012_v).stream().findFirst().orElse(null);
            if (entity == null) {
                return;
            }
            SpawnerUtils.setNextEntity(logic, new WeightedSerializableObject<EntityArchetype>(entity, 1));
            return;
        }
        logic.func_190894_a(mobName);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.DUNGEON;
    }

    @Override
    public void populate(org.spongepowered.api.world.World worldIn, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        World world = (World)worldIn;
        BlockPos chunkPos = new BlockPos(min.getX(), min.getY(), min.getZ());
        int n = this.attempts.getFlooredAmount(random);
        for (int i = 0; i < n; ++i) {
            int x = random.nextInt(size.getX());
            int y = random.nextInt(size.getY());
            int z = random.nextInt(size.getZ());
            this.func_180709_b(world, random, chunkPos.func_177982_a(x, y, z));
        }
    }

    @Override
    public VariableAmount getAttemptsPerChunk() {
        return this.attempts;
    }

    @Override
    public void setAttemptsPerChunk(VariableAmount attempts) {
        this.attempts = (VariableAmount)Preconditions.checkNotNull((Object)attempts, (Object)"attempts");
    }

    @Override
    public Optional<MobSpawnerData> getMobSpawnerData() {
        return Optional.ofNullable(this.data);
    }

    @Override
    public void setMobSpawnerData(MobSpawnerData data) {
        this.data = (MobSpawnerData)Preconditions.checkNotNull((Object)data, (Object)"data");
        this.choices = null;
    }

    @Override
    public Optional<WeightedTable<EntityArchetype>> getChoices() {
        if (this.choices == null && this.data == null) {
            return Optional.of(this.defaultEntities);
        }
        return Optional.ofNullable(this.choices);
    }

    @Override
    public void setChoices(WeightedTable<EntityArchetype> choices) {
        this.choices = choices;
        this.data = null;
    }

    @Override
    public LootTable<ItemStackSnapshot> getPossibleContents() {
        return this.items;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("Type", (Object)"Dungeon").add("PerChunk", (Object)this.attempts).add("Data", (Object)this.data).add("Choices", this.choices).toString();
    }
}

